/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.config.PropertyEnum;
import com.feed_the_beast.ftbl.lib.config.PropertyInt;
import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.api.IBarrelModifiable;
import com.latmod.yabba.api.IYabbaRegistry;
import com.latmod.yabba.api.events.YabbaCreateConfigEvent;
import com.latmod.yabba.api.events.YabbaRegistryEvent;
import com.latmod.yabba.models.ModelCrate;
import com.latmod.yabba.models.ModelPanel;
import com.latmod.yabba.models.ModelSolid;
import com.latmod.yabba.models.ModelSolidBorders;
import com.latmod.yabba.util.EnumRedstoneCompMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class YabbaEventHandler {
    @SubscribeEvent
    public static void onYabbaRegistry(YabbaRegistryEvent event) {
        IYabbaRegistry reg = event.getRegistry();
        for (BlockPlanks.EnumType enumType : BlockPlanks.EnumType.values()) {
            if (enumType != BlockPlanks.EnumType.OAK) {
                reg.addSkin(Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)enumType), "all=blocks/planks_" + enumType.func_176840_c());
            }
            String woodTex = "blocks/log_" + enumType.func_176840_c();
            if (enumType.func_176839_a() < 4) {
                reg.addSkin(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)enumType), "up&down=" + woodTex + "_top,all=" + woodTex);
                continue;
            }
            reg.addSkin(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)enumType), "up&down=" + woodTex + "_top,all=" + woodTex);
        }
        reg.addSkin(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE), "all=blocks/stone");
        for (BlockPlanks.EnumType enumType : BlockStone.EnumType.values()) {
            if (enumType == BlockStone.EnumType.STONE) continue;
            reg.addSkin(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)enumType), "all=blocks/stone_" + enumType.name().toLowerCase());
        }
        reg.addSkin(Blocks.field_150347_e, "all=blocks/cobblestone");
        reg.addSkin(Blocks.field_150341_Y, "all=blocks/cobblestone_mossy");
        reg.addSkin(Blocks.field_150346_d, "all=blocks/dirt");
        reg.addSkin(Blocks.field_150417_aV, "all=blocks/stonebrick");
        reg.addSkin(Blocks.field_150336_V, "all=blocks/brick");
        reg.addSkin(Blocks.field_150343_Z, "all=blocks/obsidian");
        reg.addSkin(Blocks.field_185772_cY, "all=blocks/end_bricks");
        reg.addSkin(Blocks.field_150385_bj, "all=blocks/nether_brick");
        reg.addSkin(Blocks.field_189879_dh, "all=blocks/red_nether_brick");
        reg.addSkin(Blocks.field_180397_cI, "all=blocks/prismarine_bricks");
        reg.addSkin(Blocks.field_150380_bt, "all=blocks/dragon_egg");
        reg.addSkin(Blocks.field_150440_ba, "up&down=minecraft:blocks/melon_top,all=minecraft:blocks/melon_side");
        reg.addSkin(Blocks.field_150423_aK, "up&down=blocks/pumpkin_top,all=blocks/pumpkin_side");
        reg.addSkin(Blocks.field_150432_aD, "all=blocks/ice");
        reg.addSkin(Blocks.field_150359_w, "all=blocks/glass");
        reg.addSkin(Blocks.field_150426_aN, "all=blocks/glowstone");
        reg.addSkin(Blocks.field_189877_df, "all=blocks/magma");
        reg.addSkin(Blocks.field_150323_B, "all=blocks/jukebox_side");
        reg.addSkin((Block)Blocks.field_150355_j, "all=blocks/water_still");
        reg.addSkin((Block)Blocks.field_150353_l, "all=blocks/lava_still");
        reg.addSkin((Block)Blocks.field_150427_aO, "all=blocks/portal");
        reg.addSkin(Blocks.field_150340_R, "all=blocks/gold_block");
        reg.addSkin(Blocks.field_150339_S, "all=blocks/iron_block");
        reg.addSkin(Blocks.field_150368_y, "all=blocks/lapis_block");
        reg.addSkin(Blocks.field_150484_ah, "all=blocks/diamond_block");
        reg.addSkin(Blocks.field_150451_bX, "all=blocks/redstone_block");
        reg.addSkin(Blocks.field_150475_bE, "all=blocks/emerald_block");
        reg.addSkin(Blocks.field_150371_ca, "all=blocks/quartz_block_lines_top");
        reg.addSkin(Blocks.field_150402_ci, "all=blocks/coal_block");
        reg.addSkin(Blocks.field_189880_di, "up&down=blocks/bone_block_top,all=blocks/bone_block_side");
        reg.addSkin(Blocks.field_150407_cf, "up&down=blocks/hay_block_top,all=blocks/hay_block_side");
        reg.addSkin(Blocks.field_150342_X, "up&down=blocks/planks_oak,all=blocks/bookshelf");
        for (BlockPlanks.EnumType enumType : EnumDyeColor.values()) {
            reg.addSkin(Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)enumType), "all=blocks/hardened_clay_stained_" + enumType.func_176610_l());
            reg.addSkin(Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)enumType), "all=blocks/wool_colored_" + enumType.func_176610_l());
        }
        reg.addTier(YabbaCommon.TIER_IRON);
        reg.addTier(YabbaCommon.TIER_GOLD);
        reg.addTier(YabbaCommon.TIER_DMD);
        reg.addModel(new ModelCrate("crate"));
        reg.addModel(new ModelSolid("solid"));
        reg.addModel(new ModelSolidBorders("solid_borders"));
        reg.addModel(new ModelPanel("cover", 0.125f));
        reg.addModel(new ModelPanel("panel", 0.25f));
        reg.addModel(new ModelPanel("slab", 0.5f));
    }

    @SubscribeEvent
    public static void createConfig(YabbaCreateConfigEvent event) {
        IBarrelModifiable barrel = event.getBarrel();
        String group = "yabba";
        event.add(group, "disable_ore_items", (IConfigValue)PropertyBool.create((boolean)false, () -> barrel.getFlag(4), v -> barrel.setFlag(4, (boolean)v)));
        event.add(group, "always_display_data", (IConfigValue)PropertyBool.create((boolean)false, () -> barrel.getFlag(512), v -> barrel.setFlag(512, (boolean)v)));
        event.add(group, "display_bar", (IConfigValue)PropertyBool.create((boolean)false, () -> barrel.getFlag(1024), v -> barrel.setFlag(1024, (boolean)v)));
        if (barrel.getFlag(64)) {
            group = "yabba.redstone";
            event.add(group, "mode", (IConfigValue)PropertyEnum.create(EnumRedstoneCompMode.NAME_MAP, (Enum)EnumRedstoneCompMode.EQUAL, () -> EnumRedstoneCompMode.getMode(barrel.getUpgradeNBT().func_74771_c("RedstoneMode")), v -> barrel.setUpgradeData("RedstoneMode", (NBTBase)new NBTTagByte((byte)v.ordinal()))));
            event.add(group, "item_count", (IConfigValue)PropertyInt.create((int)0, (int)0, (int)Integer.MAX_VALUE, () -> barrel.getUpgradeNBT().func_74762_e("RedstoneItemCount"), v -> barrel.setUpgradeData("RedstoneItemCount", (NBTBase)new NBTTagInt(v))));
        }
        if (barrel.getFlag(128)) {
            group = "yabba.hopper";
            event.add(group, "up", (IConfigValue)PropertyBool.create((boolean)true, () -> barrel.getUpgradeNBT().func_74767_n("HopperUp"), v -> barrel.setUpgradeData("HopperUp", (NBTBase)new NBTTagByte((byte)(v != false ? 1 : 0)))));
            event.add(group, "down", (IConfigValue)PropertyBool.create((boolean)true, () -> barrel.getUpgradeNBT().func_74767_n("HopperDown"), v -> barrel.setUpgradeData("HopperDown", (NBTBase)new NBTTagByte((byte)(v != false ? 1 : 0)))));
            event.add(group, "collect", (IConfigValue)PropertyBool.create((boolean)false, () -> barrel.getUpgradeNBT().func_74767_n("HopperCollect"), v -> barrel.setUpgradeData("HopperCollect", (NBTBase)new NBTTagByte((byte)(v != false ? 1 : 0)))));
        }
    }
}

