/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.utils;

import com.gendeathrow.mputils.core.MPUtils;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Level;

public class StopWatch {
    private boolean isRunning;
    private boolean isPaused;
    private boolean gamePaused;
    private long elapsedNanos;
    private long startTick;
    private long splitTick;

    public StopWatch createTimer(long nano) {
        this.gamePaused = false;
        this.isPaused = false;
        return new StopWatch().setElapsedNanos(nano);
    }

    public StopWatch setElapsedNanos(long nano) {
        this.elapsedNanos = nano;
        return this;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPaused() {
        return this.isPaused || this.gamePaused;
    }

    private boolean isGamePaused() {
        if (!MPUtils.proxy.isClient()) {
            return false;
        }
        return Minecraft.func_71410_x().func_147113_T();
    }

    public StopWatch start() {
        if (this.isRunning) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already running.");
            return this;
        }
        this.isRunning = true;
        this.startTick = System.nanoTime();
        return this;
    }

    public StopWatch stop() {
        long tick = System.nanoTime();
        if (!this.isRunning) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already stopped.");
            return this;
        }
        this.isRunning = false;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    public StopWatch split() {
        long tick = System.nanoTime();
        if (!this.isRunning) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already stopped.");
            return this;
        }
        if (this.isPaused()) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is paused.");
            return this;
        }
        this.splitTick += tick - this.startTick;
        System.out.println(this.splitTick + "< split");
        return this;
    }

    public StopWatch pause() {
        long tick = System.nanoTime();
        if (!this.isRunning) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already stopped.");
            return this;
        }
        if (this.isPaused) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already paused.");
            return this;
        }
        this.isPaused = true;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    public StopWatch resume() {
        long tick = System.nanoTime();
        if (!this.isRunning) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is already stopped.");
            return this;
        }
        if (!this.isPaused) {
            MPUtils.logger.log(Level.WARN, "This stopwatch is not paused.");
            return this;
        }
        this.isPaused = false;
        this.startTick = tick;
        return this;
    }

    public StopWatch reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    private long elapsedNanos() {
        return this.isRunning && !this.isPaused ? System.nanoTime() - this.startTick + this.elapsedNanos : this.elapsedNanos;
    }

    public long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public long getSplit(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.splitTick, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit unit = StopWatch.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return String.format("%.4g %s", value, StopWatch.abbreviate(unit));
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }
}

