/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.commands.client;

import com.gendeathrow.mputils.commands.MP_BaseCommand;
import com.gendeathrow.mputils.configs.ConfigHandler;
import com.gendeathrow.mputils.utils.NBTConverter;
import com.gendeathrow.mputils.utils.Tools;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.oredict.OreDictionary;

public class MP_ItemDump
extends MP_BaseCommand {
    ArrayList options = new ArrayList<String>(Arrays.asList("ore", "nbt", "setPretty", "class", "extendedClass", "<>"));

    @Override
    public boolean validArgs(String[] args) {
        return true;
    }

    @Override
    public String getUsageSuffix() {
        return " [Args:(nbt, ore, setPretty, class, extendedClass, <>)]";
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length >= 1) {
            return this.options;
        }
        return new ArrayList<String>();
    }

    protected String parseStackData(ICommandSender sender, String[] args, ItemStack stack) {
        String itemID = stack.func_77973_b().getRegistryName() + (stack.func_77952_i() != 0 ? ":" + stack.func_77952_i() : "");
        String ore = "";
        String clazz = "";
        String extend = "";
        String nbt = "";
        boolean isPretty = false;
        String formatString = "";
        String format = "";
        String returnback = "";
        ArrayList<String> printout = new ArrayList<String>();
        printout.add(itemID);
        if (args.length > 1) {
            String completeCommand = "";
            for (String arg : args) {
                completeCommand = completeCommand + " " + arg;
            }
            boolean carretFlag = false;
            boolean oreFlag = false;
            boolean nbtflag = false;
            boolean classFlag = false;
            boolean extendFlag = false;
            boolean skipFlag = false;
            for (String arg : args) {
                if (!arg.toLowerCase().trim().equals("setpretty")) continue;
                isPretty = true;
            }
            for (String arg : args) {
                if (arg.toLowerCase().trim().equals("<>") && !carretFlag && !skipFlag) {
                    itemID = "<" + itemID + ">";
                    carretFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equalsIgnoreCase("ore") && !oreFlag && !skipFlag) {
                    ore = ore + " Ores:[";
                    boolean f = false;
                    for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                        ore = ore + (!f ? " ore:" : " | ore:") + OreDictionary.getOreName((int)id) + (isPretty ? ConfigHandler.NEW_LINE : ",");
                        printout.add("     <ore:" + OreDictionary.getOreName((int)id) + ">");
                        f = true;
                    }
                    ore = ore + "]";
                    oreFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("extendedclass") && !extendFlag && !skipFlag) {
                    List<Class> extendedClasses = Tools.getAllSuperclasses(stack.func_77973_b().getClass());
                    extend = extend + " Extended Classes:[";
                    Object object = extendedClasses.iterator();
                    while (object.hasNext()) {
                        Class extendClass = (Class)object.next();
                        extend = extend + extendClass.getCanonicalName() + (isPretty ? ConfigHandler.NEW_LINE : ",");
                    }
                    extend = extend + "]";
                    printout.add("Extends " + extendedClasses.size() + "x classes (more info on clipboard)");
                    extendFlag = true;
                    continue;
                }
                if (arg.toLowerCase().trim().equals("class") && !classFlag && !skipFlag) {
                    clazz = clazz + " Class: ";
                    clazz = clazz + stack.func_77973_b().getClass().getCanonicalName();
                    printout.add("Class: " + stack.func_77973_b().getClass().getCanonicalName());
                    classFlag = true;
                    continue;
                }
                if (!arg.toLowerCase().trim().equals("nbt") || nbtflag || skipFlag) continue;
                NBTTagCompound nbtdata = stack.func_77978_p();
                nbt = nbt + " NBT:";
                if (nbtdata != null) {
                    GsonBuilder gson = new GsonBuilder();
                    if (isPretty) {
                        gson.setPrettyPrinting();
                    }
                    printout.add("NBT Data Found");
                    nbt = nbt + " " + gson.create().toJson((JsonElement)NBTConverter.NBTtoJSON_Compound(nbtdata, new JsonObject()));
                } else {
                    nbt = nbt + "{NBT Null}";
                }
                nbtflag = true;
            }
        }
        printout.add("---------------");
        for (String print : printout) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(print, new Object[0]));
        }
        if (isPretty) {
            returnback = "-------------------------------------" + ConfigHandler.NEW_LINE;
            returnback = returnback + "ItemID: " + itemID + ConfigHandler.NEW_LINE;
            returnback = returnback + ore + ConfigHandler.NEW_LINE;
            returnback = returnback + clazz + ConfigHandler.NEW_LINE;
            returnback = returnback + extend + ConfigHandler.NEW_LINE;
            returnback = returnback + nbt + ConfigHandler.NEW_LINE;
        } else {
            returnback = itemID + ore + clazz + extend + nbt + ConfigHandler.NEW_LINE;
        }
        return returnback;
    }

    @Override
    public String getCommand() {
        return null;
    }

    @Override
    public void runCommand(CommandBase command, ICommandSender sender, String[] args) {
    }
}

