/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.settings;

import com.gendeathrow.mputils.client.settings.QuickCommandManager;
import com.gendeathrow.mputils.core.MPUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ReportedException;

public class SaveHandler {
    public static final File settingsDir = new File("mputils");
    public static final File settingsFile = new File(settingsDir, "settings.dat");

    public static void loadSettings() {
        NBTTagCompound mainTag = SaveHandler.ReadNBTFile(SaveHandler.getSettingsFile());
        if (mainTag == null || mainTag.func_82582_d()) {
            return;
        }
        QuickCommandManager.load((NBTTagCompound)mainTag);
    }

    public static void saveSettings() {
        NBTTagCompound mainTag = new NBTTagCompound();
        QuickCommandManager.save((NBTTagCompound)mainTag);
        SaveHandler.SaveNBTFile(mainTag);
    }

    private static File getSettingsFile() {
        try {
            if (settingsFile.exists()) {
                return settingsFile;
            }
            settingsDir.mkdirs();
            settingsFile.createNewFile();
            SaveHandler.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return settingsFile;
    }

    public static void SaveNBTFile(NBTTagCompound nbt) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(settingsFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            throw new ReportedException(new CrashReport("An error occured while saving", new Throwable()));
        }
    }

    public static NBTTagCompound ReadNBTFile(File file) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (!file.exists()) {
            MPUtils.logger.warn("File load canceled, file (" + file.getAbsolutePath() + ")does not exist. This is normal for first run.");
            return null;
        }
        MPUtils.logger.info("File load successful.");
        try {
            nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            if (nbt.func_82582_d()) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nbt;
    }
}

