/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.gui;

import com.gendeathrow.mputils.client.gui.elements.NotificationBase;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class NotificationManager
extends Gui {
    private static final ResourceLocation tipsBg = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private Minecraft mc;
    private int width;
    private int height;
    private String title;
    private String description;
    private long notificationTime;
    private NotificationBase theNotification;
    private boolean permanentNotification;
    private ArrayList<NotificationBase> queue = new ArrayList();

    public NotificationManager(Minecraft mc) {
        this.mc = mc;
    }

    public void displayNotification(NotificationBase notification) {
        this.title = notification.title;
        this.description = notification.description;
        this.notificationTime = Minecraft.func_71386_F();
        this.permanentNotification = false;
    }

    public void addQueue(NotificationBase notification) {
        if (notification.shouldNotifiy()) {
            this.queue.add(notification);
        } else {
            notification.LastSeen();
        }
    }

    public boolean hasNextQueue() {
        return this.queue.size() > 0 ? this.queue.get(0) != null : false;
    }

    public NotificationBase getNextQueue() {
        NotificationBase notification = this.queue.get(0);
        if (notification != null) {
            this.queue.remove(0);
            return notification;
        }
        return null;
    }

    public boolean isInQueue(NotificationBase checkagainst) {
        if (this.theNotification == checkagainst) {
            return true;
        }
        return this.queue.contains((Object)checkagainst);
    }

    public void displayUnformattedTip(NotificationBase notificationIn) {
        this.title = notificationIn.title;
        this.description = notificationIn.description;
        this.notificationTime = Minecraft.func_71386_F() + 2500L;
        this.theNotification = notificationIn;
        this.permanentNotification = true;
    }

    private void updateTipWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.width = this.mc.field_71443_c;
        this.height = this.mc.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateTipWindow() {
        if (this.theNotification != null && this.notificationTime != 0L && Minecraft.func_71410_x().field_71439_g != null) {
            double d0 = (double)(Minecraft.func_71386_F() - this.notificationTime) / 6000.0;
            if (!this.permanentNotification) {
                if (d0 < 0.0 || d0 > 1.0) {
                    this.notificationTime = 0L;
                    return;
                }
            } else if (d0 > 0.5) {
                d0 = 0.5;
            }
            this.updateTipWindowScale();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            double d1 = d0 * 2.0;
            if (d1 > 1.0) {
                d1 = 2.0 - d1;
            }
            d1 *= 4.0;
            if ((d1 = 1.0 - d1) < 0.0) {
                d1 = 0.0;
            }
            d1 *= d1;
            d1 *= d1;
            int i = 10;
            int iOffset = 0;
            int j = 0 - (int)(d1 * 36.0);
            this.theNotification.drawNotification(i, j, iOffset);
        } else if (this.hasNextQueue()) {
            this.displayNotification(this.getNextQueue());
        }
    }

    public void clearAchievements() {
    }
}

