/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.util;

import cofh.lib.util.helpers.ServerHelper;
import cofh.thermaldynamics.multiblock.ISingleTick;
import cofh.thermaldynamics.util.WorldGridList;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.WeakHashMap;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    public static final WeakHashMap<World, WorldGridList> HANDLERS = new WeakHashMap();
    public static final LinkedHashSet<WeakReference<ISingleTick>> MULTI_BLOCKS_TO_CALCULATE = new LinkedHashSet();

    public static void addMultiBlockToCalculate(ISingleTick multiBlock) {
        if (multiBlock.world() != null) {
            if (ServerHelper.isServerWorld((World)multiBlock.world())) {
                TickHandler.getTickHandler((World)multiBlock.world()).tickingBlocks.add(multiBlock);
            }
        } else {
            TickHandler.addMultiBlockToNextTickBatch(multiBlock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMultiBlockToNextTickBatch(ISingleTick multiBlock) {
        LinkedHashSet<WeakReference<ISingleTick>> linkedHashSet = MULTI_BLOCKS_TO_CALCULATE;
        synchronized (linkedHashSet) {
            MULTI_BLOCKS_TO_CALCULATE.add(new WeakReference<ISingleTick>(multiBlock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorldGridList getTickHandler(World world) {
        if (ServerHelper.isClientWorld((World)world)) {
            throw new IllegalStateException("World Grid called Client-side");
        }
        WeakHashMap<World, WorldGridList> weakHashMap = HANDLERS;
        synchronized (weakHashMap) {
            WorldGridList worldGridList = HANDLERS.get(world);
            if (worldGridList != null) {
                return worldGridList;
            }
            worldGridList = new WorldGridList(world);
            HANDLERS.put(world, worldGridList);
            return worldGridList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LinkedHashSet<WeakReference<ISingleTick>> linkedHashSet = MULTI_BLOCKS_TO_CALCULATE;
        synchronized (linkedHashSet) {
            if (!MULTI_BLOCKS_TO_CALCULATE.isEmpty()) {
                Iterator iterator = MULTI_BLOCKS_TO_CALCULATE.iterator();
                while (iterator.hasNext()) {
                    ISingleTick multiBlock = (ISingleTick)((WeakReference)iterator.next()).get();
                    if (multiBlock == null) {
                        iterator.remove();
                        continue;
                    }
                    if (multiBlock.world() == null) continue;
                    if (ServerHelper.isServerWorld((World)multiBlock.world())) {
                        TickHandler.getTickHandler((World)multiBlock.world()).tickingBlocks.add(multiBlock);
                    }
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        WeakHashMap<World, WorldGridList> weakHashMap = HANDLERS;
        synchronized (weakHashMap) {
            WorldGridList worldGridList = HANDLERS.get(event.world);
            if (worldGridList == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.START) {
                worldGridList.tickStart();
            } else {
                worldGridList.tickEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Object object = HANDLERS;
        synchronized (object) {
            HANDLERS.remove(world);
            HANDLERS.isEmpty();
        }
        object = MULTI_BLOCKS_TO_CALCULATE;
        synchronized (object) {
            if (!MULTI_BLOCKS_TO_CALCULATE.isEmpty()) {
                Iterator iterator = MULTI_BLOCKS_TO_CALCULATE.iterator();
                while (iterator.hasNext()) {
                    ISingleTick multiBlock = (ISingleTick)((WeakReference)iterator.next()).get();
                    if (multiBlock != null && multiBlock.world() != world) continue;
                    iterator.remove();
                }
            }
        }
    }
}

