/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.util;

import cofh.api.util.ThermalExpansionHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.util.RecipeCover;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TDCrafting {
    public static boolean enableCoverRecipes = true;
    public static boolean useHardenedGlass = true;
    public static boolean useTransposerRecipes = true;

    public static void loadRecipes() {
        ItemStack o;
        ItemStack t;
        enableCoverRecipes = ThermalDynamics.CONFIG.get("Attachment.Cover", "Recipe", true);
        useHardenedGlass = ThermalDynamics.CONFIG.get("Duct.Recipes", "UseHardenedGlass", true);
        useTransposerRecipes = ThermalDynamics.CONFIG.get("Duct.Recipes", "UseFluidTransposer", true);
        String glassHardened = useHardenedGlass ? "blockGlassHardened" : "blockGlass";
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energyBasic.itemStack, (int)6), (Object[])new Object[]{"RRR", "IGI", "RRR", Character.valueOf('I'), "ingotLead", Character.valueOf('G'), "blockGlass", Character.valueOf('R'), "dustRedstone"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.energyHardened.itemStack, (Object[])new Object[]{TDDucts.energyBasic.itemStack, "dustRedstone", "nuggetInvar", "nuggetInvar", "nuggetInvar"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energyHardened.itemStack, (int)3), (Object[])new Object[]{TDDucts.energyBasic.itemStack, TDDucts.energyBasic.itemStack, TDDucts.energyBasic.itemStack, "dustRedstone", "dustRedstone", "dustRedstone", "ingotInvar"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.energySignalum.itemStack, (Object[])new Object[]{TDDucts.energyReinforced.itemStack, "dustRedstone", "nuggetSignalum", "nuggetSignalum", "nuggetSignalum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.energyResonant.itemStack, (Object[])new Object[]{TDDucts.energySignalum.itemStack, "dustRedstone", "nuggetEnderium", "nuggetEnderium", "nuggetEnderium"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energySignalum.itemStack, (int)3), (Object[])new Object[]{TDDucts.energyReinforced.itemStack, TDDucts.energyReinforced.itemStack, TDDucts.energyReinforced.itemStack, "dustRedstone", "dustRedstone", "dustRedstone", "ingotSignalum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energyResonant.itemStack, (int)3), (Object[])new Object[]{TDDucts.energySignalum.itemStack, TDDucts.energySignalum.itemStack, TDDucts.energySignalum.itemStack, "dustRedstone", "dustRedstone", "dustRedstone", "ingotEnderium"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energyReinforcedEmpty.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), glassHardened}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.energySignalumEmpty.itemStack, (Object[])new Object[]{TDDucts.energyReinforcedEmpty.itemStack, "dustRedstone", "nuggetSignalum", "nuggetSignalum", "nuggetSignalum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.energyResonantEmpty.itemStack, (Object[])new Object[]{TDDucts.energySignalumEmpty.itemStack, "dustRedstone", "nuggetEnderium", "nuggetEnderium", "nuggetEnderium"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energySignalumEmpty.itemStack, (int)3), (Object[])new Object[]{TDDucts.energyReinforcedEmpty.itemStack, TDDucts.energyReinforcedEmpty.itemStack, TDDucts.energyReinforcedEmpty.itemStack, "dustRedstone", "dustRedstone", "dustRedstone", "ingotSignalum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.energyResonantEmpty.itemStack, (int)3), (Object[])new Object[]{TDDucts.energySignalumEmpty.itemStack, TDDucts.energySignalumEmpty.itemStack, TDDucts.energySignalumEmpty.itemStack, "dustRedstone", "dustRedstone", "dustRedstone", "ingotEnderium"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)TDDucts.energySuperCondEmpty.itemStack, (Object[])new Object[]{"IGI", "GEG", "IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), glassHardened, Character.valueOf('E'), TDDucts.energyResonant.itemStack}));
        ThermalExpansionHelper.addPulverizerRecipe((int)1600, (ItemStack)TDDucts.energyBasic.itemStack, (ItemStack)new ItemStack(Items.field_151137_ax), (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.nuggetLead, (int)3));
        ThermalExpansionHelper.addPulverizerRecipe((int)1600, (ItemStack)TDDucts.energyHardened.itemStack, (ItemStack)new ItemStack(Items.field_151137_ax, 2), (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.nuggetInvar, (int)3));
        TDCrafting.addTransposerFill(800, TDDucts.energyReinforcedEmpty.itemStack, TDDucts.energyReinforced.itemStack, new FluidStack(TFFluids.fluidRedstone, 200), false);
        TDCrafting.addTransposerFill(800, TDDucts.energySignalumEmpty.itemStack, TDDucts.energySignalum.itemStack, new FluidStack(TFFluids.fluidRedstone, 200), false);
        TDCrafting.addTransposerFill(800, TDDucts.energyResonantEmpty.itemStack, TDDucts.energyResonant.itemStack, new FluidStack(TFFluids.fluidRedstone, 200), false);
        TDCrafting.addTransposerFill(4000, TDDucts.energySuperCondEmpty.itemStack, TDDucts.energySuperCond.itemStack, new FluidStack(TFFluids.fluidCryotheum, 500), false);
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidBasic.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotCopper", Character.valueOf('G'), "blockGlass"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidBasicOpaque.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotCopper", Character.valueOf('G'), "ingotLead"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidHardened.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotInvar", Character.valueOf('G'), glassHardened}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidHardenedOpaque.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotInvar", Character.valueOf('G'), "ingotLead"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.fluidEnergy.itemStack, (Object[])new Object[]{TDDucts.fluidHardened.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.fluidEnergyOpaque.itemStack, (Object[])new Object[]{TDDucts.fluidHardenedOpaque.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidEnergy.itemStack, (int)3), (Object[])new Object[]{TDDucts.fluidHardened.itemStack, TDDucts.fluidHardened.itemStack, TDDucts.fluidHardened.itemStack, "ingotSignalum", "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.fluidEnergyOpaque.itemStack, (int)3), (Object[])new Object[]{TDDucts.fluidHardenedOpaque.itemStack, TDDucts.fluidHardenedOpaque.itemStack, TDDucts.fluidHardenedOpaque.itemStack, "ingotSignalum", "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)TDDucts.fluidSuper.itemStack, (Object[])new Object[]{"IGI", "GEG", "IGI", Character.valueOf('I'), "ingotBronze", Character.valueOf('G'), glassHardened, Character.valueOf('E'), TDDucts.fluidHardened.itemStack}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)TDDucts.fluidSuperOpaque.itemStack, (Object[])new Object[]{"IGI", "GEG", "IGI", Character.valueOf('I'), "ingotBronze", Character.valueOf('G'), glassHardened, Character.valueOf('E'), TDDucts.fluidHardenedOpaque.itemStack}));
        ThermalExpansionHelper.addPulverizerRecipe((int)1600, (ItemStack)TDDucts.fluidBasic.itemStack, (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.nuggetCopper, (int)3));
        ThermalExpansionHelper.addPulverizerRecipe((int)1600, (ItemStack)TDDucts.fluidBasicOpaque.itemStack, (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.nuggetCopper, (int)3), (ItemStack)ItemHelper.cloneStack((ItemStack)ItemMaterial.nuggetLead));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemBasic.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotTin", Character.valueOf('G'), glassHardened}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemBasicOpaque.itemStack, (int)6), (Object[])new Object[]{"IGI", Character.valueOf('I'), "ingotTin", Character.valueOf('G'), "ingotLead"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.itemEnergy.itemStack, (Object[])new Object[]{TDDucts.itemBasic.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.itemEnergyOpaque.itemStack, (Object[])new Object[]{TDDucts.itemBasicOpaque.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemEnergy.itemStack, (int)3), (Object[])new Object[]{TDDucts.itemBasic.itemStack, TDDucts.itemBasic.itemStack, TDDucts.itemBasic.itemStack, "ingotSignalum", "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemEnergyOpaque.itemStack, (int)3), (Object[])new Object[]{TDDucts.itemBasicOpaque.itemStack, TDDucts.itemBasicOpaque.itemStack, TDDucts.itemBasicOpaque.itemStack, "ingotSignalum", "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.itemEnergyFast.itemStack, (Object[])new Object[]{TDDucts.itemFast.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)TDDucts.itemEnergyFastOpaque.itemStack, (Object[])new Object[]{TDDucts.itemFastOpaque.itemStack, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum", "nuggetElectrum", "nuggetElectrum", "nuggetElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemEnergy.itemStack, (int)3), (Object[])new Object[]{TDDucts.itemBasic.itemStack, TDDucts.fluidHardened.itemStack, TDDucts.fluidHardened.itemStack, "ingotSignalum", "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.itemEnergyOpaque.itemStack, (int)3), (Object[])new Object[]{TDDucts.itemBasicOpaque.itemStack, TDDucts.fluidHardenedOpaque.itemStack, TDDucts.fluidHardenedOpaque.itemStack, "ingotSignalum", "ingotElectrum"}));
        TDCrafting.addTransposerFill(800, TDDucts.itemBasic.itemStack, TDDucts.itemFast.itemStack, new FluidStack(TFFluids.fluidGlowstone, 200), false);
        TDCrafting.addTransposerFill(800, TDDucts.itemBasicOpaque.itemStack, TDDucts.itemFastOpaque.itemStack, new FluidStack(TFFluids.fluidGlowstone, 200), false);
        TDCrafting.addTransposerFill(800, TDDucts.itemEnergy.itemStack, TDDucts.itemEnergyFast.itemStack, new FluidStack(TFFluids.fluidGlowstone, 200), false);
        TDCrafting.addTransposerFill(800, TDDucts.itemEnergyOpaque.itemStack, TDDucts.itemEnergyFastOpaque.itemStack, new FluidStack(TFFluids.fluidGlowstone, 200), false);
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.structure.itemStack, (int)6), (Object[])new Object[]{"iIi", Character.valueOf('i'), "nuggetTin", Character.valueOf('I'), "ingotLead"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.transportFrame.itemStack, (int)4), (Object[])new Object[]{"IGI", "G G", "IGI", Character.valueOf('I'), "ingotBronze", Character.valueOf('G'), glassHardened}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)TDDucts.transportLongRange.itemStack, (int)8), (Object[])new Object[]{"IGI", "G G", "IGI", Character.valueOf('I'), "ingotLead", Character.valueOf('G'), glassHardened}));
        TDCrafting.addTransposerFill(800, TDDucts.transportFrame.itemStack, TDDucts.transportBasic.itemStack, new FluidStack(TFFluids.fluidAerotheum, 100), false);
        TDCrafting.addTransposerFill(8000, TDDucts.transportBasic.itemStack, TDDucts.transportLinking.itemStack, new FluidStack(TFFluids.fluidEnder, 1000), false);
        if (enableCoverRecipes) {
            ItemHelper.addRecipe((IRecipe)RecipeCover.INSTANCE);
        }
        String[] materials = new String[]{"Iron", "Invar", "Electrum", "Signalum", "Enderium"};
        int hardGlassLevel = useHardenedGlass ? 2 : 5;
        for (int i = 0; i < materials.length; ++i) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)new ItemStack((Item)TDItems.itemServo, 2, i), (Object[])new Object[]{"iGi", "IRI", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), i < hardGlassLevel ? "blockGlass" : "blockGlassHardened", Character.valueOf('I'), "ingot" + materials[i], Character.valueOf('i'), "nuggetTin"}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)new ItemStack((Item)TDItems.itemFilter, 2, i), (Object[])new Object[]{"iGi", "IRI", Character.valueOf('R'), Items.field_151121_aF, Character.valueOf('G'), i < hardGlassLevel ? "blockGlass" : "blockGlassHardened", Character.valueOf('I'), "ingot" + materials[i], Character.valueOf('i'), "nuggetTin"}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)new ItemStack((Item)TDItems.itemRetriever, 2, i), (Object[])new Object[]{"iGi", "IRI", Character.valueOf('R'), Items.field_151061_bv, Character.valueOf('G'), i < hardGlassLevel ? "blockGlass" : "blockGlassHardened", Character.valueOf('I'), "ingot" + materials[i], Character.valueOf('i'), "nuggetGold"}));
            if (i <= 0) continue;
            Item[] itemArray = new Item[]{TDItems.itemFilter, TDItems.itemServo, TDItems.itemRetriever};
            int n = itemArray.length;
            for (int j = 0; j < n; ++j) {
                Item item = itemArray[j];
                if (i < hardGlassLevel) {
                    ItemHelper.addRecipe((IRecipe)TDCrafting.addInputMetaRange(new ShapelessOreRecipe(new ItemStack(item, 1, i), new Object[]{"ingot" + materials[i]}), new ItemStack(item, 1), 0, i - 1));
                    continue;
                }
                if (i > hardGlassLevel) {
                    ItemHelper.addRecipe((IRecipe)TDCrafting.addInputMetaRange(new ShapelessOreRecipe(new ItemStack(item, 1, i), new Object[]{"ingot" + materials[i]}), new ItemStack(item, 1), hardGlassLevel, i - 1));
                }
                ItemHelper.addRecipe((IRecipe)TDCrafting.addInputMetaRange(TDCrafting.addInputMetaRange(new ShapelessOreRecipe(new ItemStack(item, 2, i), new Object[]{"blockGlassHardened", "ingot" + materials[i], "ingot" + materials[i]}), new ItemStack(item, 1), 0, hardGlassLevel - 1), new ItemStack(item, 1), 0, hardGlassLevel - 1));
            }
        }
        for (Duct[] duct : new Duct[][]{{TDDucts.itemBasic, TDDucts.itemBasicOpaque}, {TDDucts.itemFast, TDDucts.itemFastOpaque}, {TDDucts.itemEnergy, TDDucts.itemEnergyOpaque}, {TDDucts.fluidHardened, TDDucts.fluidHardenedOpaque}}) {
            t = duct[0].itemStack;
            o = duct[1].itemStack;
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)t, (int)6), (Object[])new Object[]{o, o, o, o, o, o, glassHardened}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)o, (int)6), (Object[])new Object[]{t, t, t, t, t, t, "ingotLead"}));
        }
        for (Duct[] duct : new Duct[][]{{TDDucts.fluidBasic, TDDucts.fluidBasicOpaque}}) {
            t = duct[0].itemStack;
            o = duct[1].itemStack;
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)t, (int)6), (Object[])new Object[]{o, o, o, o, o, o, "blockGlass"}));
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)ItemHelper.cloneStack((ItemStack)o, (int)6), (Object[])new Object[]{t, t, t, t, t, t, "ingotLead"}));
        }
    }

    public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (useTransposerRecipes && Loader.isModLoaded((String)"thermalexpansion")) {
            ThermalExpansionHelper.addTransposerFill((int)energy, (ItemStack)input, (ItemStack)output, (FluidStack)fluid, (boolean)reversible);
        } else {
            int i = MathHelper.clamp((int)(1000 / fluid.amount), (int)1, (int)8);
            ItemStack fluidBucket = TDCrafting.getFluidBucket(fluid);
            if (fluidBucket != null) {
                ShapelessOreRecipe recipe = new ShapelessOreRecipe(ItemHelper.cloneStack((ItemStack)output, (int)i), new Object[]{fluidBucket});
                for (int j = 0; j < i; ++j) {
                    recipe.getInput().add(input.func_77946_l());
                }
                ItemHelper.addRecipe((IRecipe)recipe);
            }
        }
    }

    public static ItemStack getFluidBucket(FluidStack fluidStack) {
        return UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluidStack.getFluid());
    }

    public static ShapelessOreRecipe addInputMetaRange(ShapelessOreRecipe recipe, ItemStack input, int minMeta, int maxMeta) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(maxMeta - minMeta + 1);
        for (int i = minMeta; i <= maxMeta; ++i) {
            input = input.func_77946_l();
            input.func_77964_b(i);
            itemStacks.add(input);
        }
        recipe.getInput().add(itemStacks);
        return recipe;
    }

    public static ShapelessOreRecipe addInput(ShapelessOreRecipe recipe, Collection<ItemStack> ... inputs) {
        for (Collection<ItemStack> input : inputs) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(input.size());
            itemStacks.addAll(input);
            recipe.getInput().add(itemStacks);
        }
        return recipe;
    }

    public static ShapelessOreRecipe addInput(ShapelessOreRecipe recipe, ItemStack[] ... inputs) {
        for (ItemStack[] input : inputs) {
            ArrayList itemStacks = new ArrayList(input.length);
            Collections.addAll(itemStacks, input);
            recipe.getInput().add(itemStacks);
        }
        return recipe;
    }
}

