/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render.item;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.attachments.cover.CoverRenderer;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class RenderItemCover
implements IItemRenderer,
IPerspectiveAwareModel {
    public static IItemRenderer instance = new RenderItemCover();

    public void renderItem(ItemStack stack) {
        boolean invalid = false;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            invalid = true;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
            nbt.func_82580_o("Meta");
            nbt.func_82580_o("Block");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
            invalid = true;
        }
        if (invalid) {
            block = Blocks.field_180401_cv;
            meta = 0;
        }
        EnumFacing side = EnumFacing.NORTH;
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_176599_b);
        Cuboid6 bounds = Cover.bounds[side.ordinal()];
        CoverRenderer.renderItemCover(ccrs, side.ordinal(), block.func_176203_a((int)meta), bounds);
        ccrs.draw();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)TransformUtils.DEFAULT_BLOCK.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return new ArrayList<BakedQuad>();
    }
}

