/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import gnu.trove.iterator.TByteIterator;
import gnu.trove.list.TByteList;
import gnu.trove.list.linked.TByteLinkedList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;

public class Route<T extends IGridTileRoute<T, G>, G extends MultiBlockGrid<T>>
implements Comparable<Route> {
    public TByteLinkedList pathDirections = new TByteLinkedList();
    public T endPoint;
    public int pathWeight = 0;
    public boolean routeFinished = false;
    public BlockPos dest;
    public static final byte[] tmpBuffer = new byte[256];

    public Route(T myParent) {
        this.endPoint = myParent;
    }

    public Route(Route<T, G> prevRoute, T newPlace, byte direction, boolean isFinished) {
        this.pathDirections = new TByteLinkedList((TByteList)prevRoute.pathDirections);
        this.pathWeight = prevRoute.pathWeight + newPlace.getWeight();
        this.endPoint = newPlace;
        this.pathDirections.add(direction);
        this.routeFinished = isFinished;
    }

    public Route(Route<T, G> prevRoute, boolean endPath) {
        this.pathDirections = new TByteLinkedList((TByteList)prevRoute.pathDirections);
        this.pathWeight = prevRoute.pathWeight;
        this.endPoint = prevRoute.endPoint;
        this.routeFinished = true;
    }

    public Route(Route<T, G> prevRoute) {
        this.pathDirections = new TByteLinkedList((TByteList)prevRoute.pathDirections);
        this.pathWeight = prevRoute.pathWeight;
        this.endPoint = prevRoute.endPoint;
        this.routeFinished = prevRoute.routeFinished;
    }

    @Override
    public int compareTo(@Nonnull Route otherRoute) {
        if (this.pathWeight < otherRoute.pathWeight) {
            return -1;
        }
        if (this.pathWeight > otherRoute.pathWeight) {
            return 1;
        }
        if (this.pathDirections.size() < otherRoute.pathDirections.size()) {
            return -1;
        }
        if (this.pathDirections.size() > otherRoute.pathDirections.size()) {
            return 1;
        }
        return 0;
    }

    public Route copy() {
        return new Route<T, G>(this);
    }

    public byte getNextDirection() {
        return this.pathDirections.removeAt(0);
    }

    public boolean hasNextDirection() {
        return this.pathDirections.size() > 0;
    }

    public int getCurrentDirection() {
        return this.pathDirections.get(0);
    }

    public int checkNextDirection() {
        return this.pathDirections.get(1);
    }

    public int getLastSide() {
        return this.pathDirections.size() > 0 ? (int)this.pathDirections.get(this.pathDirections.size() - 1) : 0;
    }

    public Route(byte[] b) {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        try {
            byte[] array;
            if (bais.read() == 0) {
                array = new byte[bais.available()];
                bais.read(array);
            } else {
                int n;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPInputStream zis = new GZIPInputStream(bais);
                while ((n = zis.read(tmpBuffer)) >= 0) {
                    baos.write(tmpBuffer, 0, n);
                }
                zis.close();
                array = baos.toByteArray();
            }
            for (Object b1 : (ByteArrayOutputStream)array) {
                byte b3;
                byte b2 = (byte)(b1 & 7);
                if (b2 < 6) {
                    this.pathDirections.add(b2);
                }
                if ((b3 = (byte)(b1 >> 3)) >= 6) continue;
                this.pathDirections.add(b3);
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[(this.pathDirections.size() + 1) / 2];
        int i = 0;
        TByteIterator iterator = this.pathDirections.iterator();
        while (iterator.hasNext()) {
            bytes[i] = iterator.next();
            if (iterator.hasNext()) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | iterator.next() << 3);
            } else {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 0x30);
            }
            ++i;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (bytes.length <= 20) {
                baos.write(0);
                baos.write(bytes);
            } else {
                baos.write(1);
                GZIPOutputStream zos = new GZIPOutputStream(baos);
                zos.write(bytes);
                zos.close();
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return baos.toByteArray();
    }
}

