/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.world.World;

public abstract class MultiBlockGridWithRoutes<T extends IGridTileRoute<T, G>, G extends MultiBlockGridWithRoutes<T, G>>
extends MultiBlockGrid<T> {
    public final LinkedList<RouteCache<T, G>> calculatingRoutes = new LinkedList();
    public HashMap<IGridTileRoute, RouteCache<T, G>> routeCacheMap = new HashMap();

    public MultiBlockGridWithRoutes(World world) {
        super(world);
    }

    @Override
    public void doTickProcessing(long deadline) {
        int i = 0;
        while (!this.calculatingRoutes.isEmpty()) {
            RouteCache<T, G> routeCache = this.calculatingRoutes.peek();
            if (routeCache != null && !routeCache.processStep()) {
                this.calculatingRoutes.remove(routeCache);
            }
            if (i == 15) {
                if (System.nanoTime() > deadline) {
                    return;
                }
                i = 0;
            }
            ++i;
        }
    }

    @Override
    public boolean isTickProcessing() {
        return !this.calculatingRoutes.isEmpty();
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.onMajorGridChange();
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        if (!this.routeCacheMap.isEmpty()) {
            for (RouteCache<T, G> routeCache : this.routeCacheMap.values()) {
                routeCache.invalidate();
            }
            this.routeCacheMap.clear();
        }
        if (!this.calculatingRoutes.isEmpty()) {
            this.calculatingRoutes.clear();
        }
    }

    public RouteCache getRoutesFromOutputNonUrgent(T start) {
        RouteCache<T, G> cache = this.routeCacheMap.get(start);
        if (cache != null) {
            return cache;
        }
        cache = new RouteCache(start);
        this.calculatingRoutes.add(cache);
        this.routeCacheMap.put((IGridTileRoute)start, cache);
        return cache;
    }

    public RouteCache<T, G> getRoutesFromOutputRange(T start, int maxRange) {
        RouteCache<T, G> cache = this.routeCacheMap.get(start);
        if (cache == null) {
            cache = new RouteCache(start, maxRange);
            cache.generateCache();
            this.routeCacheMap.put((IGridTileRoute)start, cache);
        } else if (cache.maxPathLength < maxRange) {
            cache.maxPathLength = maxRange;
            cache.generateCache();
        }
        return cache;
    }

    public RouteCache<T, G> getRoutesFromOutput(T start) {
        RouteCache<T, G> cache = this.routeCacheMap.get(start);
        if (cache == null) {
            cache = new RouteCache(start);
            cache.generateCache();
            this.routeCacheMap.put((IGridTileRoute)start, cache);
        } else if (!cache.isFinishedGenerating() || cache.maxPathLength < Integer.MAX_VALUE) {
            cache.maxPathLength = Integer.MAX_VALUE;
            cache.generateCache();
        }
        return cache;
    }
}

