/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemServo
extends ItemAttachment {
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.UNCOMMON, EnumRarity.RARE};
    public static ItemStack basicServo;
    public static ItemStack hardenedServo;
    public static ItemStack reinforcedServo;
    public static ItemStack signalumServo;
    public static ItemStack resonantServo;

    public ItemServo() {
        this.func_77655_b("thermaldynamics.servo");
    }

    public String func_77667_c(ItemStack item) {
        return super.func_77667_c(item) + "." + item.func_77952_i();
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return rarity[stack.func_77952_i() % 5];
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i() % 5;
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new ServoFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new ServoItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extraInfo) {
        super.func_77624_a(stack, player, list, extraInfo);
        int type = stack.func_77952_i() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.getInfoText((String)"item.thermaldynamics.servo.info"));
            if (StringHelper.displayShiftForDetail) {
                list.add(StringHelper.shiftForDetails());
            }
            return;
        }
        if (ServoBase.canAlterRS(type)) {
            list.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneInt"));
        } else {
            list.add(StringHelper.localize((String)"info.thermaldynamics.servo.redstoneExt"));
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + (ServoItem.tickDelays[type] % 20 == 0 ? Integer.toString(ServoItem.tickDelays[type] / 20) : Float.toString((float)ServoItem.tickDelays[type] / 20.0f)) + "s" + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.maxStackSize") + ": " + "\u00a7f" + ServoItem.maxSize[type] + "\u00a7r");
        ItemServo.addFiltering(list, type, Duct.Type.ITEM);
        if (ServoItem.multiStack[type]) {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotMulti"));
        } else {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.slotSingle"));
        }
        if (ServoItem.speedBoost[type] != 1) {
            list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.speedBoost") + ": " + "\u00a7f" + ServoItem.speedBoost[type] + "x " + "\u00a7r");
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        list.add("  " + StringHelper.localize((String)"info.thermaldynamics.servo.extractRate") + ": " + "\u00a7f" + Integer.toString((int)(ServoFluid.throttle[type] * 100.0f)) + "%" + "\u00a7r");
        ItemServo.addFiltering(list, type, Duct.Type.FLUID);
    }

    public static void addFiltering(List<String> list, int type, Duct.Type duct) {
        StringBuilder b = new StringBuilder();
        b.append(StringHelper.localize((String)"info.thermaldynamics.filter.options")).append(": ").append("\u00a7f");
        boolean flag = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(duct, type, i)) continue;
            if (flag) {
                b.append(", ");
            } else {
                flag = true;
            }
            b.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        flag = false;
        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(b.toString(), 140)) {
            if (flag) {
                s = "  \u00a7f" + s;
            }
            flag = true;
            list.add("  " + s + "\u00a7r");
        }
    }

    public boolean preInit() {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName("servo"));
        basicServo = new ItemStack((Item)this, 1, 0);
        hardenedServo = new ItemStack((Item)this, 1, 1);
        reinforcedServo = new ItemStack((Item)this, 1, 2);
        signalumServo = new ItemStack((Item)this, 1, 3);
        resonantServo = new ItemStack((Item)this, 1, 4);
        ServoBase.initialize();
        ThermalDynamics.proxy.addIModelRegister(this);
        return true;
    }

    @Override
    public boolean initialize() {
        return true;
    }

    @Override
    public void registerModels() {
        String[] names = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
        for (int i = 0; i < names.length; ++i) {
            ModelResourceLocation location = new ModelResourceLocation("thermaldynamics:attachment", "type=" + this.getRegistryName().func_110623_a() + "_" + names[i]);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)location);
        }
    }
}

