/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCover
extends ItemAttachment {
    private static List<ItemStack> coverList;

    public ItemCover() {
        this.func_77637_a(ThermalDynamics.tabCovers);
        this.func_77655_b("thermaldynamics.cover");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.addAll(ItemCover.getCoverList());
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            return null;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a || meta < 0 || meta >= 16 || !CoverHelper.isValid(block, meta)) {
            nbt.func_82580_o("Meta");
            nbt.func_82580_o("Block");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
            return null;
        }
        return new Cover(tile, (byte)(side.ordinal() ^ 1), block.func_176203_a((int)meta));
    }

    public String func_77653_i(ItemStack item) {
        ItemStack b = CoverHelper.getCoverItemStack(item, true);
        String name = "";
        if (b != null) {
            String unloc = this.func_77657_g(item) + ".";
            String unloc2 = b.func_77973_b().func_77657_g(b);
            if (StringHelper.canLocalize((String)(unloc + unloc2 + ".name"))) {
                return StringHelper.localize((String)(unloc + unloc2 + ".name"));
            }
            name = b.func_82833_r();
        }
        return StringHelper.localizeFormat((String)(this.func_77657_g(item) + ".name"), (Object[])new Object[]{name});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemStack b = CoverHelper.getCoverItemStack(stack, false);
        if (b == null) {
            tooltip.add(StringHelper.getNoticeText((String)"info.thermaldynamics.info.invalidCover"));
        }
    }

    public boolean preInit() {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName("cover"));
        return true;
    }

    public static void createCoverList() {
        coverList = new ArrayList<ItemStack>();
        ArrayList stacks = new ArrayList();
        ArrayList<Item> data = new ArrayList<Item>();
        for (Item item : ForgeRegistries.ITEMS) {
            data.add(item);
        }
        data.sort(Comparator.comparingInt(arg_0 -> ((RegistryNamespaced)Item.field_150901_e).func_148757_b(arg_0)));
        for (Item anItem : data) {
            if (!(anItem instanceof ItemBlock)) continue;
            anItem.func_150895_a(anItem, null, stacks);
        }
        for (ItemStack stack : stacks) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || !CoverHelper.isValid(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i()))) continue;
            coverList.add(CoverHelper.getCoverStack(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77973_b().func_77647_b(stack.func_77952_i())));
        }
    }

    public static List<ItemStack> getCoverList() {
        if (coverList == null || coverList.size() <= 0) {
            ItemCover.createCoverList();
        }
        return coverList;
    }
}

