/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.CoFHCore;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.entity.DuctUnitTransport;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportBase;
import cofh.thermaldynamics.duct.entity.DuctUnitTransportLinking;
import cofh.thermaldynamics.duct.entity.SoundWoosh;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.IDuctHolder;
import cofh.thermaldynamics.multiblock.Route;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityTransport
extends Entity {
    private static final DataParameter<Byte> DIRECTIONS = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PROGRESS = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> POSX = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> POSY = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> POSZ = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> STEP = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Byte> PAUSE = EntityDataManager.func_187226_a(EntityTransport.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int DUCT_LENGTH = 100;
    public static final int DUCT_LENGTH2 = 50;
    public byte progress = 0;
    public byte direction = (byte)7;
    public byte oldDirection;
    public byte step = 0;
    public boolean reRoute = false;
    public byte pause = 0;
    public float originalWidth = 0.0f;
    public float originalHeight = 0.0f;
    public double originalYOffset = 0.0;
    public float originalEyeHeight = 0.0f;
    public Entity rider = null;
    Route myPath;
    BlockPos pos;
    boolean initSound;
    public static final float DEFAULT_WIDTH = 0.25f;
    public static final float DEFAULT_HEIGHT = 0.25f;

    public boolean func_180431_b(DamageSource source) {
        return true;
    }

    public double func_70033_W() {
        return super.func_70033_W();
    }

    public double func_70042_X() {
        Entity riddenByEntity = this.rider;
        if (riddenByEntity == null) {
            return super.func_70042_X();
        }
        return -riddenByEntity.func_70033_W();
    }

    public EntityTransport(World world) {
        super(world);
        this.field_70131_O = 0.0f;
        this.field_70130_N = 0.0f;
        this.field_70145_X = true;
        this.field_70178_ae = true;
    }

    public EntityTransport(DuctUnitTransportBase origin, Route route, byte startDirection, byte step) {
        this(origin.world());
        this.step = step;
        this.pos = new BlockPos((Vec3i)origin.pos());
        this.myPath = route;
        this.direction = route.getNextDirection();
        this.oldDirection = startDirection;
        this.setPosition(0.0);
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void start(Entity passenger) {
        passenger.func_184220_m((Entity)this);
        this.loadRider(passenger);
        this.field_70170_p.func_72838_d((Entity)this);
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.rider == null && passenger instanceof EntityPlayer) {
            this.loadRider(passenger);
        }
    }

    public void loadRider(Entity passenger) {
        this.rider = passenger;
        this.originalWidth = passenger.field_70130_N;
        this.originalHeight = passenger.field_70131_O;
        this.originalYOffset = passenger.func_70033_W();
        if (this.rider instanceof EntityPlayer) {
            this.originalEyeHeight = ((EntityPlayer)this.rider).eyeHeight;
        }
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_98034_c(EntityPlayer player) {
        return true;
    }

    public void func_70071_h_() {
        DuctUnitTransportBase homeTile;
        boolean wasPause;
        if (!this.field_70170_p.field_72995_K || this.rider != null) {
            if (!this.func_184207_aI() || ((Entity)this.func_184188_bt().get((int)0)).field_70128_L) {
                this.func_70106_y();
                return;
            }
        } else if (!this.func_184207_aI()) {
            return;
        }
        if (this.rider == null) {
            if (!(this.func_184188_bt().get(0) instanceof EntityLivingBase)) {
                ((Entity)this.func_184188_bt().get(0)).func_184210_p();
                this.func_70106_y();
                return;
            }
            this.loadRider((Entity)this.func_184188_bt().get(0));
        } else {
            this.updateRider(this.rider);
        }
        boolean bl = wasPause = this.pause > 0;
        if (this.field_70170_p.field_72995_K) {
            if (!this.initSound) {
                this.initSound = true;
                SoundHelper.playSound((ISound)this.getSound());
            }
            if (this.field_70180_af.func_187223_a()) {
                this.field_70180_af.func_187230_e();
                this.loadDataParameters();
            }
        }
        if (this.direction == 7 || this.pos == null) {
            return;
        }
        TileEntity tile = this.field_70170_p.func_175625_s(this.pos);
        if (tile == null || !(tile instanceof IDuctHolder) || (homeTile = ((IDuctHolder)tile).getDuct(DuctToken.TRANSPORT)) == null) {
            if (this.field_70170_p.field_72995_K) {
                this.pos = null;
            } else {
                this.dropPassenger();
            }
            return;
        }
        if (this.pause > 0) {
            this.pause = (byte)(this.pause - 1);
            if (!this.field_70170_p.field_72995_K) {
                this.updateDataParameters();
            } else {
                this.setPosition(0.0);
                if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) == CoFHCore.proxy.getClientPlayer()) {
                    if (this.pause == 0) {
                        CoFHCore.proxy.addIndexedChatMessage(null, -515781222);
                    } else {
                        CoFHCore.proxy.addIndexedChatMessage((ITextComponent)new TextComponentString("Charging - " + (DuctUnitTransportLinking.CHARGE_TIME - this.pause) + " / " + DuctUnitTransportLinking.CHARGE_TIME), -515781222);
                    }
                }
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5, MathHelper.RANDOM.nextGaussian() * 0.5, MathHelper.RANDOM.nextGaussian() * 0.5, MathHelper.RANDOM.nextGaussian() * 0.5, new int[0]);
                }
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            homeTile.advanceEntity(this);
            this.updateDataParameters();
        } else {
            if (wasPause && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) == CoFHCore.proxy.getClientPlayer()) {
                CoFHCore.proxy.addIndexedChatMessage(null, -515781222);
            }
            homeTile.advanceEntityClient(this);
        }
        this.setPosition(0.0);
        if (this.func_184207_aI() && !((Entity)this.func_184188_bt().get((int)0)).field_70128_L) {
            this.func_184232_k((Entity)this.func_184188_bt().get(0));
        }
    }

    public void updateRider(Entity rider) {
        rider.field_70130_N = 0.25f;
        rider.field_70131_O = 0.25f;
        if (rider instanceof EntityPlayer) {
            ((EntityPlayer)rider).eyeHeight = 0.35f;
        }
        rider.func_70107_b(rider.field_70165_t, rider.field_70163_u, rider.field_70161_v);
    }

    public void func_70106_y() {
        if (this.rider != null && !this.rider.field_70128_L) {
            this.rider.field_70131_O = this.originalHeight;
            this.rider.field_70130_N = this.originalWidth;
            if (this.rider instanceof EntityPlayer) {
                ((EntityPlayer)this.rider).eyeHeight = this.originalEyeHeight;
            }
            this.rider.func_70107_b(this.rider.field_70165_t, this.rider.field_70163_u, this.rider.field_70161_v);
        }
        super.func_70106_y();
    }

    public boolean trySimpleAdvance() {
        BlockPos p = this.pos.func_177972_a(EnumFacing.field_82609_l[this.direction]);
        TileEntity tileEntity = this.field_70170_p.func_175625_s(p);
        DuctUnitTransportBase transportBase = IDuctHolder.getTokenFromTile(tileEntity, DuctToken.TRANSPORT);
        if (transportBase == null) {
            this.pos = null;
            return false;
        }
        if (((DuctUnitTransportBase[])transportBase.ductCache)[this.direction ^ 1] == null) {
            this.pos = null;
            return false;
        }
        this.pos = p;
        this.oldDirection = this.direction;
        this.progress = (byte)(this.progress % 100);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundWoosh(this);
    }

    public void func_70030_z() {
    }

    public void setPosition(double frame) {
        if (this.pos == null) {
            return;
        }
        if (this.pause > 0) {
            Vec3d newPos = this.getPos(frame);
            this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            this.field_70142_S = this.field_70169_q = this.field_70165_t;
            this.field_70137_T = this.field_70167_r = this.field_70163_u;
            this.field_70136_U = this.field_70166_s = this.field_70161_v;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            return;
        }
        Vec3d oldPos = this.getPos(frame - 1.0);
        this.field_70142_S = this.field_70169_q = oldPos.field_72450_a;
        this.field_70137_T = this.field_70167_r = oldPos.field_72448_b;
        this.field_70136_U = this.field_70166_s = oldPos.field_72449_c;
        Vec3d newPos = this.getPos(frame);
        this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        this.field_70159_w = newPos.field_72450_a - oldPos.field_72450_a;
        this.field_70181_x = newPos.field_72448_b - oldPos.field_72448_b;
        this.field_70179_y = newPos.field_72449_c - oldPos.field_72449_c;
        if (!this.func_184188_bt().isEmpty()) {
            this.func_184232_k((Entity)this.func_184188_bt().get(0));
        }
    }

    public void dropPassenger() {
        if (!this.field_70170_p.field_72995_K) {
            this.rider.func_184210_p();
            if (this.direction >= 0 && this.direction < 6) {
                Vec3i vec = EnumFacing.field_82609_l[this.direction].func_176730_m();
                double x = (double)(this.pos.func_177958_n() + vec.func_177958_n()) + 0.5;
                double y = this.pos.func_177956_o() + vec.func_177956_o();
                double z = (double)(this.pos.func_177952_p() + vec.func_177952_p()) + 0.5;
                if (this.direction == 0) {
                    y = Math.floor((float)this.pos.func_177956_o() - this.originalHeight);
                }
                this.rider.func_70107_b(x, y, z);
                if (this.rider instanceof EntityPlayerMP) {
                    float pitch;
                    float yaw;
                    switch (this.direction) {
                        case 0: {
                            yaw = this.rider.field_70177_z;
                            pitch = 0.0f;
                            break;
                        }
                        case 1: {
                            yaw = this.rider.field_70177_z;
                            pitch = 0.0f;
                            break;
                        }
                        case 2: {
                            yaw = 180.0f;
                            pitch = 0.0f;
                            break;
                        }
                        case 3: {
                            yaw = 0.0f;
                            pitch = 0.0f;
                            break;
                        }
                        case 4: {
                            yaw = 90.0f;
                            pitch = 0.0f;
                            break;
                        }
                        case 5: {
                            yaw = 270.0f;
                            pitch = 0.0f;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    ((EntityPlayerMP)this.rider).field_71135_a.func_147364_a(x, y, z, yaw, pitch);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void advanceTile(DuctUnitTransportBase homeTile) {
        if (((DuctUnitTransportBase[])homeTile.ductCache)[this.direction] != null) {
            DuctUnitTransportBase newHome = (DuctUnitTransportBase)homeTile.getPhysicalConnectedSide(this.direction);
            if (newHome != null && ((DuctUnitTransportBase[])newHome.ductCache)[this.direction ^ 1] != null) {
                this.pos = new BlockPos((Vec3i)newHome.pos());
                if (this.myPath.hasNextDirection()) {
                    this.oldDirection = this.direction;
                    this.direction = this.myPath.getNextDirection();
                } else {
                    this.reRoute = true;
                }
            } else {
                this.reRoute = true;
            }
        } else if (homeTile.parent.getConnectionType(this.direction) == ConnectionType.FORCED) {
            this.dropPassenger();
        } else {
            this.bouncePassenger(homeTile);
        }
    }

    public void bouncePassenger(DuctUnitTransportBase homeTile) {
        if (homeTile.getGrid() == null) {
            return;
        }
        this.myPath = homeTile.getRoute(this, this.direction, this.step);
        if (this.myPath == null) {
            this.dropPassenger();
        } else {
            this.oldDirection = this.direction;
            this.direction = this.myPath.getNextDirection();
            this.reRoute = false;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DIRECTIONS, (Object)0);
        this.field_70180_af.func_187214_a(PROGRESS, (Object)0);
        this.field_70180_af.func_187214_a(POSX, (Object)0);
        this.field_70180_af.func_187214_a(POSY, (Object)0);
        this.field_70180_af.func_187214_a(POSZ, (Object)0);
        this.field_70180_af.func_187214_a(STEP, (Object)1);
        this.field_70180_af.func_187214_a(PAUSE, (Object)0);
    }

    public void updateDataParameters() {
        byte dir = (byte)(this.direction | this.oldDirection << 3);
        this.field_70180_af.func_187227_b(DIRECTIONS, (Object)dir);
        this.field_70180_af.func_187227_b(PROGRESS, (Object)this.progress);
        this.field_70180_af.func_187227_b(POSX, (Object)this.pos.func_177958_n());
        this.field_70180_af.func_187227_b(POSY, (Object)this.pos.func_177956_o());
        this.field_70180_af.func_187227_b(POSZ, (Object)this.pos.func_177952_p());
        this.field_70180_af.func_187227_b(STEP, (Object)this.step);
        this.field_70180_af.func_187227_b(PAUSE, (Object)this.pause);
    }

    public void loadDataParameters() {
        byte b = (Byte)this.field_70180_af.func_187225_a(DIRECTIONS);
        this.direction = (byte)(b & 7);
        this.oldDirection = (byte)(b >> 3);
        this.progress = (Byte)this.field_70180_af.func_187225_a(PROGRESS);
        this.pos = new BlockPos(((Integer)this.field_70180_af.func_187225_a(POSX)).intValue(), ((Integer)this.field_70180_af.func_187225_a(POSY)).intValue(), ((Integer)this.field_70180_af.func_187225_a(POSZ)).intValue());
        this.step = (Byte)this.field_70180_af.func_187225_a(STEP);
        this.pause = (Byte)this.field_70180_af.func_187225_a(PAUSE);
    }

    protected void func_70037_a(NBTTagCompound tag) {
        if (tag.func_150297_b("route", 7)) {
            this.myPath = new Route(tag.func_74770_j("route"));
        }
        this.pos = new BlockPos(tag.func_74762_e("posx"), tag.func_74762_e("posy"), tag.func_74762_e("posz"));
        this.progress = tag.func_74771_c("progress");
        this.direction = tag.func_74771_c("direction");
        this.oldDirection = tag.func_74771_c("oldDirection");
        this.step = tag.func_74771_c("step");
        this.reRoute = tag.func_74767_n("reRoute");
        this.originalWidth = tag.func_74760_g("originalWidth");
        this.originalHeight = tag.func_74760_g("originalHeight");
        this.originalYOffset = tag.func_74760_g("originalYOffset");
        this.originalEyeHeight = tag.func_74760_g("originalEyeHeight");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.myPath != null) {
            tag.func_74773_a("route", this.myPath.toByteArray());
        }
        tag.func_74768_a("posx", this.pos.func_177958_n());
        tag.func_74768_a("posy", this.pos.func_177956_o());
        tag.func_74768_a("posz", this.pos.func_177952_p());
        tag.func_74774_a("progress", this.progress);
        tag.func_74774_a("direction", this.direction);
        tag.func_74774_a("oldDirection", this.oldDirection);
        tag.func_74774_a("step", this.step);
        tag.func_74757_a("reRoute", this.reRoute);
        tag.func_74776_a("originalWidth", this.originalWidth);
        tag.func_74776_a("originalHeight", this.originalHeight);
        tag.func_74776_a("originalEyeHeight", this.originalEyeHeight);
    }

    public Vec3d getPos(double framePos) {
        return new Vec3d(0.5 + (double)this.pos.func_177958_n(), 0.5 + (double)this.pos.func_177956_o(), 0.5 + (double)this.pos.func_177952_p());
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
        this.setPosition(0.0);
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    public void teleport(DuctUnitTransport dest) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L || this.rider == null || this.rider.field_70128_L) {
            return;
        }
        int curDim = this.field_71093_bK;
        int destDim = dest.world().field_73011_w.getDimension();
        if (destDim != curDim) {
            MinecraftServer minecraftserver = this.field_70170_p.func_73046_m();
            WorldServer currentWorld = minecraftserver.func_71218_a(curDim);
            WorldServer destinationWorld = minecraftserver.func_71218_a(destDim);
            this.rider.func_184210_p();
            this.transferNormalEntity(curDim, destDim, currentWorld, destinationWorld, this);
            if (this.rider instanceof EntityPlayerMP) {
                this.transferPlayer(destDim, this.rider);
            } else {
                this.transferNormalEntity(curDim, destDim, currentWorld, destinationWorld, this.rider);
            }
            this.rider.func_184210_p();
            currentWorld.func_82742_i();
            destinationWorld.func_82742_i();
        }
        this.pos = new BlockPos((Vec3i)dest.pos());
        if (this.myPath.hasNextDirection()) {
            this.oldDirection = this.direction;
            this.direction = this.myPath.getNextDirection();
        } else {
            this.reRoute = true;
        }
    }

    public void transferPlayer(int destDim, Entity entity) {
        entity.func_184204_a(destDim);
    }

    public void transferNormalEntity(int curDim, int destDim, WorldServer currentWorld, WorldServer destinationWorld, Entity entity) {
        entity.func_184204_a(destDim);
    }
}

