/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.RenderHelper;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.attachments.cover.CoverRenderer;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Cover
extends Attachment {
    private static Cuboid6 bound = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static Cuboid6[] bounds = new Cuboid6[]{bound, bound.copy().apply(Rotation.sideRotations[1].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[2].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[3].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[4].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[5].at(Vector3.center))};
    public IBlockState state;

    public Cover(TileGrid tile, byte side, IBlockState state) {
        super(tile, side);
        this.state = state;
    }

    public Cover(TileGrid tile, byte side) {
        super(tile, side);
    }

    @Override
    public String getName() {
        return "item.thermalfoundation.cover.name";
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public Cuboid6 getCuboid() {
        return bounds[this.side].copy();
    }

    @Override
    public boolean onWrenched() {
        this.baseTile.removeCover(this.side);
        for (ItemStack stack : this.getDrops()) {
            this.dropItemStack(stack);
        }
        return true;
    }

    @Override
    @Nonnull
    public BlockDuct.ConnectionType getNeighborType() {
        return BlockDuct.ConnectionType.NONE;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccrs) {
        if (!this.state.func_177230_c().canRenderInLayer(this.state, layer)) {
            return false;
        }
        Attachment attachment = this.baseTile.getAttachment(this.side);
        CoverHoleRender.ITransformer[] hollowMask = null;
        if (attachment != null) {
            hollowMask = attachment.getHollowMask();
        }
        if (hollowMask == null) {
            hollowMask = this.baseTile.getHollowMask(this.side);
        }
        return CoverRenderer.renderBlockCover(ccrs, world, this.baseTile.func_174877_v(), this.side, this.state, this.getCuboid(), hollowMask);
    }

    @Override
    public boolean makesSideSolid() {
        return true;
    }

    @Override
    public ItemStack getPickBlock() {
        return CoverHelper.getCoverStack(this.state);
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> itemStacks = new LinkedList<ItemStack>();
        itemStacks.add(this.getPickBlock());
        return itemStacks;
    }

    @Override
    public boolean addToTile() {
        return this.baseTile.addCover(this);
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packet) {
        packet.addShort(Block.func_149682_b((Block)this.state.func_177230_c()));
        packet.addByte(this.state.func_177230_c().func_176201_c(this.state));
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packet) {
        Block block = Block.func_149729_e((int)packet.getShort());
        byte meta = packet.getByte();
        this.state = block.func_176203_a((int)meta);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("block", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.func_177230_c()).toString());
        tag.func_74774_a("meta", (byte)this.state.func_177230_c().func_176201_c(this.state));
    }

    @Override
    public boolean canAddToTile(TileGrid tile) {
        return tile.getCover(this.side) == null;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        Block block = Block.func_149684_b((String)tag.func_74779_i("block"));
        this.state = block == null ? Blocks.field_150350_a.func_176223_P() : block.func_176203_a((int)tag.func_74771_c("meta"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawSelectionExtra(EntityPlayer player, RayTraceResult target, float partialTicks) {
        super.drawSelectionExtra(player, target, partialTicks);
        RenderHelper.setBlockTextureSheet();
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GlStateManager.func_179141_d();
        GlStateManager.func_179142_g();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-d0), (double)(-d1), (double)(-d2));
        GlStateManager.func_179137_b((double)((double)this.baseTile.x() + 0.5), (double)((double)this.baseTile.y() + 0.5), (double)((double)this.baseTile.z() + 0.5));
        GlStateManager.func_179139_a((double)1.0009765625, (double)1.0009765625, (double)1.0009765625);
        GlStateManager.func_179137_b((double)((double)(-this.baseTile.x()) - 0.5), (double)((double)(-this.baseTile.y()) - 0.5), (double)((double)(-this.baseTile.z()) - 0.5));
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_176600_a);
        ccrs.alphaOverride = 80;
        CoverRenderer.renderBlockCover(ccrs, (IBlockAccess)this.baseTile.world(), this.baseTile.func_174877_v(), this.side, this.state, this.getCuboid(), null);
        ccrs.draw();
        GlStateManager.func_179121_F();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179118_c();
        GlStateManager.func_179119_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
    }
}

