/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.GridStructural;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.duct.tiles.TileStructuralDuct;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class DuctUnitStructural
extends DuctUnit<DuctUnitStructural, GridStructural, Void> {
    private static final Void[] VOIDS = new Void[6];
    @Nullable
    private final DuctUnit mainDuct;

    public DuctUnitStructural(TileGrid parent, @Nonnull DuctUnit mainDuct) {
        super(parent, mainDuct.getDuctType());
        this.mainDuct = mainDuct;
    }

    public DuctUnitStructural(TileStructuralDuct parent, Duct duct) {
        super(parent, duct);
        this.mainDuct = null;
    }

    protected Void[] createTileCache() {
        return VOIDS;
    }

    protected DuctUnitStructural[] createDuctCache() {
        return new DuctUnitStructural[6];
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitStructural, GridStructural, Void> getToken() {
        return DuctToken.STRUCTURAL;
    }

    @Override
    public GridStructural createGrid() {
        return new GridStructural(this.world());
    }

    @Override
    public Void cacheTile(@Nonnull TileEntity tile, byte side) {
        return null;
    }

    @Override
    public boolean canConnectToOtherDuct(DuctUnit<DuctUnitStructural, GridStructural, Void> adjDuct, byte side, byte oppositeSide) {
        if (this.mainDuct == null) {
            return true;
        }
        DuctUnit otherMainDuct = adjDuct.cast().mainDuct;
        if (otherMainDuct == null) {
            return true;
        }
        if (this.mainDuct.getToken() != otherMainDuct.getToken()) {
            return false;
        }
        return this.mainDuct.canConnectToOtherDuct(otherMainDuct, side, oppositeSide);
    }

    @Override
    @Nonnull
    protected BlockDuct.ConnectionType getConnectionTypeDuct(DuctUnitStructural duct, int side) {
        return BlockDuct.ConnectionType.STRUCTURE_CLEAN;
    }

    public void addRelays() {
        if (this.parent.attachmentData != null && this.grid != null) {
            for (Attachment attachment : this.parent.attachmentData.attachments) {
                if (attachment == null) continue;
                if (attachment.getId() == 7) {
                    Relay signaller = (Relay)attachment;
                    if (signaller.isInput()) {
                        ((GridStructural)this.grid).addSignalInput(signaller);
                        continue;
                    }
                    ((GridStructural)this.grid).addSignalOutput(attachment);
                    continue;
                }
                if (!attachment.respondsToSignalum()) continue;
                ((GridStructural)this.grid).addSignalOutput(attachment);
            }
        }
    }
}

