/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.alkahestry;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import xreliquary.reference.Settings;
import xreliquary.util.alkahestry.AlkahestChargeRecipe;
import xreliquary.util.alkahestry.AlkahestCraftRecipe;
import xreliquary.util.alkahestry.AlkahestRecipe;
import xreliquary.util.alkahestry.AlkahestRecipeType;

public class Alkahestry {
    public static AlkahestChargeRecipe matchChargeRecipe(ItemStack stack) {
        for (AlkahestChargeRecipe recipe : Settings.AlkahestryTome.chargingRecipes.values()) {
            if (!Alkahestry.itemMatchesRecipe(stack, recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static AlkahestCraftRecipe matchCraftRecipe(ItemStack stack) {
        for (AlkahestCraftRecipe recipe : Settings.AlkahestryTome.craftingRecipes.values()) {
            if (!Alkahestry.itemMatchesRecipe(stack, recipe)) continue;
            return recipe;
        }
        return null;
    }

    private static boolean itemMatchesRecipe(ItemStack stack, AlkahestRecipe recipe) {
        String itemName = stack.func_77973_b().getRegistryName().toString();
        int meta = stack.func_77960_j();
        if (recipe.type == AlkahestRecipeType.META) {
            if (recipe.name.equals(itemName) && recipe.meta == meta) {
                return true;
            }
        } else if (recipe.type == AlkahestRecipeType.WILDCARD) {
            if (recipe.name.equals(itemName)) {
                return true;
            }
        } else {
            for (ItemStack dict : OreDictionary.getOres((String)recipe.name)) {
                if (!OreDictionary.itemMatches((ItemStack)dict, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }
}

