/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.init.ModItems;
import xreliquary.init.ModPotions;
import xreliquary.items.ItemRendingGale;
import xreliquary.reference.Settings;

public class PedestalRendingGaleWrapper
implements IPedestalActionItemWrapper {
    private static final int SECONDS_BETWEEN_BUFF_CHECKS = 2;
    private static final int TICKS_BETWEEN_PUSH_PULL_CHECKS = 1;
    private int buffCheckCoolDown;
    private int pushPullCheckCoolDown;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        ItemRendingGale rendingGale = (ItemRendingGale)stack.func_77973_b();
        if (rendingGale.getMode(stack).equals("flight")) {
            if (this.buffCheckCoolDown <= 0) {
                List players;
                int flightRange = Settings.RendingGale.pedestalFlightRange;
                if (ModItems.rendingGale.getFeatherCount(stack) >= ItemRendingGale.getChargeCost() * 2 && !(players = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(pos.func_177958_n() - flightRange), (double)(pos.func_177956_o() - flightRange), (double)(pos.func_177952_p() - flightRange), (double)(pos.func_177958_n() + flightRange), (double)(pos.func_177956_o() + flightRange), (double)(pos.func_177952_p() + flightRange)))).isEmpty()) {
                    for (EntityPlayer player : players) {
                        player.func_70690_d(new PotionEffect(ModPotions.potionFlight, 400));
                    }
                    ModItems.rendingGale.setFeatherCount(stack, ModItems.rendingGale.getFeatherCount(stack) - 2 * Settings.RendingGale.pedestalCostPerSecond);
                }
                this.buffCheckCoolDown = 40;
            } else {
                --this.buffCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack).equals("push")) {
            if (this.pushPullCheckCoolDown <= 0) {
                rendingGale.doRadialPush(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), null, false);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        } else if (rendingGale.getMode(stack).equals("pull")) {
            if (this.pushPullCheckCoolDown <= 0) {
                rendingGale.doRadialPush(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), null, true);
                this.pushPullCheckCoolDown = 1;
            } else {
                --this.pushPullCheckCoolDown;
            }
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }
}

