/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.pedestal.wrappers;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.reference.Settings;

public class PedestalMeleeWeaponWrapper
implements IPedestalActionItemWrapper {
    private byte cooldownAfterSwing;

    public PedestalMeleeWeaponWrapper() {
        this(Settings.Pedestal.meleeWrapperCooldown);
    }

    public PedestalMeleeWeaponWrapper(byte cooldownAfterSwing) {
        this.cooldownAfterSwing = cooldownAfterSwing;
    }

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        FakePlayer fakePlayer = pedestal.getFakePlayer();
        World world = pedestal.getTheWorld();
        BlockPos pos = pedestal.getBlockPos();
        int meleeRange = Settings.Pedestal.meleeWrapperRange;
        List entities = world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)(pos.func_177958_n() - meleeRange), (double)(pos.func_177956_o() - meleeRange), (double)(pos.func_177952_p() - meleeRange), (double)(pos.func_177958_n() + meleeRange), (double)(pos.func_177956_o() + meleeRange), (double)(pos.func_177952_p() + meleeRange)));
        if (entities.size() == 0) {
            pedestal.setActionCoolDown(40);
            return;
        }
        EntityLiving entityToAttack = (EntityLiving)entities.get(world.field_73012_v.nextInt(entities.size()));
        while (entities.size() > 0 && !this.canAttackEntity(entityToAttack)) {
            entities.remove(entityToAttack);
            if (entities.size() <= 0) continue;
            entityToAttack = (EntityLiving)entities.get(world.field_73012_v.nextInt(entities.size()));
        }
        if (entities.size() == 0) {
            pedestal.setActionCoolDown(40);
            return;
        }
        fakePlayer.func_70107_b((double)pos.func_177958_n(), 0.0, (double)pos.func_177952_p());
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stack);
        fakePlayer.func_70071_h_();
        fakePlayer.func_71059_n((Entity)entityToAttack);
        pedestal.setActionCoolDown((int)fakePlayer.func_184818_cX() + this.cooldownAfterSwing);
        if (stack.field_77994_a == 0) {
            pedestal.destroyCurrentItem();
        }
    }

    private boolean canAttackEntity(EntityLiving entityToAttack) {
        if (!entityToAttack.func_184222_aU()) {
            return false;
        }
        if (entityToAttack instanceof EntityAnimal && entityToAttack.func_70631_g_()) {
            return false;
        }
        if (entityToAttack instanceof EntityHorse && ((EntityHorse)entityToAttack).func_110248_bS()) {
            return false;
        }
        return !(entityToAttack instanceof EntityTameable) || !((EntityTameable)entityToAttack).func_70909_n();
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
    }

    public class Slow
    extends PedestalMeleeWeaponWrapper {
        public Slow() {
            super((byte)10);
        }
    }
}

