/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;

public class FluidHandlerInfernalChalice
extends FluidHandlerItemStack {
    public FluidHandlerInfernalChalice(ItemStack chalice) {
        super(chalice, Settings.InfernalChalice.fluidLimit);
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return !ModItems.infernalChalice.isEnabled(this.container) && fluid.getFluid() == FluidRegistry.LAVA;
    }

    protected void setContainerToEmpty() {
        this.setFluid(new FluidStack(FluidRegistry.LAVA, 0));
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return ModItems.infernalChalice.isEnabled(this.container) && fluid.getFluid() == FluidRegistry.LAVA;
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new NBTTagCompound());
        }
        this.container.func_77978_p().func_74768_a("fluidStacks", fluid.amount);
    }

    @Nullable
    public FluidStack getFluid() {
        NBTTagCompound tagCompound = this.container.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("fluidStacks")) {
            return null;
        }
        return new FluidStack(FluidRegistry.LAVA, tagCompound.func_74762_e("fluidStacks"));
    }
}

