/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.util.LanguageHelper;

public class ItemShearsOfWinter
extends ItemShears {
    public ItemShearsOfWinter() {
        this.func_77655_b("shears_of_winter");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState blockState, BlockPos pos, EntityLivingBase player) {
        if (blockState.func_185904_a() != Material.field_151584_j && blockState.func_177230_c() != Blocks.field_150321_G && blockState.func_177230_c() != Blocks.field_150329_H && blockState.func_177230_c() != Blocks.field_150395_bd && blockState.func_177230_c() != Blocks.field_150473_bD && !(blockState.func_177230_c() instanceof IShearable)) {
            return super.func_179218_a(stack, world, blockState, pos, player);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150321_G || blockState.func_177230_c() == Blocks.field_150488_af || blockState.func_177230_c() == Blocks.field_150473_bD;
    }

    public float func_150893_a(ItemStack stack, IBlockState blockState) {
        return blockState.func_177230_c() != Blocks.field_150321_G && blockState.func_185904_a() != Material.field_151584_j ? (blockState.func_177230_c() == Blocks.field_150325_L ? 5.0f : super.func_150893_a(stack, blockState)) : 15.0f;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 2500;
    }

    public EnumAction func_77661_b(ItemStack ist) {
        return EnumAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)ist);
    }

    public void onUsingTick(ItemStack ist, EntityLivingBase entity, int count) {
        if (this.func_77626_a(ist) - count <= 5) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        Vec3d lookVector = player.func_70040_Z();
        this.spawnBlizzardParticles(lookVector, player);
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.doEntityShearableCheck(ist, player, lookVector);
        if (lookVector.field_72450_a > 0.0) {
            this.doPositiveXCheck(ist, player, lookVector);
        } else {
            this.doNegativeXCheck(ist, player, lookVector);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean whatDoesThisEvenDo) {
        this.formatTooltip(stack, list);
    }

    @SideOnly(value=Side.CLIENT)
    public void formatTooltip(ItemStack stack, List<String> list) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            LanguageHelper.formatTooltip(this.func_77657_g(stack) + ".tooltip", null, list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        return LanguageHelper.getLocalization(this.func_77657_g(stack) + ".name");
    }

    public void doPositiveXCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector) {
        int x;
        boolean firedOnce = false;
        for (x = 0; x < (int)(lookVector.field_72450_a * 10.0); ++x) {
            firedOnce = true;
            if (lookVector.field_72448_b > 0.0) {
                this.doPositiveYCheck(ist, player, lookVector, x);
                continue;
            }
            this.doNegativeYCheck(ist, player, lookVector, x);
        }
        if (!firedOnce) {
            for (x = -2; x <= 2; ++x) {
                if (lookVector.field_72448_b > 0.0) {
                    this.doPositiveYCheck(ist, player, lookVector, x);
                    continue;
                }
                this.doNegativeYCheck(ist, player, lookVector, x);
            }
        }
    }

    public void doNegativeXCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector) {
        int x;
        boolean firedOnce = false;
        for (x = 0; x > (int)(lookVector.field_72450_a * 10.0); --x) {
            firedOnce = true;
            if (lookVector.field_72448_b > 0.0) {
                this.doPositiveYCheck(ist, player, lookVector, x);
                continue;
            }
            this.doNegativeYCheck(ist, player, lookVector, x);
        }
        if (!firedOnce) {
            for (x = -2; x <= 2; ++x) {
                if (lookVector.field_72448_b > 0.0) {
                    this.doPositiveYCheck(ist, player, lookVector, x);
                    continue;
                }
                this.doNegativeYCheck(ist, player, lookVector, x);
            }
        }
    }

    public void doPositiveYCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector, int x) {
        int y;
        boolean firedOnce = false;
        for (y = 0; y < (int)(lookVector.field_72448_b * 10.0); ++y) {
            firedOnce = true;
            if (lookVector.field_72449_c > 0.0) {
                this.doPositiveZCheck(ist, player, lookVector, x, y);
                continue;
            }
            this.doNegativeZCheck(ist, player, lookVector, x, y);
        }
        if (!firedOnce) {
            for (y = -2; y <= 2; ++y) {
                if (lookVector.field_72449_c > 0.0) {
                    this.doPositiveZCheck(ist, player, lookVector, x, y);
                    continue;
                }
                this.doNegativeZCheck(ist, player, lookVector, x, y);
            }
        }
    }

    public void doNegativeYCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector, int x) {
        int y;
        boolean firedOnce = false;
        for (y = 0; y > (int)(lookVector.field_72448_b * 10.0); --y) {
            firedOnce = true;
            if (lookVector.field_72449_c > 0.0) {
                this.doPositiveZCheck(ist, player, lookVector, x, y);
                continue;
            }
            this.doNegativeZCheck(ist, player, lookVector, x, y);
        }
        if (!firedOnce) {
            for (y = -2; y <= 2; ++y) {
                if (lookVector.field_72449_c > 0.0) {
                    this.doPositiveZCheck(ist, player, lookVector, x, y);
                    continue;
                }
                this.doNegativeZCheck(ist, player, lookVector, x, y);
            }
        }
    }

    public void doPositiveZCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector, int x, int y) {
        int z;
        boolean firedOnce = false;
        for (z = 0; z < (int)(lookVector.field_72449_c * 10.0); ++z) {
            firedOnce = true;
            this.checkAndBreakBlockAt(x, y, z, player, ist);
        }
        if (!firedOnce) {
            for (z = -2; z <= 2; ++z) {
                this.checkAndBreakBlockAt(x, y, z, player, ist);
            }
        }
    }

    public void doNegativeZCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector, int x, int y) {
        int z;
        boolean firedOnce = false;
        for (z = 0; z > (int)(lookVector.field_72449_c * 10.0); --z) {
            firedOnce = true;
            this.checkAndBreakBlockAt(x, y, z, player, ist);
        }
        if (!firedOnce) {
            for (z = -2; z <= 2; ++z) {
                this.checkAndBreakBlockAt(x, y, z, player, ist);
            }
        }
    }

    public void checkAndBreakBlockAt(int x, int y, int z, EntityPlayer player, ItemStack ist) {
        IShearable target;
        IBlockState blockState;
        Block block;
        int distance = (int)player.func_70011_f((double)(x += (int)player.field_70165_t), (double)(y += (int)(player.field_70163_u + (double)player.func_70047_e())), (double)(z += (int)player.field_70161_v));
        int probabilityFactor = 5 + distance;
        if (player.field_70170_p.field_73012_v.nextInt(probabilityFactor) == 0 && (block = (blockState = player.field_70170_p.func_180495_p(new BlockPos(x, y, z))).func_177230_c()) instanceof IShearable && (target = (IShearable)block).isShearable(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)player.field_70170_p, new BlockPos(x, y, z))) {
            List drops = block.getDrops((IBlockAccess)player.field_70170_p, new BlockPos(x, y, z), player.field_70170_p.func_180495_p(new BlockPos(x, y, z)), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ist));
            Random rand = new Random();
            if (player.field_70170_p.field_72995_K) {
                if (block.func_149688_o(blockState) != Material.field_151579_a) {
                    player.field_70170_p.func_180498_a(player, 2001, new BlockPos(x, y, z), Block.func_176210_f((IBlockState)player.field_70170_p.func_180495_p(new BlockPos(x, y, z))));
                }
            } else {
                for (ItemStack stack : drops) {
                    float f = 0.7f;
                    double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(player.field_70170_p, (double)x + d, (double)y + d1, (double)z + d2, stack);
                    entityitem.func_174867_a(10);
                    player.field_70170_p.func_72838_d((Entity)entityitem);
                }
                player.field_70170_p.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
                player.func_71029_a(StatList.func_188055_a((Block)block));
                player.func_71020_j(0.01f);
            }
        }
    }

    public void doEntityShearableCheck(ItemStack ist, EntityPlayer player, Vec3d lookVector) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double lowerX = Math.min(player.field_70165_t, player.field_70165_t + lookVector.field_72450_a * 10.0);
        double lowerY = Math.min(player.field_70163_u + (double)player.func_70047_e(), player.field_70163_u + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double lowerZ = Math.min(player.field_70161_v, player.field_70161_v + lookVector.field_72449_c * 10.0);
        double upperX = Math.max(player.field_70165_t, player.field_70165_t + lookVector.field_72450_a * 10.0);
        double upperY = Math.max(player.field_70163_u + (double)player.func_70047_e(), player.field_70163_u + (double)player.func_70047_e() + lookVector.field_72448_b * 10.0);
        double upperZ = Math.max(player.field_70161_v, player.field_70161_v + lookVector.field_72449_c * 10.0);
        List eList = player.field_70170_p.func_72872_a(EntityLiving.class, new AxisAlignedBB(lowerX, lowerY, lowerZ, upperX, upperY, upperZ));
        for (EntityLiving e : eList) {
            IShearable target;
            int distance = (int)player.func_70032_d((Entity)e);
            int probabilityFactor = (distance - 3) / 2;
            if (probabilityFactor > 0 && player.field_70170_p.field_73012_v.nextInt(probabilityFactor) != 0) continue;
            if (!e.func_70028_i((Entity)player)) {
                e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 120, 1));
            }
            if (!(e instanceof IShearable) || !(target = (IShearable)e).isShearable(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)e.field_70170_p, new BlockPos((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v))) continue;
            List drops = target.onSheared(new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)e.field_70170_p, new BlockPos((int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ist));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                EntityItem ent = e.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
            player.func_71020_j(0.01f);
        }
    }

    public void spawnBlizzardParticles(Vec3d lookVector, EntityPlayer player) {
        for (int i = 0; i < 16; ++i) {
            float randX = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randY = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            float randZ = 10.0f * (player.field_70170_p.field_73012_v.nextFloat() - 0.5f);
            player.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, player.field_70165_t + (double)randX, player.field_70163_u + (double)randY, player.field_70161_v + (double)randZ, lookVector.field_72450_a * 5.0, lookVector.field_72448_b * 5.0, lookVector.field_72449_c * 5.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150431_aC.func_176203_a(0))});
        }
    }
}

