/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.fluid.FluidHandlerInfernalChalice;
import xreliquary.util.NBTHelper;

public class ItemInfernalChalice
extends ItemToggleable {
    public ItemInfernalChalice() {
        super("infernal_chalice");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List<String> list, boolean par4) {
        String amount = Integer.toString(NBTHelper.getInteger("fluidStacks", ist));
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"amount", (Object)amount), ist, list);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            return super.func_77659_a(stack, world, player, hand);
        }
        float movementThresholdCoefficient = 1.0f;
        double xOffset = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)movementThresholdCoefficient;
        double yOffset = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)movementThresholdCoefficient + (double)player.func_70047_e();
        double zOffset = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)movementThresholdCoefficient;
        boolean isInDrainMode = this.isEnabled(stack);
        RayTraceResult result = this.func_77621_a(world, player, isInDrainMode);
        if (result == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!world.func_175660_a(player, result.func_178782_a())) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (!player.func_175151_a(result.func_178782_a(), result.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            IFluidHandler fluidHandler = this.getFluidHandler(stack);
            if (fluidHandler == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBlockState blockState = world.func_180495_p(result.func_178782_a());
            if (this.isEnabled(stack) && (blockState.func_177230_c() == Blocks.field_150356_k || blockState.func_177230_c() == Blocks.field_150353_l) && (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0 && fluidHandler.fill(new FluidStack(FluidRegistry.LAVA, 1000), false) == 1000) {
                world.func_175656_a(result.func_178782_a(), Blocks.field_150350_a.func_176223_P());
                fluidHandler.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (!this.isEnabled(stack)) {
                FluidStack fluidDrained = fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), false);
                if (player.field_71075_bZ.field_75098_d || fluidDrained != null && fluidDrained.amount == 1000) {
                    BlockPos adjustedPos = result.func_178782_a().func_177972_a(result.field_178784_b);
                    if (!player.func_175151_a(adjustedPos, result.field_178784_b, stack)) {
                        return new ActionResult(EnumActionResult.PASS, (Object)stack);
                    }
                    if (this.tryPlaceContainedLiquid(world, stack, xOffset, yOffset, zOffset, adjustedPos) && !player.field_71075_bZ.field_75098_d) {
                        fluidHandler.drain(new FluidStack(FluidRegistry.LAVA, 1000), true);
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private IFluidHandler getFluidHandler(ItemStack stack) {
        if (!stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return null;
        }
        return (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack ist, double par2, double par4, double par6, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_185904_a();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        world.func_180501_a(pos, Blocks.field_150356_k.func_176223_P(), 3);
        return true;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerInfernalChalice(stack);
    }
}

