/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.waila.provider;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.blocks.BlockApothecaryMortar;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.compat.waila.provider.CachedBodyDataProvider;
import xreliquary.util.LanguageHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionIngredient;
import xreliquary.util.potions.XRPotionHelper;

public class DataProviderMortar
extends CachedBodyDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaBodyToCache(ItemStack itemStack, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ArrayList<String> currenttip = new ArrayList<String>();
        if (!(accessor.getBlock() instanceof BlockApothecaryMortar) || !(accessor.getTileEntity() instanceof TileEntityMortar)) {
            return currenttip;
        }
        TileEntityMortar mortar = (TileEntityMortar)accessor.getTileEntity();
        if (mortar == null) {
            return currenttip;
        }
        ItemStack[] ingredients = mortar.getItemStacks();
        if (ingredients[0] == null) {
            return currenttip;
        }
        String ingredient1 = ingredients[0].func_82833_r();
        String ingredient2 = ingredients[1] == null ? "" : ", " + ingredients[1].func_82833_r();
        String ingredient3 = ingredients[2] == null ? "" : ", " + ingredients[2].func_82833_r();
        currenttip.add(ingredient1 + ingredient2 + ingredient3);
        if (ingredients[1] == null) {
            return currenttip;
        }
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        potionIngredients.add(XRPotionHelper.getIngredient(ingredients[0]));
        potionIngredients.add(XRPotionHelper.getIngredient(ingredients[1]));
        if (ingredients[2] != null) {
            potionIngredients.add(XRPotionHelper.getIngredient(ingredients[2]));
        }
        PotionEssence essence = new PotionEssence(potionIngredients.toArray(new PotionIngredient[potionIngredients.size()]));
        if (essence.effects.size() > 0) {
            currenttip.add(ChatFormatting.WHITE + LanguageHelper.getLocalization("waila.xreliquary.mortar.result") + ChatFormatting.RESET);
            ArrayList<String> effectLines = new ArrayList<String>();
            XRPotionHelper.addPotionInfo(essence, effectLines, false);
            StringBuilder sb = new StringBuilder();
            int effectsInLine = 0;
            Iterator iterator = effectLines.iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                sb.append(line);
                if (++effectsInLine == 2) {
                    effectsInLine = 0;
                    currenttip.add(sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            if (sb.length() > 0) {
                currenttip.add(sb.toString());
            }
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return null;
    }
}

