/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.movement.FenceGateMovement;
import net.malisis.doors.sound.FenceGateSound;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

@Syncable(value="TileEntity")
public class FenceGateTileEntity
extends DoorTileEntity {
    private IBlockState camoState;
    private int camoColor = -1;
    private boolean isWall = false;

    public FenceGateTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(FenceGateMovement.class));
        descriptor.setSound(DoorRegistry.getSound(FenceGateSound.class));
        this.setDescriptor(descriptor);
    }

    @Override
    public IBlockState getBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public IBlockState getCamoState() {
        return this.camoState;
    }

    public int getCamoColor() {
        return this.camoColor;
    }

    public boolean isWall() {
        return this.isWall;
    }

    @Override
    public EnumFacing getDirection() {
        return (EnumFacing)this.getBlockState().func_177229_b((IProperty)BlockTrapDoor.field_176284_a);
    }

    public void updateAll() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Pair<IBlockState, Integer> pair = this.updateCamo();
        this.camoState = (IBlockState)pair.getLeft();
        this.camoColor = (Integer)pair.getRight();
        this.isWall = this.updateWall();
        TileEntityUtils.notifyUpdate((TileEntity)this);
    }

    private Pair<IBlockState, Integer> updateCamo() {
        EnumFacing dir = this.getDirection().func_176746_e();
        BlockPos p = this.field_174879_c.func_177972_a(dir);
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)p));
        if (this.isMatchingDoubleDoor(te)) {
            p = p.func_177972_a(dir);
        }
        IBlockState state1 = this.field_145850_b.func_180495_p(p);
        int color1 = MalisisRenderer.colorMultiplier((IBlockAccess)this.field_145850_b, (BlockPos)p, (IBlockState)state1);
        if (state1.func_177230_c().isAir(state1, (IBlockAccess)this.field_145850_b, p)) {
            return Pair.of((Object)this.getBlockState(), (Object)-1);
        }
        p = this.field_174879_c.func_177972_a(dir = dir.func_176734_d());
        te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)p));
        if (this.isMatchingDoubleDoor(te)) {
            p = p.func_177972_a(dir);
        }
        IBlockState state2 = this.field_145850_b.func_180495_p(p);
        int color2 = MalisisRenderer.colorMultiplier((IBlockAccess)this.field_145850_b, (BlockPos)p, (IBlockState)state2);
        if (state1.func_177230_c().isAir(state2, (IBlockAccess)this.field_145850_b, p)) {
            return Pair.of((Object)this.getBlockState(), (Object)-1);
        }
        if (!state1.equals(state2) || color1 != color2) {
            return Pair.of((Object)this.getBlockState(), (Object)-1);
        }
        return Pair.of((Object)state1, (Object)color1);
    }

    private boolean updateWall() {
        EnumFacing dir = this.getDirection().func_176746_e();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir));
        if (state.func_177230_c() == Blocks.field_150463_bK) {
            return true;
        }
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir.func_176734_d()));
        return state.func_177230_c() == Blocks.field_150463_bK;
    }

    @Override
    public FenceGateTileEntity getDoubleDoor() {
        if (!this.descriptor.isDoubleDoor()) {
            return null;
        }
        EnumFacing dir = this.getDirection().func_176746_e();
        FenceGateTileEntity te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir)));
        if (te != null && this.isMatchingDoubleDoor(te)) {
            return te;
        }
        te = (FenceGateTileEntity)((Object)TileEntityUtils.getTileEntity(FenceGateTileEntity.class, (IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir.func_176734_d())));
        if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor(te)) {
            return te;
        }
        return null;
    }

    @Override
    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (te == null) {
            return false;
        }
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        return this.getDirection().func_176740_k() == te.getDirection().func_176740_k();
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }
}

