/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.malisis.core.block.IComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.TransformBuilder;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.block.Door;
import net.malisis.doors.iconprovider.DoorIconProvider;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.ArrayUtils;

public class DoorRenderer
extends MalisisRenderer<DoorTileEntity> {
    protected EnumFacing direction;
    protected boolean opened;
    protected boolean hingeLeft;
    protected boolean topBlock;
    protected MalisisModel model;
    protected RenderParameters rp;
    protected AnimationRenderer ar = new AnimationRenderer();
    protected Matrix4f gui = new TransformBuilder().translate(0.15f, -0.25f, 0.0f).rotate(30.0f, 45.0f, 0.0f).scale(0.46f).get();
    protected Matrix4f thirdPerson = new TransformBuilder().translate(0.1f, 0.3f, 0.3f).rotate(90.0f, 90.0f, 135.0f).scale(0.3f).get();
    protected Matrix4f firstPerson = new TransformBuilder().translate(0.2f, 0.0f, 0.0f).rotate(0.0f, 90.0f, 0.0f).scale(0.3f).get();
    protected Matrix4f ground = new TransformBuilder().scale(0.25f).get();

    public DoorRenderer() {
        this.registerFor(DoorTileEntity.class);
        this.setBatched();
    }

    public DoorRenderer(boolean noRegister) {
        this.setBatched();
    }

    protected void initialize() {
        Cube bottom = new Cube();
        bottom.setSize(1.0f, 1.0f, 0.1875f);
        bottom.scale(1.0f, 1.0f, 0.995f);
        Shape top = new Shape((Shape)bottom);
        top.translate(0.0f, 1.0f, 0.0f);
        this.model = new MalisisModel();
        this.model.addShape("bottom", (Shape)bottom);
        this.model.addShape("top", top);
        this.model.storeState();
        this.initParams();
        this.ensureBlock(new Class[]{Door.class});
    }

    protected void initParams() {
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
    }

    public boolean isGui3d() {
        return (Boolean)MalisisDoorsSettings.use3DItems.get();
    }

    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        if (!this.isGui3d()) {
            return DefaultRenderer.item.getTransform(item, tranformType);
        }
        switch (tranformType) {
            case GUI: {
                return this.gui;
            }
            case FIRST_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                return this.firstPerson;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                return this.thirdPerson;
            }
            case GROUND: {
                return this.ground;
            }
        }
        return null;
    }

    public void render() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        this.rp.icon.set(null);
        this.rp.brightness.reset();
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.setTileEntity();
            this.setup();
            this.renderTileEntity();
        }
        if (this.renderType == RenderType.ITEM) {
            if (!this.isGui3d()) {
                DefaultRenderer.item.setTransformType(this.tranformType);
                DefaultRenderer.item.renderItem(this.itemStack, this.partialTick);
                return;
            }
            this.setItem();
            this.setup();
            this.renderItem();
        }
    }

    protected void setup() {
        this.model.resetState();
        if (this.direction == EnumFacing.NORTH) {
            this.model.rotate(180.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.direction == EnumFacing.WEST) {
            this.model.rotate(-90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.direction == EnumFacing.EAST) {
            this.model.rotate(90.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.tileEntity != null && ((DoorTileEntity)this.tileEntity).isCentered()) {
            this.model.translate(0.0f, 0.0f, 0.40625f);
        }
    }

    protected void setTileEntity() {
        this.direction = ((DoorTileEntity)this.tileEntity).getDirection();
        this.opened = ((DoorTileEntity)this.tileEntity).isOpened();
        this.hingeLeft = ((DoorTileEntity)this.tileEntity).isHingeLeft();
    }

    protected void renderTileEntity() {
        this.ar.setStartTime(((DoorTileEntity)this.tileEntity).getTimer().getStart());
        List toRender = new ArrayList();
        if (((DoorTileEntity)this.tileEntity).getMovement() != null) {
            Object[] anims = ((DoorTileEntity)this.tileEntity).getMovement().getAnimations((DoorTileEntity)this.tileEntity, this.model, this.rp);
            toRender = this.ar.animate(anims);
            if (!ArrayUtils.isEmpty((Object[])anims) && toRender.size() == 0) {
                return;
            }
        }
        this.rp.rotateIcon.set((Object)false);
        this.topBlock = false;
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
        this.drawShape(this.model.getShape("bottom"), this.rp);
        this.topBlock = true;
        this.set(this.pos.func_177984_a());
        this.set(this.blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
        this.rp.brightness.set((Object)this.blockState.func_185889_a(this.world, this.pos));
        this.drawShape(this.model.getShape("top"), this.rp);
        this.set(this.pos.func_177977_b());
    }

    protected boolean shouldRenderFace(Face face, RenderParameters params) {
        if (this.block != MalisisDoors.Blocks.doorOak && this.block != MalisisDoors.Blocks.doorAcacia && this.block != MalisisDoors.Blocks.doorBirch && this.block != MalisisDoors.Blocks.doorDarkOak && this.block != MalisisDoors.Blocks.doorJungle && this.block != MalisisDoors.Blocks.doorSpruce && this.block != MalisisDoors.Blocks.doorIron) {
            return super.shouldRenderFace(face, params);
        }
        if (!this.topBlock && face.name().equals("Top")) {
            return false;
        }
        if (this.topBlock && face.name().equals("Bottom")) {
            return false;
        }
        return super.shouldRenderFace(face, params);
    }

    protected void setItem() {
        this.set(((DoorItem)this.item).getDescriptor(this.itemStack).getBlock());
        this.direction = EnumFacing.SOUTH;
        this.hingeLeft = true;
    }

    protected void renderItem() {
        this.topBlock = false;
        this.drawShape(this.model.getShape("bottom"), this.rp);
        this.topBlock = true;
        this.drawShape(this.model.getShape("top"), this.rp);
    }

    protected Icon getIcon(Face face, RenderParameters params) {
        if (params.icon.get() != null) {
            return (Icon)params.icon.get();
        }
        DoorIconProvider iconProvider = (DoorIconProvider)IComponent.getComponent(DoorIconProvider.class, (Object)this.block);
        if (iconProvider == null) {
            return super.getIcon(face, params);
        }
        return iconProvider.getIcon(this.topBlock, this.hingeLeft, (EnumFacing)params.textureSide.get());
    }
}

