/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class VanishingDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION) {
            return null;
        }
        return IDoorMovement.getFullBoundingBox(topBlock, type);
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        AlphaTransform alpha = new AlphaTransform(255, 0);
        alpha.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        alpha.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return new Animation[]{new Animation((ITransformable)rp, (Transformation)alpha)};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

