/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.RustyHatchTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class RustyHatchMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getClosedBoundingBox(DoorTileEntity te, boolean topBlock, BoundingBoxType type) {
        return new AxisAlignedBB(-1.0, topBlock ? 0.875 : 0.0, 0.0, 1.0, topBlock ? 1.0 : 0.125, 2.0);
    }

    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        float f = 0.125f;
        return new AxisAlignedBB((double)(-1.0f + f), topBlock ? 1.0 : (double)(-2.0f + 2.0f * f), (double)f, (double)(1.0f - f), topBlock ? (double)(3.0f - 2.0f * f) : 0.0, (double)(2.0f * f));
    }

    private Rotation getDoorTransformation(DoorTileEntity tileEntity) {
        float f;
        float offX = f = -0.375f;
        float offY = f;
        float toAngle = 90.0f;
        if (!((RustyHatchTileEntity)tileEntity).isTop()) {
            toAngle = -toAngle;
            offY = -0.5f;
        }
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        Rotation rotation = (Rotation)new Rotation(toAngle).aroundAxis(0.0f, 0.0f, 1.0f).offset(offX, offY, 0.0f).movement(1);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            rotation.reversed(true);
        } else {
            rotation.delay(t);
        }
        rotation.forTicks(t);
        return rotation;
    }

    private Rotation getHandleTransformation(DoorTileEntity tileEntity) {
        int t = tileEntity.getDescriptor().getOpeningTime() / 2;
        Rotation rotation = (Rotation)new Rotation(400.0f).aroundAxis(0.0f, 1.0f, 0.0f).offset(0.5f, 0.0f, 0.5f).movement(1);
        if (tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED) {
            ((Rotation)rotation.delay(t)).reversed(true);
        }
        rotation.forTicks(t);
        return rotation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        ParallelTransformation transform = new ParallelTransformation(new Transformation[]{this.getDoorTransformation(tileEntity), this.getHandleTransformation(tileEntity)});
        return new Animation[]{new Animation((ITransformable)model.getShape("door"), (Transformation)this.getDoorTransformation(tileEntity)), new Animation((ITransformable)model.getShape("handle"), (Transformation)transform)};
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

