/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.MergedVertex;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CurtainMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        AxisAlignedBB aabb = IDoorMovement.getFullBoundingBox(topBlock, type);
        return new AxisAlignedBB(tileEntity.isHingeLeft() ? 0.8125 : aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, tileEntity.isHingeLeft() ? aabb.field_72336_d : 0.1875, aabb.field_72337_e, aabb.field_72334_f);
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        float x = 0.8125f;
        String dir = "west";
        EnumFacing fd = EnumFacing.WEST;
        if (!tileEntity.isHingeLeft()) {
            x = -0.8125f;
            dir = "east";
            fd = EnumFacing.EAST;
        }
        Translation translation = new Translation(x, 0.0f, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        Shape top = model.getShape("top");
        Shape bottom = model.getShape("bottom");
        top.enableMergedVertexes();
        bottom.enableMergedVertexes();
        List vertexes = top.getMergedVertexes(new String[]{"bottom", dir});
        vertexes.addAll(bottom.getMergedVertexes(fd));
        Animation[] anims = new Animation[vertexes.size()];
        int i = 0;
        for (MergedVertex mv : vertexes) {
            anims[i++] = new Animation((ITransformable)mv, (Transformation)translation);
        }
        return anims;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

