/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorState;
import net.malisis.doors.gui.DigicodeGui;
import net.malisis.doors.iconprovider.DoorIconProvider;
import net.malisis.doors.renderer.DoorRenderer;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@MalisisRendered(item=DoorRenderer.class)
public class Door
extends BlockDoor
implements IBoundingBox,
IComponentProvider,
IRegisterable {
    public static Block[] centerBlocks = new Block[]{Blocks.field_150411_aY, Blocks.field_150463_bK, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180406_aS, Blocks.field_180405_aT};
    public static final float DOOR_WIDTH = 0.1875f;
    protected DoorDescriptor descriptor;
    protected final List<IComponent> components = Lists.newArrayList();

    public Door(DoorDescriptor desc) {
        super(desc.getMaterial());
        this.descriptor = (DoorDescriptor)Preconditions.checkNotNull((Object)desc);
        this.func_149711_c(desc.getHardness());
        this.func_149672_a(desc.getSoundType());
        this.func_149663_c(desc.getName());
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)this.getIconProvider());
        }
    }

    public Door(Material material) {
        super(material);
    }

    public DoorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Item getItem(Block block) {
        return null;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    public List<IComponent> getComponents() {
        return this.components;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIconProvider getIconProvider() {
        return new DoorIconProvider(this.descriptor);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        te.onBlockPlaced(this, itemStack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        if (te.getDescriptor() == null) {
            return true;
        }
        if (te.getDescriptor().hasCode() && !te.isOpened()) {
            if (world.field_72995_K) {
                new DigicodeGui(te).display();
            }
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY) {
            return true;
        }
        if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_LOCK) {
            if (te.isPowered()) {
                return true;
            }
            DoorTileEntity door = te.getDoubleDoor();
            if (door != null && door.isPowered()) {
                return true;
            }
        }
        if (te.getDescriptor().getAutoCloseTime() > 0 && !te.isOpened()) {
            world.func_180497_b(pos, (Block)this, te.getDescriptor().getAutoCloseTime() + te.getDescriptor().getOpeningTime(), 0);
        }
        te.openOrCloseDoor();
        return true;
    }

    public void func_176512_a(World world, BlockPos pos, boolean opening) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        if (te.getDescriptor().hasCode()) {
            return;
        }
        if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY) {
            return;
        }
        if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_LOCK && te.isPowered()) {
            return;
        }
        if (opening == te.isOpened()) {
            return;
        }
        te.openOrCloseDoor();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!Door.isTop(state)) {
            ItemStack itemStack = null;
            IBlockState upState = world.func_180495_p(pos.func_177984_a());
            if (upState.func_177230_c() != this) {
                itemStack = this.getDoorItemStack((IBlockAccess)world, pos);
                world.func_175698_g(pos);
            }
            if (!world.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
                itemStack = this.getDoorItemStack((IBlockAccess)world, pos);
                world.func_175698_g(pos);
                if (upState.func_177230_c() == this) {
                    world.func_175698_g(pos.func_177984_a());
                }
            }
            if (itemStack != null) {
                if (!world.field_72995_K) {
                    Door.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            } else {
                DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
                if (te == null || te.getDescriptor() == null) {
                    return;
                }
                if (te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.HAND_ONLY || te.getDescriptor().getRedstoneBehavior() == DoorDescriptor.RedstoneBehavior.REDSTONE_LOCK) {
                    return;
                }
                if (te.getDescriptor().hasCode()) {
                    return;
                }
                boolean powered = te.isPowered();
                if ((powered || block.func_176223_P().func_185897_m()) && block != this) {
                    te.setPowered(powered);
                }
                boolean centered = te.shouldCenter();
                DoorTileEntity dd = te.getDoubleDoor();
                if (dd != null) {
                    dd.setCentered(centered |= dd.shouldCenter());
                }
                te.setCentered(centered);
            }
        } else {
            IBlockState downState = world.func_180495_p(pos.func_177977_b());
            if (downState.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (block != this) {
                this.func_189540_a(downState, world, pos.func_177977_b(), block);
            }
        }
    }

    protected ItemStack getDoorItemStack(IBlockAccess world, BlockPos pos) {
        DoorTileEntity te = Door.getDoor(world, pos);
        return te != null ? te.getItemStack() : null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDoorItemStack((IBlockAccess)world, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return ImmutableList.of();
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        AxisAlignedBB aabb;
        DoorTileEntity te = Door.getDoor(world, pos);
        if (te == null || te.isMoving() || te.getMovement() == null) {
            return null;
        }
        AxisAlignedBB axisAlignedBB = aabb = te.isOpened() ? te.getMovement().getOpenBoundingBox(te, te.isTopBlock(pos), type) : te.getMovement().getClosedBoundingBox(te, te.isTopBlock(pos), type);
        if (aabb != null && te.isCentered()) {
            aabb = aabb.func_72317_d(0.0, 0.0, 0.40625);
        }
        aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (EnumFacing)te.getDirection());
        return aabb;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entityIn) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.COLLISION);
        for (AxisAlignedBB aabb : AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)) {
            if (aabb == null || !mask.func_72326_a(aabb)) continue;
            list.add(aabb);
        }
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        Object[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AABBUtils.empty((BlockPos)pos);
        }
        return AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)[0];
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        return new RaytraceBlock(world, src, dest, pos).trace();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        if (te.getDescriptor().getAutoCloseTime() <= 0) {
            return;
        }
        if (te.getState() == DoorState.CLOSED || te.getState() == DoorState.CLOSING) {
            return;
        }
        te.openOrCloseDoor();
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block b = world.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return ArrayUtils.contains((Object[])centerBlocks, (Object)b);
    }

    public boolean hasTileEntity(IBlockState state) {
        return !Door.isTop(state);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        DoorTileEntity te;
        if (Door.isTop(state)) {
            return null;
        }
        try {
            te = this.descriptor.getTileEntityClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            te = new DoorTileEntity();
        }
        te.setDescriptor(this.descriptor);
        return te;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public static DoorTileEntity getDoor(IBlockAccess world, BlockPos pos) {
        DoorTileEntity te;
        IBlockState state = world.func_180495_p(pos);
        if (Door.isTop(state)) {
            pos = pos.func_177977_b();
        }
        if ((te = (DoorTileEntity)((Object)TileEntityUtils.getTileEntity(DoorTileEntity.class, (IBlockAccess)world, (BlockPos)pos))) != null && te.func_145831_w() == null && world instanceof World) {
            MalisisCore.log.error("[MalisisDoors] DoorTileEntity found without a world!");
            te.func_174878_a(pos);
            te.func_145834_a((World)world);
        }
        return te;
    }

    public static boolean isTop(IBlockState state) {
        return state.func_177230_c() instanceof Door && state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER;
    }
}

