/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.Filter;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.network.SyncRulesHelper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSyncRules
implements IMessage {
    private List<Pair<Filter, Settings>> rules;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.rules = new ArrayList<Pair<Filter, Settings>>(size);
        for (int i = 0; i < size; ++i) {
            Filter filter = new Filter(buf);
            Settings settings = new Settings(buf);
            this.rules.add((Pair<Filter, Settings>)Pair.of((Object)filter, (Object)settings));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.rules.size());
        for (Pair<Filter, Settings> rule : this.rules) {
            Filter filter = (Filter)rule.getLeft();
            Settings settings = (Settings)rule.getRight();
            filter.toBytes(buf);
            settings.toBytes(buf);
        }
        Logging.log((String)("Rules packet size: " + buf.writerIndex() + " of " + buf.array().length));
    }

    public List<Pair<Filter, Settings>> getRules() {
        return this.rules;
    }

    public PacketSyncRules() {
    }

    public PacketSyncRules(List<Pair<Filter, Settings>> rules) {
        this.rules = rules;
    }

    public static class Handler
    implements IMessageHandler<PacketSyncRules, IMessage> {
        public IMessage onMessage(PacketSyncRules message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> SyncRulesHelper.syncRulesFromServer(message));
            return null;
        }
    }
}

