/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items.modules;

import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.ILevelRenderHelper;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleDataContents;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DimensionClientScreenModule
implements IClientScreenModule<IModuleDataContents> {
    private String line = "";
    private int color = 0xFFFFFF;
    private int rfcolor = 0xFFFFFF;
    private int rfcolorNeg = 0xFFFFFF;
    private boolean hidebar = false;
    private boolean hidetext = false;
    private boolean showdiff = false;
    private boolean showpct = false;
    private FormatStyle format = FormatStyle.MODE_FULL;
    private TextAlign textAlign = TextAlign.ALIGN_LEFT;
    private ITextRenderHelper labelCache = null;
    private ILevelRenderHelper levelCache = null;

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataContents screenData, ModuleRenderInfo renderInfo) {
        int xoffset;
        if (this.labelCache == null) {
            this.labelCache = renderHelper.createTextRenderHelper().align(this.textAlign);
            this.levelCache = renderHelper.createLevelRenderHelper().label("RF").settings(this.hidebar, this.hidetext, this.showpct, this.showdiff).color(this.rfcolor, this.rfcolorNeg).gradient(-65536, -13421824).format(this.format);
        }
        GlStateManager.func_179140_f();
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        this.levelCache.render(xoffset, currenty, screenData, renderInfo);
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", new String[]{"Label text"}).color("color", new String[]{"Color for the label"}).nl().label("RF+:").color("rfcolor", new String[]{"Color for the RF text"}).label("RF-:").color("rfcolor_neg", new String[]{"Color for the negative", "RF/tick ratio"}).nl().toggleNegative("hidebar", "Bar", new String[]{"Toggle visibility of the", "energy bar"}).mode("RF").format("format").nl().label("Dimension:").integer("dim", new String[]{"The id of the dimension", "to monitor"}).nl().choices("align", "Label alignment", new String[]{"Left", "Center", "Right"}).nl();
    }

    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.rfcolor = tagCompound.func_74764_b("rfcolor") ? tagCompound.func_74762_e("rfcolor") : 0xFFFFFF;
            this.rfcolorNeg = tagCompound.func_74764_b("rfcolor_neg") ? tagCompound.func_74762_e("rfcolor_neg") : 0xFFFFFF;
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.textAlign = TextAlign.get((String)alignment);
            } else {
                this.textAlign = TextAlign.ALIGN_LEFT;
            }
            this.hidebar = tagCompound.func_74767_n("hidebar");
            this.hidetext = tagCompound.func_74767_n("hidetext");
            this.showdiff = tagCompound.func_74767_n("showdiff");
            this.showpct = tagCompound.func_74767_n("showpct");
            this.format = FormatStyle.values()[tagCompound.func_74762_e("format")];
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

