/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain.lost;

import java.util.Random;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.City;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.DamageArea;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.LostCitiesTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.Style;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.BridgeData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.DataCenterData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.FloorsData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.FountainData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.Level;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.LibraryData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.ParkData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.RoofTopsData;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;

public class BuildingInfo {
    public final int chunkX;
    public final int chunkZ;
    public final long seed;
    public final boolean isCity;
    public final boolean hasBuilding;
    public final int building2x2Section;
    public final int buildingType;
    public final int fountainType;
    public final int parkType;
    public final int bridgeType;
    public final StreetType streetType;
    public final int floors;
    public final int floorsBelowGround;
    public final int[] floorTypes;
    public final boolean[] connectionAtX;
    public final boolean[] connectionAtZ;
    public final int topType;
    public final int glassType;
    public final int glassColor;
    public final int buildingStyle;
    public final boolean isLibrary;
    public final boolean isDataCenter;
    public final boolean xBridge;
    public final boolean zBridge;
    public final boolean xRailCorridor;
    public final boolean zRailCorridor;
    public final Block doorBlock;
    private BuildingInfo xmin = null;
    private BuildingInfo xmax = null;
    private BuildingInfo zmin = null;
    private BuildingInfo zmax = null;
    private DamageArea damageArea = null;
    private Style style = null;

    public DamageArea getDamageArea() {
        if (this.damageArea == null) {
            this.damageArea = new DamageArea(this.seed, this.chunkX, this.chunkZ);
        }
        return this.damageArea;
    }

    public Style getStyle() {
        if (this.style != null) {
            return this.style;
        }
        this.style = new Style();
        if (!this.isCity) {
            this.style.bricks = Blocks.field_150417_aV.func_176223_P();
            this.style.bricks_variant = Blocks.field_150334_T.func_176223_P();
            this.style.bricks_cracked = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
            this.style.bricks_mossy = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
            return this.style;
        }
        this.style.street = Blocks.field_150334_T.func_176223_P();
        this.style.street2 = Blocks.field_150336_V.func_176223_P();
        switch (this.glassColor) {
            case 0: {
                this.style.glass_full = this.style.glass = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.WHITE);
                break;
            }
            case 1: {
                this.style.glass_full = this.style.glass = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.GRAY);
                break;
            }
            case 2: {
                this.style.glass_full = this.style.glass = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.LIGHT_BLUE);
                break;
            }
            case 3: {
                this.style.glass_full = this.style.glass = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.BLUE);
                break;
            }
            case 4: {
                this.style.glass = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.WHITE);
                this.style.glass_full = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.WHITE);
                break;
            }
            case 5: {
                this.style.glass = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.GRAY);
                this.style.glass_full = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.GRAY);
                break;
            }
            case 6: {
                this.style.glass = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.LIGHT_BLUE);
                this.style.glass_full = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.LIGHT_BLUE);
                break;
            }
            case 7: {
                this.style.glass = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.BLUE);
                this.style.glass_full = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)EnumDyeColor.BLUE);
                break;
            }
            case 8: {
                this.style.glass = Blocks.field_150410_aZ.func_176223_P();
                this.style.glass_full = Blocks.field_150359_w.func_176223_P();
                break;
            }
            default: {
                this.style.glass_full = this.style.glass = Blocks.field_150359_w.func_176223_P();
            }
        }
        this.style.quartz = Blocks.field_150371_ca.func_176223_P();
        switch (this.buildingStyle) {
            case 0: {
                this.style.bricks = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN);
                this.style.bricks_variant = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK);
                this.style.bricks_cracked = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN);
                this.style.bricks_mossy = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN);
                this.style.bricks_monster = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.CYAN);
                break;
            }
            case 1: {
                this.style.bricks = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY);
                this.style.bricks_variant = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BLACK);
                this.style.bricks_cracked = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY);
                this.style.bricks_mossy = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY);
                this.style.bricks_monster = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.GRAY);
                break;
            }
            case 2: {
                this.style.bricks = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                this.style.bricks_variant = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.BROWN);
                this.style.bricks_cracked = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                this.style.bricks_mossy = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                this.style.bricks_monster = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.SILVER);
                break;
            }
            default: {
                this.style.bricks = Blocks.field_150417_aV.func_176223_P();
                this.style.bricks_variant = Blocks.field_150334_T.func_176223_P();
                this.style.bricks_cracked = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
                this.style.bricks_mossy = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                this.style.bricks_monster = Blocks.field_150418_aU.func_176223_P().func_177226_a((IProperty)BlockSilverfish.field_176378_a, (Comparable)BlockSilverfish.EnumType.STONEBRICK);
            }
        }
        return this.style;
    }

    public BuildingInfo getAdjacent(int x, int z) {
        if (x == 0) {
            return this.getXmin();
        }
        if (x == 15) {
            return this.getXmax();
        }
        if (z == 0) {
            return this.getZmin();
        }
        if (z == 15) {
            return this.getZmax();
        }
        return null;
    }

    public BuildingInfo getXmin() {
        if (this.xmin == null) {
            this.xmin = new BuildingInfo(this.chunkX - 1, this.chunkZ, this.seed);
        }
        return this.xmin;
    }

    public BuildingInfo getXmax() {
        if (this.xmax == null) {
            this.xmax = new BuildingInfo(this.chunkX + 1, this.chunkZ, this.seed);
        }
        return this.xmax;
    }

    public BuildingInfo getZmin() {
        if (this.zmin == null) {
            this.zmin = new BuildingInfo(this.chunkX, this.chunkZ - 1, this.seed);
        }
        return this.zmin;
    }

    public BuildingInfo getZmax() {
        if (this.zmax == null) {
            this.zmax = new BuildingInfo(this.chunkX, this.chunkZ + 1, this.seed);
        }
        return this.zmax;
    }

    public int getMaxHeight() {
        return this.hasBuilding ? 69 + this.floors * 6 : 63;
    }

    public Level[] getFloorData() {
        if (this.isLibrary) {
            switch (this.building2x2Section) {
                case 0: {
                    return LibraryData.LIBRARY00;
                }
                case 1: {
                    return LibraryData.LIBRARY10;
                }
                case 2: {
                    return LibraryData.LIBRARY01;
                }
                case 3: {
                    return LibraryData.LIBRARY11;
                }
            }
        }
        if (this.isDataCenter) {
            switch (this.building2x2Section) {
                case 0: {
                    return DataCenterData.CENTER00;
                }
                case 1: {
                    return DataCenterData.CENTER10;
                }
                case 2: {
                    return DataCenterData.CENTER01;
                }
                case 3: {
                    return DataCenterData.CENTER11;
                }
            }
        }
        switch (this.buildingType) {
            case 0: {
                return FloorsData.FLOORS;
            }
            case 1: {
                return FloorsData.FLOORS2;
            }
            case 2: {
                return FloorsData.FLOORS3;
            }
        }
        return FloorsData.FLOORS;
    }

    public Level getTopData(int floortype) {
        if (this.isLibrary) {
            switch (this.building2x2Section) {
                case 0: {
                    return LibraryData.TOPS_LIBRARY00[floortype];
                }
                case 1: 
                case 2: 
                case 3: {
                    return LibraryData.TOPS_LIBRARY[floortype];
                }
            }
            return RoofTopsData.TOPS[floortype];
        }
        if (this.isDataCenter) {
            switch (this.building2x2Section) {
                case 0: {
                    return DataCenterData.TOPS_CENTER00[floortype];
                }
                case 1: 
                case 2: 
                case 3: {
                    return DataCenterData.TOPS_CENTER[floortype];
                }
            }
            return RoofTopsData.TOPS[floortype];
        }
        return RoofTopsData.TOPS[floortype];
    }

    public int getGenInfoIndex() {
        if (this.isLibrary) {
            return this.building2x2Section + 10;
        }
        if (this.isDataCenter) {
            return this.building2x2Section + 20;
        }
        return this.buildingType;
    }

    private static boolean isCity(int chunkX, int chunkZ, long seed) {
        float cityFactor = City.getCityFactor(seed, chunkX, chunkZ);
        return cityFactor > LostCityConfiguration.CITY_THRESSHOLD;
    }

    private static boolean isCandidateForTopLeftOf2x2Building(int chunkX, int chunkZ, long seed) {
        if (chunkX == 0 && chunkZ == 0) {
            return false;
        }
        float cityFactor = City.getCityFactor(seed, chunkX, chunkZ);
        if (cityFactor > LostCityConfiguration.CITY_THRESSHOLD) {
            Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, seed);
            return rand.nextFloat() < LostCityConfiguration.BUILDING2X2_CHANCE;
        }
        return false;
    }

    private static boolean isTopLeftOf2x2Building(int chunkX, int chunkZ, long seed) {
        if (!(!BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ - 1, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ - 1, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ - 1, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX + 1, chunkZ + 1, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX, chunkZ + 1, seed) || BuildingInfo.isCandidateForTopLeftOf2x2Building(chunkX - 1, chunkZ + 1, seed))) {
            return BuildingInfo.isCity(chunkX + 1, chunkZ, seed) && BuildingInfo.isCity(chunkX + 1, chunkZ + 1, seed) && BuildingInfo.isCity(chunkX, chunkZ + 1, seed);
        }
        return false;
    }

    public BuildingInfo(int chunkX, int chunkZ, long seed) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.seed = seed;
        float cityFactor = City.getCityFactor(seed, chunkX, chunkZ);
        boolean bl = this.isCity = cityFactor > LostCityConfiguration.CITY_THRESSHOLD;
        this.building2x2Section = BuildingInfo.isTopLeftOf2x2Building(chunkX, chunkZ, seed) ? 0 : (BuildingInfo.isTopLeftOf2x2Building(chunkX - 1, chunkZ, seed) ? 1 : (BuildingInfo.isTopLeftOf2x2Building(chunkX, chunkZ - 1, seed) ? 2 : (BuildingInfo.isTopLeftOf2x2Building(chunkX - 1, chunkZ - 1, seed) ? 3 : -1)));
        Random rand = BuildingInfo.getBuildingRandom(chunkX, chunkZ, seed);
        boolean bl2 = this.hasBuilding = this.building2x2Section >= 0 || this.isCity && (chunkX != 0 || chunkZ != 0) && rand.nextFloat() < LostCityConfiguration.BUILDING_CHANCE;
        if (this.building2x2Section >= 1) {
            BuildingInfo topleft;
            switch (this.building2x2Section) {
                case 1: {
                    topleft = this.getXmin();
                    break;
                }
                case 2: {
                    topleft = this.getZmin();
                    break;
                }
                case 3: {
                    topleft = this.getXmin().getZmin();
                    break;
                }
                default: {
                    throw new RuntimeException("What!");
                }
            }
            this.isLibrary = topleft.isLibrary;
            this.isDataCenter = topleft.isDataCenter;
            this.buildingType = topleft.buildingType;
            this.streetType = topleft.streetType;
            this.fountainType = topleft.fountainType;
            this.parkType = topleft.parkType;
            this.floors = topleft.floors;
            this.floorsBelowGround = topleft.floorsBelowGround;
            this.glassType = topleft.glassType;
            this.glassColor = topleft.glassColor;
            this.buildingStyle = topleft.buildingStyle;
            this.doorBlock = topleft.doorBlock;
            this.bridgeType = topleft.bridgeType;
        } else {
            int bt = rand.nextInt(3);
            if (bt == 2 && rand.nextFloat() < 0.5f) {
                bt = rand.nextInt(3);
            }
            this.buildingType = bt;
            this.isLibrary = this.building2x2Section == 0 ? rand.nextFloat() < LostCityConfiguration.LIBRARY_CHANCE : false;
            this.isDataCenter = this.building2x2Section == 0 && !this.isLibrary ? rand.nextFloat() < LostCityConfiguration.LIBRARY_CHANCE : false;
            this.streetType = rand.nextDouble() < (double)0.2f ? StreetType.values()[rand.nextInt(StreetType.values().length)] : StreetType.NORMAL;
            this.fountainType = rand.nextFloat() < LostCityConfiguration.FOUNTAIN_CHANCE ? rand.nextInt(FountainData.FOUNTAINS.length) : -1;
            this.parkType = rand.nextInt(ParkData.PARKS.length);
            int f = LostCityConfiguration.BUILDING_MINFLOORS + rand.nextInt((int)((float)LostCityConfiguration.BUILDING_MINFLOORS_CHANCE + (cityFactor + 0.1f) * (float)(LostCityConfiguration.BUILDING_MAXFLOORS_CHANCE - LostCityConfiguration.BUILDING_MINFLOORS_CHANCE)));
            if (f > LostCityConfiguration.BUILDING_MAXFLOORS) {
                f = LostCityConfiguration.BUILDING_MAXFLOORS;
            }
            this.floors = f;
            this.floorsBelowGround = LostCityConfiguration.BUILDING_MINCELLARS + (LostCityConfiguration.BUILDING_MAXCELLARS <= 0 ? 0 : rand.nextInt(LostCityConfiguration.BUILDING_MAXCELLARS));
            this.glassType = rand.nextInt(4);
            this.glassColor = rand.nextInt(10);
            this.buildingStyle = rand.nextInt(4);
            this.doorBlock = this.getRandomDoor(rand);
            this.bridgeType = rand.nextInt(BridgeData.BRIDGES.length);
        }
        if (this.isLibrary) {
            switch (this.building2x2Section) {
                case 0: {
                    this.topType = rand.nextInt(LibraryData.TOPS_LIBRARY00.length);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.topType = rand.nextInt(LibraryData.TOPS_LIBRARY.length);
                    break;
                }
                default: {
                    this.topType = rand.nextInt(RoofTopsData.TOPS.length);
                    break;
                }
            }
        } else if (this.isDataCenter) {
            switch (this.building2x2Section) {
                case 0: {
                    this.topType = rand.nextInt(DataCenterData.TOPS_CENTER00.length);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.topType = rand.nextInt(DataCenterData.TOPS_CENTER.length);
                    break;
                }
                default: {
                    this.topType = rand.nextInt(RoofTopsData.TOPS.length);
                    break;
                }
            }
        } else {
            this.topType = rand.nextInt(RoofTopsData.TOPS.length);
        }
        this.floorTypes = new int[this.floors + this.floorsBelowGround + 2];
        this.connectionAtX = new boolean[this.floors + this.floorsBelowGround + 2];
        this.connectionAtZ = new boolean[this.floors + this.floorsBelowGround + 2];
        for (int i = 0; i <= this.floors + this.floorsBelowGround + 1; ++i) {
            this.floorTypes[i] = rand.nextInt(this.getFloorData().length);
            boolean bl3 = BuildingInfo.isCity(chunkX - 1, chunkZ, seed) ? rand.nextFloat() < LostCityConfiguration.BUILDING_DOORWAYCHANCE : (this.connectionAtX[i] = false);
            this.connectionAtZ[i] = BuildingInfo.isCity(chunkX, chunkZ - 1, seed) ? rand.nextFloat() < LostCityConfiguration.BUILDING_DOORWAYCHANCE : false;
        }
        if (this.hasBuilding && this.floorsBelowGround > 0) {
            this.xRailCorridor = false;
            this.zRailCorridor = false;
        } else {
            this.xRailCorridor = rand.nextFloat() < LostCityConfiguration.CORRIDOR_CHANCE;
            boolean bl4 = this.zRailCorridor = rand.nextFloat() < LostCityConfiguration.CORRIDOR_CHANCE;
        }
        if (this.isCity) {
            this.xBridge = false;
            this.zBridge = false;
        } else {
            this.xBridge = rand.nextFloat() < LostCityConfiguration.BRIDGE_CHANCE;
            this.zBridge = rand.nextFloat() < LostCityConfiguration.BRIDGE_CHANCE;
        }
    }

    private Block getRandomDoor(Random rand) {
        BlockDoor doorBlock;
        switch (rand.nextInt(7)) {
            case 0: {
                doorBlock = Blocks.field_180412_aq;
                break;
            }
            case 1: {
                doorBlock = Blocks.field_180410_as;
                break;
            }
            case 2: {
                doorBlock = Blocks.field_180409_at;
                break;
            }
            case 3: {
                doorBlock = Blocks.field_180414_ap;
                break;
            }
            case 4: {
                doorBlock = Blocks.field_180413_ao;
                break;
            }
            case 5: {
                doorBlock = Blocks.field_180411_ar;
                break;
            }
            case 6: {
                doorBlock = Blocks.field_150454_av;
                break;
            }
            default: {
                doorBlock = Blocks.field_180413_ao;
            }
        }
        return doorBlock;
    }

    public boolean isStreetSection() {
        return this.isCity && !this.hasBuilding;
    }

    public boolean isElevatedParkSection() {
        if (!this.isStreetSection()) {
            return false;
        }
        if (!this.getXmin().isStreetSection()) {
            return false;
        }
        if (!this.getXmax().isStreetSection()) {
            return false;
        }
        if (!this.getZmin().isStreetSection()) {
            return false;
        }
        if (!this.getZmax().isStreetSection()) {
            return false;
        }
        int cnt = 0;
        cnt += this.getXmin().getZmin().isStreetSection() ? 1 : 0;
        cnt += this.getXmin().getZmax().isStreetSection() ? 1 : 0;
        cnt += this.getXmax().getZmin().isStreetSection() ? 1 : 0;
        return (cnt += this.getXmax().getZmax().isStreetSection() ? 1 : 0) >= 3;
    }

    public int hasXBridge(GenericChunkGenerator provider) {
        if (!this.xBridge) {
            return -1;
        }
        if (!LostCitiesTerrainGenerator.isWaterBiome(provider, this.chunkX, this.chunkZ)) {
            return -1;
        }
        int bt = this.bridgeType;
        BuildingInfo i = this.getXmin();
        while (!i.isCity && i.xBridge && LostCitiesTerrainGenerator.isWaterBiome(provider, i.chunkX, i.chunkZ)) {
            bt = i.bridgeType;
            i = i.getXmin();
        }
        if (!i.isCity || i.hasBuilding) {
            return -1;
        }
        i = this.getXmax();
        while (!i.isCity && i.xBridge && LostCitiesTerrainGenerator.isWaterBiome(provider, i.chunkX, i.chunkZ)) {
            i = i.getXmax();
        }
        if (!i.isCity || i.hasBuilding) {
            return -1;
        }
        return bt;
    }

    public int hasZBridge(GenericChunkGenerator provider) {
        if (!this.zBridge) {
            return -1;
        }
        if (!LostCitiesTerrainGenerator.isWaterBiome(provider, this.chunkX, this.chunkZ)) {
            return -1;
        }
        if (this.hasXBridge(provider) >= 0) {
            return -1;
        }
        int bt = this.bridgeType;
        BuildingInfo i = this.getZmin();
        while (!i.isCity && i.zBridge && LostCitiesTerrainGenerator.isWaterBiome(provider, i.chunkX, i.chunkZ)) {
            if (i.hasXBridge(provider) >= 0) {
                return -1;
            }
            bt = i.bridgeType;
            i = i.getZmin();
        }
        if (!i.isCity || i.hasBuilding) {
            return -1;
        }
        i = this.getZmax();
        while (!i.isCity && i.zBridge && LostCitiesTerrainGenerator.isWaterBiome(provider, i.chunkX, i.chunkZ)) {
            if (i.hasXBridge(provider) >= 0) {
                return -1;
            }
            i = i.getZmax();
        }
        if (!i.isCity || i.hasBuilding) {
            return -1;
        }
        return bt;
    }

    public boolean hasXCorridor() {
        if (!this.xRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getXmin();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmin();
        }
        if (!i.hasBuilding || i.floorsBelowGround == 0) {
            return false;
        }
        i = this.getXmax();
        while (i.canRailGoThrough() && i.xRailCorridor) {
            i = i.getXmax();
        }
        return i.hasBuilding && i.floorsBelowGround != 0;
    }

    public boolean hasZCorridor() {
        if (!this.zRailCorridor) {
            return false;
        }
        BuildingInfo i = this.getZmin();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmin();
        }
        if (!i.hasBuilding || i.floorsBelowGround == 0) {
            return false;
        }
        i = this.getZmax();
        while (i.canRailGoThrough() && i.zRailCorridor) {
            i = i.getZmax();
        }
        return i.hasBuilding && i.floorsBelowGround != 0;
    }

    public boolean canRailGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.floorsBelowGround == 0;
    }

    public boolean canWaterCorridorGoThrough() {
        if (!this.isCity) {
            return false;
        }
        if (!this.hasBuilding) {
            return true;
        }
        return this.floorsBelowGround <= 1;
    }

    public boolean doesRoadExtendTo() {
        boolean b;
        boolean bl = b = this.isCity && !this.hasBuilding;
        if (b) {
            return !this.isElevatedParkSection();
        }
        return false;
    }

    public static Random getBuildingRandom(int chunkX, int chunkZ, long seed) {
        Random rand = new Random(seed + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        rand.nextFloat();
        return rand;
    }

    public boolean hasConnectionAtX(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 1 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtX.length) {
            return false;
        }
        return this.connectionAtX[level];
    }

    public boolean hasConnectionAtZ(int level) {
        if (!this.isCity) {
            return false;
        }
        if (this.building2x2Section == 2 || this.building2x2Section == 3) {
            return false;
        }
        if (level < 0 || level >= this.connectionAtZ.length) {
            return false;
        }
        return this.connectionAtZ[level];
    }

    static enum StreetType {
        NORMAL,
        FULL,
        PARK;

    }
}

