/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.renders.model;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.renders.model.ItemModelManager;
import vswe.stevescarts.renders.model.TexturedItem;

public class ModelGenerator {
    private FaceBakery faceBakery = new FaceBakery();
    public List<ItemIconInfo> itemIcons = new ArrayList<ItemIconInfo>();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.itemIcons.clear();
        TextureMap textureMap = event.getMap();
        for (TexturedItem item : ItemModelManager.items) {
            for (int i = 0; i < item.getMaxMeta(); ++i) {
                String name = item.getTextureName(i);
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new CustomTexture(name);
                    textureMap.setTextureEntry(name, texture);
                }
                ItemIconInfo info = new ItemIconInfo((Item)item, i, texture, name);
                this.itemIcons.add(info);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void bakeModels(ModelBakeEvent event) {
        if (Minecraft.func_71410_x().func_175599_af() == null || Minecraft.func_71410_x().func_175599_af().func_175037_a() == null) {
            return;
        }
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        block2: for (TexturedItem object : ItemModelManager.items) {
            if (!(object instanceof Item) || !(object instanceof TexturedItem)) continue;
            TexturedItem iTexturedItem = object;
            Item item = (Item)object;
            for (int i = 0; i < iTexturedItem.getMaxMeta(); ++i) {
                TextureAtlasSprite texture = null;
                ItemIconInfo itemIconInfo = null;
                for (ItemIconInfo info : this.itemIcons) {
                    if (info.damage != i || info.getItem() != item || info.isBucket) continue;
                    texture = info.getSprite();
                    itemIconInfo = info;
                    break;
                }
                if (texture == null) continue block2;
                ModelResourceLocation inventory = ModelGenerator.getItemInventoryResourceLocation(item);
                if (iTexturedItem.getMaxMeta() != 1 && this.getModel(new ItemStack(item, 1, i)) != null) {
                    inventory = this.getModel(new ItemStack(item, 1, i));
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{inventory});
                }
                TextureAtlasSprite finalTexture = texture;
                Function textureGetter = location -> finalTexture;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)new ResourceLocation(itemIconInfo.textureName));
                ItemLayerModel itemLayerModel = new ItemLayerModel(builder.build());
                IBakedModel model = itemLayerModel.bake(ItemLayerModel.INSTANCE.getDefaultState(), DefaultVertexFormats.field_176599_b, textureGetter);
                ItemCameraTransforms transforms = null;
                try {
                    transforms = ModelGenerator.loadTransformFromJson(new ResourceLocation("minecraft:models/item/generated"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ImmutableMap map = IPerspectiveAwareModel.MapWrapper.getTransforms((ItemCameraTransforms)transforms);
                IPerspectiveAwareModel.MapWrapper iPerspectiveAwareModel = new IPerspectiveAwareModel.MapWrapper(model, map);
                itemModelMesher.func_178086_a(item, i, inventory);
                event.getModelRegistry().func_82595_a((Object)inventory, (Object)iPerspectiveAwareModel);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getItemInventoryResourceLocation(Item block) {
        return new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)block), "inventory");
    }

    public static ItemCameraTransforms loadTransformFromJson(ResourceLocation location) throws IOException {
        return ModelBlock.func_178307_a((Reader)ModelGenerator.getReaderForResource(location)).func_181682_g();
    }

    public ModelResourceLocation getModel(ItemStack stack) {
        return new ModelResourceLocation("stevescarts:" + stack.func_77973_b().func_77667_c(stack).substring(5), "inventory");
    }

    public static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    class ItemIconInfo {
        Item item;
        int damage;
        TextureAtlasSprite sprite;
        String textureName;
        public boolean isBucket = false;

        public Item getItem() {
            return this.item;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public ItemIconInfo(Item item, int damage, TextureAtlasSprite sprite, String textureName) {
            this.item = item;
            this.damage = damage;
            this.sprite = sprite;
            this.textureName = textureName;
        }
    }

    class CustomTexture
    extends TextureAtlasSprite {
        public CustomTexture(String spriteName) {
            super(spriteName);
        }
    }
}

