/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotBridge;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleBridge
extends ModuleWorker
implements ISuppliesModule {
    private DataParameter<Boolean> BRIDGE;

    public ModuleBridge(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBridge(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 98;
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        BlockPos next = this.getNextblock();
        next = this.getCart().getYTarget() < next.func_177956_o() ? next.func_177979_c(2) : next.func_177979_c(1);
        if (!BlockRailBase.func_176562_d((World)world, (BlockPos)next) && !BlockRailBase.func_176562_d((World)world, (BlockPos)next.func_177977_b())) {
            if (this.doPreWork()) {
                if (this.tryBuildBridge(world, next, false)) {
                    this.startWorking(22);
                    this.setBridge(true);
                    return true;
                }
            } else if (this.tryBuildBridge(world, next, true)) {
                this.stopWorking();
            }
        }
        this.setBridge(false);
        return false;
    }

    private boolean tryBuildBridge(World world, BlockPos pos, boolean flag) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if ((this.countsAsAir(pos) || b instanceof BlockLiquid) && this.isValidForTrack(world, pos.func_177984_a(), false)) {
            for (int m = 0; m < this.getInventorySize(); ++m) {
                if (this.getStack(m) == null || !SlotBridge.isBridgeMaterial(this.getStack(m))) continue;
                if (flag) {
                    world.func_180501_a(pos, Block.func_149634_a((Item)this.getStack(m).func_77973_b()).func_176203_a(this.getStack(m).func_77952_i()), 3);
                    if (!this.getCart().hasCreativeSupplies()) {
                        ItemStack stack = this.getStack(m);
                        --stack.field_77994_a;
                        if (this.getStack((int)m).field_77994_a == 0) {
                            this.setStack(m, null);
                        }
                        this.getCart().func_70296_d();
                    }
                }
                return true;
            }
            if (this.isValidForTrack(world, pos, true) || this.isValidForTrack(world, pos.func_177984_a(), true) || !this.isValidForTrack(world, pos.func_177981_b(2), true)) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public void initDw() {
        this.BRIDGE = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.BRIDGE, false);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setBridge(boolean val) {
        this.updateDw(this.BRIDGE, val);
    }

    public boolean needBridge() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getNeedBridge();
        }
        return this.getDw(this.BRIDGE);
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || !SlotBridge.isBridgeMaterial(item)) continue;
            return true;
        }
        return false;
    }
}

