/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.MathHelper;
import vswe.stevescarts.containers.slots.SlotArrow;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.EnchantmentInfo;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleEnchants;
import vswe.stevescarts.modules.addons.projectiles.ModuleProjectile;

public class ModuleShooter
extends ModuleBase
implements ISuppliesModule {
    private ArrayList<ModuleProjectile> projectiles;
    private ModuleEnchants enchanter;
    private int pipeSelectionX;
    private int pipeSelectionY;
    private int intervalSelectionX;
    private int intervalSelectionY;
    private int[] intervalSelection;
    private int[] intervalDragArea;
    private int currentCooldownState;
    private int dragState = -1;
    private final ArrayList<Integer> pipes;
    private final float[] pipeRotations;
    private final int[] AInterval = new int[]{1, 3, 5, 7, 10, 13, 17, 21, 27, 35, 44, 55, 70, 95, 130, 175, 220, 275, 340, 420, 520, 650};
    private int arrowTick;
    private int arrowInterval = 5;
    private DataParameter<Byte> ACTIVE_PIPE;

    public ModuleShooter(EntityMinecartModular cart) {
        super(cart);
        this.pipes = new ArrayList<Integer>();
        this.generatePipes(this.pipes);
        this.pipeRotations = new float[this.pipes.size()];
        this.generateInterfaceRegions();
    }

    @Override
    public void init() {
        super.init();
        this.projectiles = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleProjectile) {
                this.projectiles.add((ModuleProjectile)module);
                continue;
            }
            if (!(module instanceof ModuleEnchants)) continue;
            this.enchanter = (ModuleEnchants)module;
            this.enchanter.addType(EnchantmentInfo.ENCHANTMENT_TYPE.SHOOTER);
        }
    }

    @Override
    protected int getInventoryHeight() {
        return 2;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotArrow(this.getCart(), this, slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.SHOOTER.translate(new String[0]), 8, 6, 0x404040);
        int delay = this.AInterval[this.arrowInterval];
        double freq = 20.0 / (double)(delay + 1);
        String s = String.valueOf((double)((int)(freq * 1000.0)) / 1000.0);
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.FREQUENCY.translate(new String[0]) + ":", this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 15, 0x404040);
        this.drawString(gui, s, this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 23, 0x404040);
        s = String.valueOf((double)delay / 20.0 + Localization.MODULES.ATTACHMENTS.SECONDS.translate(new String[0]));
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.DELAY.translate(new String[0]) + ":", this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 35, 0x404040);
        this.drawString(gui, s, this.intervalDragArea[0] + this.intervalDragArea[2] + 5, 43, 0x404040);
    }

    @Override
    public int guiWidth() {
        return super.guiWidth() + this.guiExtraWidth();
    }

    protected int guiExtraWidth() {
        return 112;
    }

    @Override
    public int guiHeight() {
        return Math.max(super.guiHeight(), this.guiRequiredHeight());
    }

    protected int guiRequiredHeight() {
        return 67;
    }

    protected void generateInterfaceRegions() {
        this.pipeSelectionX = this.guiWidth() - 110;
        this.pipeSelectionY = (this.guiHeight() - 12 - 26) / 2 + 12;
        this.intervalSelectionX = this.pipeSelectionX + 26 + 8;
        this.intervalSelectionY = 10;
        this.intervalSelection = new int[]{this.intervalSelectionX, this.intervalSelectionY, 14, 53};
        this.intervalDragArea = new int[]{this.intervalSelectionX - 4, this.intervalSelectionY, 40, 53};
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/shooter.png");
        this.drawImage(gui, this.pipeSelectionX + 9, this.pipeSelectionY + 9 - 1, 0, 104, 8, 9);
        for (int i = 0; i < this.pipes.size(); ++i) {
            int pipe = this.pipes.get(i);
            int pipeX = pipe % 3;
            int pipeY = pipe / 3;
            boolean active = this.isPipeActive(i);
            boolean selected = this.inRect(x, y, this.getRectForPipe(pipe)) || this.currentCooldownState == 0 && active;
            int srcX = pipeX * 9;
            if (!active) {
                srcX += 26;
            }
            int srcY = pipeY * 9;
            if (selected) {
                srcY += 26;
            }
            this.drawImage(gui, this.getRectForPipe(pipe), srcX, srcY);
        }
        this.drawImage(gui, this.intervalSelection, 42, 52);
        int size = (int)((float)(this.arrowInterval / this.AInterval.length) * 4.0f);
        int targetX = this.intervalSelectionX + 7;
        int targetY = this.intervalSelectionY + this.arrowInterval * 2;
        int srcX2 = 0;
        int srcY2 = 52 + size * 13;
        this.drawImage(gui, targetX, targetY, srcX2, srcY2, 25, 13);
        this.drawImage(gui, targetX += 7, targetY + 1, srcX2 += 25, srcY2 + 1, 1, 11);
        this.drawImage(gui, targetX + 1, targetY + 2, srcX2 + 1, srcY2 + 2, 1, 9);
        this.drawImage(gui, targetX + 1, targetY + 1, srcX2 + 1, srcY2 + 1, Math.min(this.currentCooldownState, 15), 2);
        this.drawImage(gui, targetX + 15, targetY + 1, srcX2 + 15, srcY2 + 1, 2, Math.max(Math.min(this.currentCooldownState, 25) - 15, 0));
        int len = Math.max(Math.min(this.currentCooldownState, 41) - 25, 0);
        this.drawImage(gui, targetX + 1 + (16 - len), targetY + 10, srcX2 + 1 + (16 - len), srcY2 + 10, len, 2);
    }

    private int getCurrentCooldownState() {
        double perc = this.arrowTick / this.AInterval[this.arrowInterval];
        this.currentCooldownState = (int)(41.0 * perc);
        return this.currentCooldownState;
    }

    private int[] getRectForPipe(int pipe) {
        return new int[]{this.pipeSelectionX + pipe % 3 * 9, this.pipeSelectionY + pipe / 3 * 9, 8, 8};
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0) {
            if (this.inRect(x, y, this.intervalDragArea)) {
                this.dragState = y - (this.intervalSelectionY + this.arrowInterval * 2);
            } else {
                for (int i = 0; i < this.pipes.size(); ++i) {
                    if (!this.inRect(x, y, this.getRectForPipe(this.pipes.get(i)))) continue;
                    this.sendPacket(0, (byte)i);
                    break;
                }
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        int interval;
        if (button != -1) {
            this.dragState = -1;
        } else if (this.dragState != -1 && (interval = (y + this.getCart().getRealScrollY() - this.intervalSelectionY - this.dragState) / 2) != this.arrowInterval && interval >= 0 && interval < this.AInterval.length) {
            this.sendPacket(1, (byte)interval);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte info = this.getActivePipes();
            info = (byte)(info ^ (byte)(1 << data[0]));
            this.setActivePipes(info);
        } else if (id == 1) {
            int info = data[0];
            if (info < 0) {
                info = 0;
            } else if (info >= this.AInterval.length) {
                info = (byte)(this.AInterval.length - 1);
            }
            this.arrowInterval = info;
            this.arrowTick = this.AInterval[info];
        }
    }

    @Override
    public int numberOfPackets() {
        return 2;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.currentCooldownState);
        this.updateGuiData(info, 1, (short)this.arrowInterval);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.currentCooldownState = data;
        } else if (id == 1) {
            this.arrowInterval = data;
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K) {
            if (this.arrowTick > 0) {
                --this.arrowTick;
            } else {
                this.Shoot();
            }
        } else {
            this.rotatePipes(false);
        }
    }

    protected void generatePipes(ArrayList<Integer> list) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            list.add(i);
        }
    }

    protected boolean hasProjectileItem() {
        return this.getProjectileItem(false) != null;
    }

    protected ItemStack getProjectileItem(boolean flag) {
        if (flag && this.enchanter != null && this.enchanter.useInfinity()) {
            flag = false;
        }
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i) == null || !this.isValidProjectileItem(this.getStack(i))) continue;
            ItemStack projectile = this.getStack(i).func_77946_l();
            projectile.field_77994_a = 1;
            if (flag && !this.getCart().hasCreativeSupplies()) {
                ItemStack stack = this.getStack(i);
                --stack.field_77994_a;
                if (this.getStack((int)i).field_77994_a == 0) {
                    this.setStack(i, null);
                }
            }
            return projectile;
        }
        return null;
    }

    protected void Shoot() {
        this.setTimeToNext(this.AInterval[this.arrowInterval]);
        if (this.getCart().pushX != 0.0 && this.getCart().pushZ != 0.0 || this.getCart().pushX == 0.0 && this.getCart().pushZ == 0.0 || !this.getCart().hasFuel()) {
            return;
        }
        boolean hasShot = false;
        for (int i = 0; i < this.pipes.size(); ++i) {
            if (!this.isPipeActive(i)) continue;
            int pipe = this.pipes.get(i);
            if (!this.hasProjectileItem()) break;
            int x = pipe % 3 - 1;
            int y = pipe / 3 - 1;
            if (this.getCart().pushZ > 0.0) {
                y *= -1;
                x *= -1;
            } else if (this.getCart().pushZ >= 0.0) {
                if (this.getCart().pushX < 0.0) {
                    int temp = -x;
                    x = y;
                    y = temp;
                } else if (this.getCart().pushX > 0.0) {
                    int temp = x;
                    x = -y;
                    y = temp;
                }
            }
            Entity projectile = this.getProjectile(null, this.getProjectileItem(true));
            projectile.func_70107_b(this.getCart().field_70165_t + (double)x * 1.5, this.getCart().field_70163_u + 0.75, this.getCart().field_70161_v + (double)y * 1.5);
            this.setHeading(projectile, x, 0.1f, y, 1.6f, 12.0f);
            this.setProjectileDamage(projectile);
            this.setProjectileOnFire(projectile);
            this.setProjectileKnockback(projectile);
            this.getCart().field_70170_p.func_72838_d(projectile);
            hasShot = true;
            this.damageEnchant();
        }
        if (hasShot) {
            this.getCart().field_70170_p.func_175718_b(1002, this.getCart().func_180425_c(), 0);
        }
    }

    protected void damageEnchant() {
        if (this.enchanter != null) {
            this.enchanter.damageEnchant(EnchantmentInfo.ENCHANTMENT_TYPE.SHOOTER, 1);
        }
    }

    protected void setProjectileOnFire(Entity projectile) {
        if (this.enchanter != null && this.enchanter.useFlame()) {
            projectile.func_70015_d(100);
        }
    }

    protected void setProjectileDamage(Entity projectile) {
        int power;
        if (this.enchanter != null && projectile instanceof EntityArrow && (power = this.enchanter.getPowerLevel()) > 0) {
            EntityArrow arrow = (EntityArrow)projectile;
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
    }

    protected void setProjectileKnockback(Entity projectile) {
        int punch;
        if (this.enchanter != null && projectile instanceof EntityArrow && (punch = this.enchanter.getPunchLevel()) > 0) {
            EntityArrow arrow = (EntityArrow)projectile;
            arrow.func_70240_a(punch);
        }
    }

    protected void setHeading(Entity projectile, double motionX, double motionY, double motionZ, float motionMult, float motionNoise) {
        if (projectile instanceof IProjectile) {
            ((IProjectile)projectile).func_70186_c(motionX, motionY, motionZ, motionMult, motionNoise);
        } else if (projectile instanceof EntityFireball) {
            EntityFireball fireball = (EntityFireball)projectile;
            double totalMotion = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            fireball.field_70232_b = motionX / totalMotion * 0.1;
            fireball.field_70233_c = motionY / totalMotion * 0.1;
            fireball.field_70230_d = motionZ / totalMotion * 0.1;
        }
    }

    protected Entity getProjectile(Entity target, final ItemStack item) {
        for (ModuleProjectile module : this.projectiles) {
            if (!module.isValidProjectile(item)) continue;
            return module.createProjectile(target, item);
        }
        return new EntityArrow(this.getCart().field_70170_p){

            protected ItemStack func_184550_j() {
                return item;
            }
        };
    }

    public boolean isValidProjectileItem(ItemStack item) {
        for (ModuleProjectile module : this.projectiles) {
            if (!module.isValidProjectile(item)) continue;
            return true;
        }
        return item.func_77973_b() == Items.field_151032_g;
    }

    protected void setTimeToNext(int val) {
        this.arrowTick = val;
    }

    private void rotatePipes(boolean isNew) {
        float minRotation = 0.0f;
        float maxRotation = 0.7853982f;
        float speed = 0.15f;
        for (int i = 0; i < this.pipes.size(); ++i) {
            int n2;
            boolean isActive = this.isPipeActive(i);
            if (isNew && isActive) {
                this.pipeRotations[i] = 0.0f;
                continue;
            }
            if (isNew && !isActive) {
                this.pipeRotations[i] = 0.7853982f;
                continue;
            }
            if (isActive && this.pipeRotations[i] > 0.0f) {
                int n;
                float[] pipeRotations = this.pipeRotations;
                int n3 = n = i;
                pipeRotations[n3] = pipeRotations[n3] - 0.15f;
                if (!(this.pipeRotations[i] < 0.0f)) continue;
                this.pipeRotations[i] = 0.0f;
                continue;
            }
            if (isActive || !(this.pipeRotations[i] < 0.7853982f)) continue;
            float[] pipeRotations2 = this.pipeRotations;
            int n = n2 = i;
            pipeRotations2[n] = pipeRotations2[n] + 0.15f;
            if (!(this.pipeRotations[i] > 0.7853982f)) continue;
            this.pipeRotations[i] = 0.7853982f;
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.ACTIVE_PIPE = this.createDw(DataSerializers.field_187191_a);
        this.registerDw(this.ACTIVE_PIPE, (byte)0);
    }

    public void setActivePipes(byte val) {
        this.updateDw(this.ACTIVE_PIPE, val);
    }

    public byte getActivePipes() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getActivePipes();
        }
        return this.getDw(this.ACTIVE_PIPE);
    }

    protected boolean isPipeActive(int id) {
        return (this.getActivePipes() & 1 << id) != 0;
    }

    public int getPipeCount() {
        return this.pipes.size();
    }

    public float getPipeRotation(int id) {
        return this.pipeRotations[id];
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("Pipes", id), this.getActivePipes());
        tagCompound.func_74774_a(this.generateNBTName("Interval", id), (byte)this.arrowInterval);
        this.saveTick(tagCompound, id);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setActivePipes(tagCompound.func_74771_c(this.generateNBTName("Pipes", id)));
        this.arrowInterval = tagCompound.func_74771_c(this.generateNBTName("Interval", id));
        this.loadTick(tagCompound, id);
    }

    protected void saveTick(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("Tick", id), (byte)this.arrowTick);
    }

    protected void loadTick(NBTTagCompound tagCompound, int id) {
        this.arrowTick = tagCompound.func_74771_c(this.generateNBTName("Tick", id));
    }

    @Override
    public boolean haveSupplies() {
        return this.hasProjectileItem();
    }
}

