/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleFirework
extends ModuleBase {
    private int fireCooldown;

    public ModuleFirework(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.fireCooldown == 0 && this.getCart().hasFuel()) {
            this.fire();
            this.fireCooldown = 20;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFirework(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    @Override
    protected int getInventoryWidth() {
        return 8;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    public void fire() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack firework = this.getFirework();
        if (firework != null) {
            this.launchFirework(firework);
        }
    }

    private ItemStack getFirework() {
        boolean hasGunpowder = false;
        boolean hasPaper = false;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null) continue;
            if (item.func_77973_b() == Items.field_151152_bP) {
                ItemStack firework = item.func_77946_l();
                firework.field_77994_a = 1;
                this.removeItemStack(item, 1, i);
                return firework;
            }
            if (item.func_77973_b() == Items.field_151121_aF) {
                hasPaper = true;
                continue;
            }
            if (item.func_77973_b() != Items.field_151016_H) continue;
            hasGunpowder = true;
        }
        if (hasPaper && hasGunpowder) {
            ItemStack charge;
            int chargeCount;
            ItemStack firework2 = new ItemStack(Items.field_151152_bP);
            int maxGunpowder = this.getCart().field_70146_Z.nextInt(3) + 1;
            int countGunpowder = 0;
            boolean removedPaper = false;
            for (int j = 0; j < this.getInventorySize(); ++j) {
                ItemStack item2 = this.getStack(j);
                if (item2 == null) continue;
                if (item2.func_77973_b() == Items.field_151121_aF && !removedPaper) {
                    this.removeItemStack(item2, 1, j);
                    removedPaper = true;
                    continue;
                }
                if (item2.func_77973_b() != Items.field_151016_H || countGunpowder >= maxGunpowder) continue;
                while (item2.field_77994_a > 0 && countGunpowder < maxGunpowder) {
                    ++countGunpowder;
                    this.removeItemStack(item2, 1, j);
                }
            }
            for (chargeCount = 1; chargeCount < 7 && this.getCart().field_70146_Z.nextInt(3 + chargeCount / 3) == 0; ++chargeCount) {
            }
            NBTTagCompound itemstackNBT = new NBTTagCompound();
            NBTTagCompound fireworksNBT = new NBTTagCompound();
            NBTTagList explosionsNBT = new NBTTagList();
            for (int k = 0; k < chargeCount && (charge = this.getCharge()) != null; ++k) {
                if (!charge.func_77942_o() || !charge.func_77978_p().func_74764_b("Explosion")) continue;
                explosionsNBT.func_74742_a((NBTBase)charge.func_77978_p().func_74775_l("Explosion"));
            }
            fireworksNBT.func_74782_a("Explosions", (NBTBase)explosionsNBT);
            fireworksNBT.func_74774_a("Flight", (byte)countGunpowder);
            itemstackNBT.func_74782_a("Fireworks", (NBTBase)fireworksNBT);
            firework2.func_77982_d(itemstackNBT);
            return firework2;
        }
        return null;
    }

    private ItemStack getCharge() {
        int[] fade;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || item.func_77973_b() != Items.field_151154_bQ) continue;
            ItemStack charge = item.func_77946_l();
            charge.field_77994_a = 1;
            this.removeItemStack(item, 1, i);
            return charge;
        }
        ItemStack charge2 = new ItemStack(Items.field_151154_bQ);
        NBTTagCompound itemNBT = new NBTTagCompound();
        NBTTagCompound explosionNBT = new NBTTagCompound();
        byte type = 0;
        boolean removedGunpowder = false;
        boolean canHasTrail = this.getCart().field_70146_Z.nextInt(16) == 0;
        boolean canHasFlicker = this.getCart().field_70146_Z.nextInt(8) == 0;
        boolean canHasModifier = this.getCart().field_70146_Z.nextInt(4) == 0;
        byte modifierType = (byte)(this.getCart().field_70146_Z.nextInt(4) + 1);
        boolean removedModifier = false;
        boolean removedDiamond = false;
        boolean removedGlow = false;
        for (int j = 0; j < this.getInventorySize(); ++j) {
            ItemStack item2 = this.getStack(j);
            if (item2 == null) continue;
            if (item2.func_77973_b() == Items.field_151016_H && !removedGunpowder) {
                this.removeItemStack(item2, 1, j);
                removedGunpowder = true;
                continue;
            }
            if (item2.func_77973_b() == Items.field_151114_aO && canHasFlicker && !removedGlow) {
                this.removeItemStack(item2, 1, j);
                removedGlow = true;
                explosionNBT.func_74757_a("Flicker", true);
                continue;
            }
            if (item2.func_77973_b() == Items.field_151045_i && canHasTrail && !removedDiamond) {
                this.removeItemStack(item2, 1, j);
                removedDiamond = true;
                explosionNBT.func_74757_a("Trail", true);
                continue;
            }
            if (!canHasModifier || removedModifier || !(item2.func_77973_b() == Items.field_151154_bQ && modifierType == 1 || item2.func_77973_b() == Items.field_151074_bl && modifierType == 2 || item2.func_77973_b() == Items.field_151144_bL && modifierType == 3) && (item2.func_77973_b() != Items.field_151008_G || modifierType != 4)) continue;
            this.removeItemStack(item2, 1, j);
            removedModifier = true;
            type = modifierType;
        }
        int[] colors = this.generateColors(type != 0 ? 7 : 8);
        if (colors == null) {
            return null;
        }
        explosionNBT.func_74783_a("Colors", colors);
        if (this.getCart().field_70146_Z.nextInt(4) == 0 && (fade = this.generateColors(8)) != null) {
            explosionNBT.func_74783_a("FadeColors", fade);
        }
        explosionNBT.func_74774_a("Type", type);
        itemNBT.func_74782_a("Explosion", (NBTBase)explosionNBT);
        charge2.func_77982_d(itemNBT);
        return charge2;
    }

    private int[] generateColors(int maxColorCount) {
        int k;
        int colorCount;
        int[] maxColors = new int[16];
        int[] currentColors = new int[16];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            int itemDamage;
            ItemStack item = this.getStack(i);
            if (item == null || item.func_77973_b() != Items.field_151100_aR) continue;
            int[] array = maxColors;
            int n = itemDamage = item.func_77952_i();
            array[n] = array[n] + item.field_77994_a;
        }
        for (colorCount = this.getCart().field_70146_Z.nextInt(2) + 1; colorCount <= maxColorCount - 2 && this.getCart().field_70146_Z.nextInt(2) == 0; colorCount += 2) {
        }
        ArrayList<Integer> colorPointers = new ArrayList<Integer>();
        for (int j = 0; j < 16; ++j) {
            if (maxColors[j] <= 0) continue;
            colorPointers.add(j);
        }
        if (colorPointers.size() == 0) {
            return null;
        }
        ArrayList<Integer> usedColors = new ArrayList<Integer>();
        while (colorCount > 0 && colorPointers.size() > 0) {
            int n2;
            int n;
            int pointerId = this.getCart().field_70146_Z.nextInt(colorPointers.size());
            int colorId = (Integer)colorPointers.get(pointerId);
            int[] array2 = currentColors;
            int n3 = n = colorId;
            array2[n3] = array2[n3] + 1;
            int[] array3 = maxColors;
            int n4 = n2 = colorId;
            array3[n4] = array3[n4] - 1;
            if (array3[n4] <= 0) {
                colorPointers.remove(pointerId);
            }
            usedColors.add(colorId);
            --colorCount;
        }
        int[] colors = new int[usedColors.size()];
        for (k = 0; k < colors.length; ++k) {
            colors[k] = ItemDye.field_150922_c[(Integer)usedColors.get(k)];
        }
        for (k = 0; k < this.getInventorySize(); ++k) {
            int itemDamage2;
            ItemStack item2 = this.getStack(k);
            if (item2 == null || item2.func_77973_b() != Items.field_151100_aR || currentColors[item2.func_77952_i()] <= 0) continue;
            int count = Math.min(currentColors[item2.func_77952_i()], item2.field_77994_a);
            int[] array4 = currentColors;
            int n = itemDamage2 = item2.func_77952_i();
            array4[n] = array4[n] - count;
        }
        return colors;
    }

    private void removeItemStack(ItemStack item, int count, int id) {
        if (!this.getCart().hasCreativeSupplies()) {
            item.field_77994_a -= count;
            if (item.field_77994_a <= 0) {
                this.setStack(id, null);
            }
        }
    }

    private void launchFirework(ItemStack firework) {
        EntityFireworkRocket rocket = new EntityFireworkRocket(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u + 1.0, this.getCart().field_70161_v, firework);
        this.getCart().field_70170_p.func_72838_d((Entity)rocket);
    }
}

