/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.addons.ModuleAddon;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleOreTracker
extends ModuleAddon {
    public ModuleOreTracker(EntityMinecartModular cart) {
        super(cart);
    }

    public BlockPos findBlockToMine(ModuleDrill drill, BlockPos start) {
        return this.findBlockToMine(drill, new ArrayList<BlockPos>(), start, true);
    }

    private BlockPos findBlockToMine(ModuleDrill drill, ArrayList<BlockPos> checked, BlockPos current, boolean first) {
        if (current == null || checked.contains(current) || !first && !this.isOre(current)) {
            return null;
        }
        checked.add(current);
        if (checked.size() < 200) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos ret;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 1 || (ret = this.findBlockToMine(drill, checked, current.func_177982_a(x, y, z), false)) == null) continue;
                        return ret;
                    }
                }
            }
        }
        if (first && !this.isOre(current)) {
            return null;
        }
        if (drill.isValidBlock(this.getCart().field_70170_p, current, 0, 1, true) == null) {
            return null;
        }
        return current;
    }

    private boolean isOre(BlockPos pos) {
        Block b = this.getCart().field_70170_p.func_180495_p(pos).func_177230_c();
        if (b == null || b == Blocks.field_150350_a) {
            return false;
        }
        if (b instanceof BlockOre) {
            return true;
        }
        ItemStack stack = new ItemStack(b);
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIds.length == 0) {
            return false;
        }
        for (int oreId : oreIds) {
            String oreName = OreDictionary.getOreName((int)oreId);
            if (oreName == null || !oreName.startsWith("ore")) continue;
            return true;
        }
        return false;
    }
}

