/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.addons;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleAddon;
import vswe.stevescarts.modules.workers.ModuleLiquidDrainer;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ModuleLiquidSensors
extends ModuleAddon {
    private float sensorRotation;
    private int activetime = -1;
    private int mult = 1;
    private DataParameter<Byte> SENSOR_INFO;

    public ModuleLiquidSensors(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (this.isDrillSpinning()) {
            this.sensorRotation += 0.05f * (float)this.mult;
            if (this.mult == 1 && (double)this.sensorRotation > 0.7853981633974483 || this.mult == -1 && (double)this.sensorRotation < -0.7853981633974483) {
                this.mult *= -1;
            }
        } else {
            if (this.sensorRotation != 0.0f) {
                if (this.sensorRotation > 0.0f) {
                    this.sensorRotation -= 0.05f;
                    if (this.sensorRotation < 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                } else {
                    this.sensorRotation += 0.05f;
                    if (this.sensorRotation > 0.0f) {
                        this.sensorRotation = 0.0f;
                    }
                }
            }
            if (this.activetime >= 0) {
                ++this.activetime;
                if (this.activetime >= 10) {
                    this.setLight(1);
                    this.activetime = -1;
                }
            }
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.SENSOR_INFO = this.createDw(DataSerializers.field_187191_a);
        this.registerDw(this.SENSOR_INFO, (byte)1);
    }

    private void activateLight(int light) {
        if (this.getLight() == 3 && light == 2) {
            return;
        }
        this.setLight(light);
        this.activetime = 0;
    }

    public void getInfoFromDrill(byte data) {
        byte light = (byte)(data & 3);
        if (light != 1) {
            this.activateLight(light);
        }
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | (byte)this.getLight());
        this.setSensorInfo(data);
    }

    private void setLight(int val) {
        if (this.isPlaceholder()) {
            return;
        }
        byte data = this.getDw(this.SENSOR_INFO);
        data = (byte)(data & 0xFFFFFFFC);
        data = (byte)(data | (byte)val);
        this.setSensorInfo(data);
    }

    private void setSensorInfo(byte val) {
        if (this.isPlaceholder()) {
            return;
        }
        this.registerDw(this.SENSOR_INFO, val);
    }

    public int getLight() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getLiquidLight();
        }
        return this.getDw(this.SENSOR_INFO) & 3;
    }

    protected boolean isDrillSpinning() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return (this.getDw(this.SENSOR_INFO) & 4) != 0;
    }

    public float getSensorRotation() {
        return this.sensorRotation;
    }

    public boolean isDangerous(ModuleDrill drill, BlockPos pos, boolean isUp) {
        boolean isLiquid;
        Block block = this.getCart().field_70170_p.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150353_l) {
            this.handleLiquid(drill, pos);
            return true;
        }
        if (block == Blocks.field_150355_j) {
            this.handleLiquid(drill, pos);
            return true;
        }
        if (block != null && block instanceof IFluidBlock) {
            this.handleLiquid(drill, pos);
            return true;
        }
        boolean isWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i || block == Blocks.field_150432_aD;
        boolean isLava = block == Blocks.field_150353_l || block == Blocks.field_150356_k;
        boolean isOther = block != null && block instanceof IFluidBlock;
        boolean bl = isLiquid = isWater || isLava || isOther;
        if (!isLiquid) {
            boolean isFalling;
            if (isUp && (isFalling = block instanceof BlockFalling)) {
                return this.isDangerous(drill, pos.func_177982_a(0, 1, 0), true) || this.isDangerous(drill, pos.func_177982_a(1, 0, 0), false) || this.isDangerous(drill, pos.func_177982_a(-1, 0, 0), false) || this.isDangerous(drill, pos.func_177982_a(0, 0, 1), false) || this.isDangerous(drill, pos.func_177982_a(0, 0, -1), false);
            }
            return false;
        }
        if (isUp) {
            this.handleLiquid(drill, pos);
            return true;
        }
        IBlockState state = this.getCart().field_70170_p.func_180495_p(pos);
        int m = state.func_177230_c().func_176201_c(state);
        if ((m & 8) == 8) {
            if (block.func_176212_b((IBlockAccess)this.getCart().field_70170_p, pos.func_177977_b(), EnumFacing.UP)) {
                this.handleLiquid(drill, pos);
                return true;
            }
            return false;
        }
        if (isWater && (m & 7) == 7) {
            return false;
        }
        if (isLava && (m & 7) == 7 && !this.getCart().field_70170_p.field_73011_w.func_76561_g()) {
            return false;
        }
        if (isLava && (m & 7) == 6) {
            return false;
        }
        this.handleLiquid(drill, pos);
        return true;
    }

    private void handleLiquid(ModuleDrill drill, BlockPos pos) {
        ModuleLiquidDrainer liquiddrainer = null;
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleLiquidDrainer)) continue;
            liquiddrainer = (ModuleLiquidDrainer)module;
            break;
        }
        if (liquiddrainer != null) {
            liquiddrainer.handleLiquid(drill, pos);
        }
    }
}

