/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.helpers.ButtonComparator;
import vswe.stevescarts.helpers.NBTHelper;
import vswe.stevescarts.helpers.SimulationInfo;
import vswe.stevescarts.models.ModelCartbase;
import vswe.stevescarts.modules.data.ModuleData;

public abstract class ModuleBase {
    private EntityMinecartModular cart;
    private ItemStack[] cargo;
    private int offSetX;
    private int offSetY;
    private int guiDataOffset;
    private int packetOffset;
    private ArrayList<ButtonBase> buttons;
    protected int slotGlobalStart;
    private byte moduleId;
    private ArrayList<ModelCartbase> models;
    protected ArrayList<SlotBase> slotList;
    private int moduleButtonId = 0;

    public ModuleBase(EntityMinecartModular cart) {
        this.cart = cart;
        this.cargo = new ItemStack[this.getInventorySize()];
    }

    public void init() {
        if (this.useButtons()) {
            this.buttons = new ArrayList();
            this.loadButtons();
            this.buttonVisibilityChanged();
        }
    }

    public void preInit() {
    }

    public EntityMinecartModular getCart() {
        return this.cart;
    }

    public boolean isPlaceholder() {
        return this.getCart().isPlaceholder;
    }

    protected SimulationInfo getSimInfo() {
        return this.getCart().placeholderAsssembler.getSimulationInfo();
    }

    public void setModuleId(byte val) {
        this.moduleId = val;
    }

    public byte getModuleId() {
        return this.moduleId;
    }

    public void onInventoryChanged() {
    }

    public int getX() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetX;
    }

    public int getY() {
        if (this.doStealInterface()) {
            return 0;
        }
        return this.offSetY;
    }

    public void setX(int val) {
        this.offSetX = val;
    }

    public void setY(int val) {
        this.offSetY = val;
    }

    public int getInventorySize() {
        if (!this.hasSlots()) {
            return 0;
        }
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    public int guiHeight() {
        return 27 + this.getInventoryHeight() * 18;
    }

    protected int getInventoryWidth() {
        return 3;
    }

    protected int getInventoryHeight() {
        return 1;
    }

    public void keyPress(GuiMinecart gui, char character, int extraInformation) {
    }

    public ArrayList<SlotBase> getSlots() {
        return this.slotList;
    }

    public int generateSlots(int slotCount) {
        this.slotGlobalStart = slotCount;
        this.slotList = new ArrayList();
        for (int j = 0; j < this.getInventoryHeight(); ++j) {
            for (int i = 0; i < this.getInventoryWidth(); ++i) {
                this.slotList.add(this.getSlot(slotCount++, i, j));
            }
        }
        return slotCount;
    }

    protected SlotBase getSlot(int slotId, int x, int y) {
        return null;
    }

    public boolean hasSlots() {
        return this.hasGui();
    }

    public void update() {
    }

    public boolean hasFuel(int consumption) {
        return false;
    }

    public float getMaxSpeed() {
        return 1.1f;
    }

    public int getYTarget() {
        return -1;
    }

    public void moveMinecartOnRail(BlockPos pos) {
    }

    public ItemStack getStack(int slot) {
        return this.cargo[slot];
    }

    public void setStack(int slot, ItemStack item) {
        this.cargo[slot] = item;
    }

    public void addStack(int slotStart, int slotEnd, ItemStack item) {
        this.getCart().addItemToChest(item, this.slotGlobalStart + slotStart, this.slotGlobalStart + slotEnd);
    }

    public void addStack(int slot, ItemStack item) {
        this.addStack(slot, slot, item);
    }

    public boolean dropOnDeath() {
        return true;
    }

    public void onDeath() {
    }

    public boolean hasGui() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeground(GuiMinecart gui) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawString(GuiMinecart gui, String str, int[] rect, int c) {
        if (rect.length < 4) {
            return;
        }
        this.drawString(gui, str, rect[0] + (rect[2] - gui.getFontRenderer().func_78256_a(str)) / 2, rect[1] + (rect[3] - gui.getFontRenderer().field_78288_b + 3) / 2, c);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawString(GuiMinecart gui, String str, int x, int y, int c) {
        this.drawString(gui, str, x, y, -1, false, c);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawString(GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
        int j = gui.getGuiLeft();
        int k = gui.getGuiTop();
        int[] rect = new int[]{x, y, w, 8};
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] == 8) {
            if (center) {
                gui.getFontRenderer().func_78276_b(str, rect[0] + (rect[2] - gui.getFontRenderer().func_78256_a(str)) / 2 + this.getX(), rect[1] + this.getY(), c);
            } else {
                gui.getFontRenderer().func_78276_b(str, rect[0] + this.getX(), rect[1] + this.getY(), c);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawStringWithShadow(GuiMinecart gui, String str, int x, int y, int c) {
        int j = gui.getGuiLeft();
        int k = gui.getGuiTop();
        int[] rect = new int[]{x, y, 0, 8};
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        if (rect[3] == 8) {
            gui.getFontRenderer().func_175063_a(str, (float)(rect[0] + this.getX()), (float)(rect[1] + this.getY()), c);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSplitString(GuiMinecart gui, String str, int x, int y, int w, int c) {
        this.drawSplitString(gui, str, x, y, w, false, c);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawSplitString(GuiMinecart gui, String str, int x, int y, int w, boolean center, int c) {
        List newlines = gui.getFontRenderer().func_78271_c(str, w);
        for (int i = 0; i < newlines.size(); ++i) {
            String line = newlines.get(i).toString();
            this.drawString(gui, line, x, y + i * 8, w, center, c);
        }
    }

    public void drawItemInInterface(GuiMinecart gui, ItemStack item, int x, int y) {
        int[] rect = new int[]{x, y, 16, 16};
        this.handleScroll(rect);
        if (rect[3] == 16) {
            RenderItem renderitem = Minecraft.func_71410_x().func_175599_af();
            GL11.glDisable((int)2896);
            renderitem.func_175042_a(item, gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY());
            GL11.glEnable((int)2896);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawImage(GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY) {
        this.drawImage(gui, targetX, targetY, srcX, srcY, sizeX, sizeY, GuiBase.RENDER_ROTATION.NORMAL);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawImage(GuiMinecart gui, int targetX, int targetY, int srcX, int srcY, int sizeX, int sizeY, GuiBase.RENDER_ROTATION rotation) {
        this.drawImage(gui, new int[]{targetX, targetY, sizeX, sizeY}, srcX, srcY, rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawImage(GuiMinecart gui, int[] rect, int srcX, int srcY) {
        this.drawImage(gui, rect, srcX, srcY, GuiBase.RENDER_ROTATION.NORMAL);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawImage(GuiMinecart gui, int[] rect, int srcX, int srcY, GuiBase.RENDER_ROTATION rotation) {
        if (rect.length < 4) {
            return;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            srcY -= this.handleScroll(rect);
        }
        if (rect[3] > 0) {
            gui.drawTexturedModalRect(gui.getGuiLeft() + rect[0] + this.getX(), gui.getGuiTop() + rect[1] + this.getY(), srcX, srcY, rect[2], rect[3], rotation);
        }
    }

    public int handleScroll(int[] rect) {
        boolean n = true;
        rect[1] = rect[1] - this.getCart().getRealScrollY();
        int y = rect[1] + this.getY();
        if (y < 4) {
            int dif = y - 4;
            int n2 = 3;
            rect[3] = rect[3] + dif;
            y = 4;
            rect[1] = y - this.getY();
            return dif;
        }
        if (y + rect[3] > 168) {
            rect[3] = Math.max(0, 168 - y);
            return 0;
        }
        return 0;
    }

    private int[] cloneRect(int[] rect) {
        return new int[]{rect[0], rect[1], rect[2], rect[3]};
    }

    public boolean useButtons() {
        return false;
    }

    public final void buttonVisibilityChanged() {
        Collections.sort(this.buttons, ButtonComparator.INSTANCE);
        ButtonBase.LOCATION lastLoc = null;
        int id = 0;
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            if (lastLoc != null && button.getLocation() != lastLoc) {
                id = 0;
            }
            lastLoc = button.getLocation();
            button.setCurrentID(id);
            ++id;
        }
    }

    public RAILDIRECTION getSpecialRailDirection(BlockPos pos) {
        return RAILDIRECTION.DEFAULT;
    }

    protected void loadButtons() {
    }

    public final void addButton(ButtonBase button) {
        button.setIdInModule(this.moduleButtonId++);
        this.buttons.add(button);
    }

    public String generateNBTName(String name, int id) {
        return "module" + id + name;
    }

    public final void writeToNBT(NBTTagCompound tagCompound, int id) {
        if (this.getInventorySize() > 0) {
            NBTTagList items = new NBTTagList();
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.getStack(i) == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74774_a("Slot", (byte)i);
                this.getStack(i).func_77955_b(item);
                items.func_74742_a((NBTBase)item);
            }
            tagCompound.func_74782_a(this.generateNBTName("Items", id), (NBTBase)items);
        }
        this.Save(tagCompound, id);
    }

    protected void Save(NBTTagCompound tagCompound, int id) {
    }

    public final void readFromNBT(NBTTagCompound tagCompound, int id) {
        if (this.getInventorySize() > 0) {
            NBTTagList items = tagCompound.func_150295_c(this.generateNBTName("Items", id), NBTHelper.COMPOUND.getId());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                int slot = item.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getInventorySize()) continue;
                this.setStack(slot, ItemStack.func_77949_a((NBTTagCompound)item));
            }
        }
        this.Load(tagCompound, id);
    }

    protected void Load(NBTTagCompound tagCompound, int id) {
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawButtonText(GuiMinecart gui) {
        for (ButtonBase button : this.buttons) {
            button.drawButtonText(gui, this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawButtons(GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            button.drawButton(gui, this, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawButtonOverlays(GuiMinecart gui, int x, int y) {
        for (ButtonBase button : this.buttons) {
            if (!button.isVisible()) continue;
            this.drawStringOnMouseOver(gui, button.toString(), x, y, button.getBounds());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void mouseClickedButton(GuiMinecart gui, int x, int y, int mousebutton) {
        for (ButtonBase button : this.buttons) {
            if (!this.inRect(x, y, button.getBounds())) continue;
            button.computeOnClick(gui, mousebutton);
        }
    }

    public void sendButtonPacket(ButtonBase button, byte clickinfo) {
        byte id = (byte)button.getIdInModule();
        System.out.println("Sent button " + button.getIdInModule());
        this.sendPacket(this.totalNumberOfPackets() - 1, new byte[]{id, clickinfo});
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackgroundItems(GuiMinecart gui, int x, int y) {
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return this.inRect(x, y, new int[]{x1, y1, sizeX, sizeY});
    }

    public boolean inRect(int x, int y, int[] rect) {
        if (rect.length < 4) {
            return false;
        }
        rect = this.cloneRect(rect);
        if (!this.doStealInterface()) {
            this.handleScroll(rect);
        }
        return x >= rect[0] && x <= rect[0] + rect[2] && y >= rect[1] && y <= rect[1] + rect[3];
    }

    public boolean receiveDamage(DamageSource source, float val) {
        return true;
    }

    protected void turnback() {
        for (ModuleBase module : this.getCart().getModules()) {
            if (module == this || !module.preventTurnback()) continue;
            return;
        }
        this.getCart().turnback();
    }

    protected boolean preventTurnback() {
        return false;
    }

    public final int totalNumberOfPackets() {
        return this.numberOfPackets() + (this.useButtons() ? 1 : 0);
    }

    protected int numberOfPackets() {
        return 0;
    }

    public int getPacketStart() {
        return this.packetOffset;
    }

    public void setPacketStart(int val) {
        this.packetOffset = val;
    }

    protected void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendPacket(this.getPacketStart() + id, data);
    }

    protected void sendPacket(int id, EntityPlayer player) {
        this.sendPacket(id, new byte[0], player);
    }

    protected void sendPacket(int id, byte data, EntityPlayer player) {
        this.sendPacket(id, new byte[]{data}, player);
    }

    protected void sendPacket(int id, byte[] data, EntityPlayer player) {
        PacketHandler.sendPacketToPlayer(this.getPacketStart() + id, data, player, this.getCart());
    }

    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
    }

    public final void delegateReceivedPacket(int id, byte[] data, EntityPlayer player) {
        if (id < 0 || id >= this.totalNumberOfPackets()) {
            return;
        }
        if (id == this.totalNumberOfPackets() - 1 && this.useButtons()) {
            int buttonId = data[0];
            if (buttonId < 0) {
                buttonId += 256;
            }
            System.out.println("Received button " + buttonId);
            for (ButtonBase button : this.buttons) {
                if (button.getIdInModule() != buttonId) continue;
                byte buttoninformation = data[1];
                boolean isCtrlDown = (buttoninformation & 0x40) != 0;
                boolean isShiftDown = (buttoninformation & 0x80) != 0;
                int mousebutton = buttoninformation & 0x3F;
                if (button.isVisible() && button.isEnabled()) {
                    button.onServerClick(player, mousebutton, isCtrlDown, isShiftDown);
                }
                break;
            }
        } else {
            this.receivePacket(id, data, player);
        }
    }

    public int numberOfDataWatchers() {
        return 0;
    }

    public void initDw() {
    }

    protected final <T> void registerDw(DataParameter<T> key, T value) {
        for (EntityDataManager.DataEntry entry : this.getCart().func_184212_Q().func_187231_c()) {
            if (entry.func_187205_a() != key) continue;
            return;
        }
        this.getCart().func_184212_Q().func_187214_a(key, value);
    }

    protected final <T> void updateDw(DataParameter<T> key, T value) {
        this.getCart().func_184212_Q().func_187227_b(key, value);
    }

    protected <T> T getDw(DataParameter<T> key) {
        return (T)this.getCart().func_184212_Q().func_187225_a(key);
    }

    protected <T> DataParameter<T> createDw(DataSerializer<T> serializer) {
        return serializer.func_187161_a(this.cart.getNextDataWatcher());
    }

    public int numberOfGuiData() {
        return 0;
    }

    public int getGuiDataStart() {
        return this.guiDataOffset;
    }

    public void setGuiDataStart(int val) {
        this.guiDataOffset = val;
    }

    private final void updateGuiData(Container con, List<IContainerListener> players, int id, short data) {
        for (IContainerListener player : players) {
            player.func_71112_a(con, id, (int)data);
        }
    }

    public final void updateGuiData(Object[] info, int id, short data) {
        boolean flag;
        ContainerMinecart con = (ContainerMinecart)((Object)info[0]);
        if (con == null) {
            return;
        }
        int globalId = id + this.getGuiDataStart();
        List players = (List)info[1];
        boolean isNew = flag = ((Boolean)info[2]).booleanValue();
        if (!flag) {
            Short val;
            flag = con.cache != null ? (val = con.cache.get((short)globalId)) == null || val != data : true;
        }
        if (flag) {
            if (con.cache == null) {
                con.cache = new HashMap();
            }
            this.updateGuiData(con, players, globalId, data);
            con.cache.put((short)globalId, data);
        }
    }

    public final void initGuiData(Container con, IContainerListener player) {
        ArrayList<IContainerListener> players = new ArrayList<IContainerListener>();
        players.add(player);
        this.checkGuiData(con, players, true);
    }

    protected void checkGuiData(Object[] info) {
    }

    public final void checkGuiData(Container con, List players, boolean isNew) {
        if (con == null) {
            return;
        }
        this.checkGuiData(new Object[]{con, players, isNew});
    }

    public void receiveGuiData(int id, short data) {
    }

    public int getConsumption(boolean isMoving) {
        return 0;
    }

    public void setModels(ArrayList<ModelCartbase> models) {
        this.models = models;
    }

    public ArrayList<ModelCartbase> getModels() {
        return this.models;
    }

    public boolean haveModels() {
        return this.models != null;
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawStringOnMouseOver(GuiMinecart gui, String str, int x, int y, int x1, int y1, int w, int h) {
        this.drawStringOnMouseOver(gui, str, x, y, new int[]{x1, y1, w, h});
    }

    @SideOnly(value=Side.CLIENT)
    public final void drawStringOnMouseOver(GuiMinecart gui, String str, int x, int y, int[] rect) {
        if (!this.inRect(x, y, rect)) {
            return;
        }
        gui.drawMouseOver(str, x += this.getX(), y += this.getY());
    }

    protected void drawImage(int[] rect, int sourceX, int sourceY) {
        this.drawImage(rect[0], rect[1], sourceX, sourceY, rect[2], rect[3]);
    }

    protected void drawImage(int targetX, int targetY, int sourceX, int sourceY, int width, int height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tess.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(targetX + 0), (double)(targetY + height), -90.0).func_187315_a((double)((float)(sourceX + 0) * 0.00390625f), (double)((float)(sourceY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(targetX + width), (double)(targetY + height), -90.0).func_187315_a((double)((float)(sourceX + width) * 0.00390625f), (double)((float)(sourceY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(targetX + width), (double)(targetY + 0), -90.0).func_187315_a((double)((float)(sourceX + width) * 0.00390625f), (double)((float)(sourceY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(targetX + 0), (double)(targetY + 0), -90.0).func_187315_a((double)((float)(sourceX + 0) * 0.00390625f), (double)((float)(sourceY + 0) * 0.00390625f)).func_181675_d();
        tess.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    protected EntityPlayer getClientPlayer() {
        if (Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71439_g;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(Minecraft minecraft) {
    }

    public boolean stopEngines() {
        return false;
    }

    public boolean shouldCartRender() {
        return true;
    }

    public double getPushFactor() {
        return -1.0;
    }

    public float[] getColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public float mountedOffset(Entity rider) {
        return 0.0f;
    }

    protected boolean countsAsAir(BlockPos pos) {
        if (this.getCart().field_70170_p.func_175623_d(pos)) {
            return true;
        }
        IBlockState b = this.getCart().field_70170_p.func_180495_p(pos);
        return b instanceof BlockSnow || b instanceof BlockFlower || b instanceof BlockVine;
    }

    public void activatedByRail(int x, int y, int z, boolean active) {
    }

    public ModuleData getData() {
        return ModuleData.getList().get(this.getModuleId());
    }

    public boolean doStealInterface() {
        return false;
    }

    public boolean hasExtraData() {
        return false;
    }

    public byte getExtraData() {
        return 0;
    }

    public void setExtraData(byte b) {
    }

    protected FakePlayer getFakePlayer() {
        return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.getCart().field_70170_p));
    }

    public boolean disableStandardKeyFunctionality() {
        return false;
    }

    public void addToLabel(ArrayList<String> label) {
    }

    public boolean onInteractFirst(EntityPlayer entityplayer) {
        return false;
    }

    public void postUpdate() {
    }

    public String getModuleName() {
        return ModuleData.getList().get(this.getModuleId()).getName();
    }

    public static enum RAILDIRECTION {
        DEFAULT,
        NORTH,
        WEST,
        SOUTH,
        EAST,
        LEFT,
        FORWARD,
        RIGHT;

    }
}

