/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.items;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.Constants;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.entitys.EntityEasterEgg;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.renders.model.ItemModelManager;
import vswe.stevescarts.renders.model.TexturedItem;

public class ItemCartComponent
extends Item
implements TexturedItem {
    public static int size() {
        return ComponentTypes.values().length;
    }

    public ItemCartComponent() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(StevesCarts.tabsSC2Components);
        ItemModelManager.registerItem(this);
    }

    private String getName(int dmg) {
        return ComponentTypes.values()[dmg].getName();
    }

    public String getName(ItemStack par1ItemStack) {
        if (par1ItemStack == null || par1ItemStack.func_77952_i() < 0 || par1ItemStack.func_77952_i() >= ItemCartComponent.size() || this.getName(par1ItemStack.func_77952_i()) == null) {
            return "Unknown SC2 Component";
        }
        return this.getName(par1ItemStack.func_77952_i());
    }

    private String getRawName(int i) {
        if (this.getName(i) == null) {
            return null;
        }
        return this.getName(i).replace(":", "").replace(" ", "_").toLowerCase();
    }

    public String func_77667_c(ItemStack item) {
        if (item == null || item.func_77952_i() < 0 || item.func_77952_i() >= ItemCartComponent.size() || this.getName(item.func_77952_i()) == null) {
            return this.func_77658_a();
        }
        return "item.SC2:" + this.getRawName(item.func_77952_i());
    }

    public String func_77658_a() {
        return "item.SC2:unknowncomponent";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack == null || par1ItemStack.func_77952_i() < 0 || par1ItemStack.func_77952_i() >= ItemCartComponent.size() || this.getName(par1ItemStack.func_77952_i()) == null) {
            if (par1ItemStack != null && par1ItemStack.func_77973_b() instanceof ItemCartComponent) {
                par3List.add("Component id " + par1ItemStack.func_77952_i());
            } else {
                par3List.add("Unknown component id");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < ItemCartComponent.size(); ++i) {
            ItemStack iStack = new ItemStack(par1, 1, i);
            if (!this.isValid(iStack)) continue;
            par3List.add(iStack);
        }
    }

    public boolean isValid(ItemStack item) {
        if (item == null || !(item.func_77973_b() instanceof ItemCartComponent) || this.getName(item.func_77952_i()) == null) {
            return false;
        }
        if (item.func_77952_i() >= 50 && item.func_77952_i() < 58) {
            return Constants.isChristmas;
        }
        if (item.func_77952_i() >= 66 && item.func_77952_i() < 72) {
            return Constants.isEaster;
        }
        return item.func_77952_i() < 72 || item.func_77952_i() >= 80;
    }

    public static ItemStack getWood(int type, boolean isLog) {
        return ItemCartComponent.getWood(type, isLog, 1);
    }

    public static ItemStack getWood(int type, boolean isLog, int count) {
        return new ItemStack((Item)ModItems.component, count, 72 + type * 2 + (isLog ? 0 : 1));
    }

    public static boolean isWoodLog(ItemStack item) {
        return item != null && item.func_77952_i() >= 72 && item.func_77952_i() < 80 && (item.func_77952_i() - 72) % 2 == 0;
    }

    public static boolean isWoodTwig(ItemStack item) {
        return item != null && item.func_77952_i() >= 72 && item.func_77952_i() < 80 && (item.func_77952_i() - 72) % 2 == 1;
    }

    private boolean isEdibleEgg(ItemStack item) {
        return item != null && item.func_77952_i() >= 66 && item.func_77952_i() < 70;
    }

    private boolean isThrowableEgg(ItemStack item) {
        return item != null && item.func_77952_i() == 70;
    }

    public ItemStack func_77654_b(ItemStack item, World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && this.isEdibleEgg(item)) {
            EntityPlayer player = (EntityPlayer)entity;
            if (item.func_77952_i() == 66) {
                world.func_72876_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.1f, false);
            } else if (item.func_77952_i() == 67) {
                entity.func_70015_d(5);
                if (!world.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 600, 0));
                }
            } else if (item.func_77952_i() == 68) {
                if (!world.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 50, 2));
                }
            } else if (item.func_77952_i() == 69) {
                if (!world.field_72995_K) {
                    entity.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 300, 4));
                }
            } else if (item.func_77952_i() == 70) {
                // empty if block
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            world.func_184148_a((EntityPlayer)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            player.func_71024_bL().func_75122_a(2, 0.0f);
            return item;
        }
        return super.func_77654_b(item, world, entity);
    }

    public int func_77626_a(ItemStack item) {
        return this.isEdibleEgg(item) ? 32 : super.func_77626_a(item);
    }

    public EnumAction func_77661_b(ItemStack item) {
        return this.isEdibleEgg(item) ? EnumAction.EAT : super.func_77661_b(item);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (this.isEdibleEgg(item)) {
            player.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)item);
        }
        if (this.isThrowableEgg(item)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
            }
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityEasterEgg(world, (EntityLivingBase)player));
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)item);
        }
        return super.func_77659_a(item, world, player, hand);
    }

    @Override
    public String getTextureName(int damage) {
        if (this.getRawName(damage) == null) {
            return "stevescarts:items/unknown_icon";
        }
        return "stevescarts:items/" + this.getRawName(damage) + "_icon";
    }

    @Override
    public int getMaxMeta() {
        return ItemCartComponent.size();
    }
}

