/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers.storages;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import vswe.stevescarts.containers.slots.ISpecialItemTransferValidator;
import vswe.stevescarts.containers.slots.ISpecialSlotValidator;

public class TransferHandler {
    public static boolean isSlotOfType(Slot slot, Class slotType) {
        if (slot instanceof ISpecialSlotValidator) {
            ISpecialSlotValidator specSlot = (ISpecialSlotValidator)slot;
            return specSlot.isSlotValid();
        }
        return slotType.isInstance(slot);
    }

    public static boolean isItemValidForTransfer(Slot slot, ItemStack item, TRANSFER_TYPE type) {
        if (slot instanceof ISpecialItemTransferValidator) {
            ISpecialItemTransferValidator specSlot = (ISpecialItemTransferValidator)slot;
            return specSlot.isItemValidForTransfer(item, type);
        }
        return slot.func_75214_a(item);
    }

    public static void TransferItem(ItemStack iStack, IInventory inv, Container cont, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, cont, Slot.class, null, maxItems);
    }

    public static void TransferItem(ItemStack iStack, IInventory inv, Container cont, Class validSlot, int maxItems, TRANSFER_TYPE type) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.func_70302_i_() - 1, cont, validSlot, null, maxItems, type, false);
    }

    public static void TransferItem(ItemStack iStack, IInventory inv, Container cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, 0, inv.func_70302_i_() - 1, cont, validSlot, invalidSlot, maxItems);
    }

    public static void TransferItem(ItemStack iStack, IInventory inv, int start, int end, Container cont, Class validSlot, Class invalidSlot, int maxItems) {
        TransferHandler.TransferItem(iStack, inv, start, end, cont, validSlot, invalidSlot, maxItems, TRANSFER_TYPE.OTHER, false);
    }

    public static void TransferItem(ItemStack iStack, IInventory inv, int start, int end, Container cont, Class validSlot, Class invalidSlot, int maxItems, TRANSFER_TYPE type, boolean fake) {
        int pos;
        start = Math.max(0, start);
        end = Math.min(inv.func_70302_i_() - 1, end);
        int startEmpty = start;
        int startOccupied = start;
        do {
            int i;
            pos = -1;
            for (i = startEmpty; i <= end; ++i) {
                if (!TransferHandler.isSlotOfType(cont.func_75139_a(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.func_75139_a(i), invalidSlot) || inv.func_70301_a(i) == null || inv.func_70301_a(i).func_77973_b() != iStack.func_77973_b() || !inv.func_70301_a(i).func_77985_e() || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d() || inv.func_70301_a((int)i).field_77994_a >= cont.func_75139_a(i).func_75219_a() || inv.func_70301_a((int)i).field_77994_a <= 0 || iStack.field_77994_a <= 0 || inv.func_70301_a(i).func_77981_g() && inv.func_70301_a(i).func_77952_i() != iStack.func_77952_i() || inv.func_70301_a(i).func_77978_p() != null && !inv.func_70301_a(i).func_77978_p().equals((Object)iStack.func_77978_p())) continue;
                pos = i;
                startEmpty = pos + 1;
                break;
            }
            if (pos == -1) {
                for (i = startOccupied; i <= end; ++i) {
                    Slot slot;
                    if (!TransferHandler.isSlotOfType(cont.func_75139_a(i), validSlot) || invalidSlot != null && TransferHandler.isSlotOfType(cont.func_75139_a(i), invalidSlot) || !TransferHandler.isItemValidForTransfer(slot = cont.func_75139_a(i), iStack, type) || inv.func_70301_a(i) != null) continue;
                    pos = i;
                    startOccupied = pos + 1;
                    break;
                }
            }
            if (pos == -1) continue;
            ItemStack existingItem = null;
            if (inv.func_70301_a(pos) == null) {
                ItemStack clone = iStack.func_77946_l();
                clone.field_77994_a = 0;
                if (!fake) {
                    inv.func_70299_a(pos, clone);
                }
                existingItem = clone;
            } else {
                existingItem = inv.func_70301_a(pos);
            }
            int stackSize = iStack.field_77994_a;
            if (stackSize > existingItem.func_77976_d() - existingItem.field_77994_a) {
                stackSize = existingItem.func_77976_d() - existingItem.field_77994_a;
            }
            if (stackSize > cont.func_75139_a(pos).func_75219_a() - existingItem.field_77994_a) {
                stackSize = cont.func_75139_a(pos).func_75219_a() - existingItem.field_77994_a;
            }
            boolean killMe = false;
            if (maxItems != -1) {
                if (stackSize > maxItems) {
                    stackSize = maxItems;
                    killMe = true;
                }
                maxItems -= stackSize;
            }
            if (stackSize <= 0) {
                pos = -1;
                continue;
            }
            iStack.field_77994_a -= stackSize;
            if (!fake) {
                ItemStack stackInSlot = inv.func_70301_a(pos);
                stackInSlot.field_77994_a += stackSize;
            }
            if (iStack.field_77994_a != 0 && !killMe && maxItems != 0) continue;
            pos = -1;
        } while (pos != -1);
        if (!fake) {
            inv.func_70296_d();
        }
    }

    public static enum TRANSFER_TYPE {
        SHIFT,
        MANAGER,
        OTHER;

    }
}

