/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerDistributor;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.DistributorSide;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

@SideOnly(value=Side.CLIENT)
public class GuiDistributor
extends GuiBase {
    private String mouseOverText;
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/distributor.png");
    private int activeId = -1;
    TileEntityDistributor distributor;
    InventoryPlayer invPlayer;

    public GuiDistributor(InventoryPlayer invPlayer, TileEntityDistributor distributor) {
        super(new ContainerDistributor((IInventory)invPlayer, distributor));
        this.invPlayer = invPlayer;
        this.setXSize(255);
        this.setYSize(186);
        this.distributor = distributor;
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        GL11.glDisable((int)2896);
        this.getFontRenderer().func_78276_b(Localization.GUI.DISTRIBUTOR.TITLE.translate(new String[0]), 8, 6, 0x404040);
        TileEntityManager[] invs = this.distributor.getInventories();
        if (invs.length == 0) {
            this.getFontRenderer().func_78276_b(Localization.GUI.DISTRIBUTOR.NOT_CONNECTED.translate(new String[0]), 30, 40, 0xFF4040);
        }
        if (this.mouseOverText != null && !this.mouseOverText.equals("")) {
            this.drawMouseOver(this.mouseOverText, x - this.getGuiLeft(), y - this.getGuiTop());
        }
        this.mouseOverText = null;
        GL11.glEnable((int)2896);
    }

    private void drawMouseMover(String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.mouseOverText = str;
        }
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        int[] box;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(texture);
        this.func_73729_b(j, k, 0, 0, this.field_146999_f, this.field_147000_g);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        TileEntityManager[] invs = this.distributor.getInventories();
        ArrayList<DistributorSide> sides = this.distributor.getSides();
        int id = 0;
        for (DistributorSide side : sides) {
            if (!side.isEnabled(this.distributor)) continue;
            box = this.getSideBoxRect(id);
            int srcX = 0;
            if (this.inRect(x, y, box)) {
                srcX = box[2];
            }
            this.func_73729_b(j + box[0], k + box[1], srcX, this.field_147000_g, box[2], box[3]);
            this.func_73729_b(j + box[0] + 2, k + box[1] + 2, box[2] * 2 + (box[2] - 4) * side.getId(), this.field_147000_g, box[2] - 4, box[3] - 4);
            this.drawMouseMover(Localization.GUI.DISTRIBUTOR.SIDE.translate(side.getName()) + (this.activeId != -1 ? "\n[" + Localization.GUI.DISTRIBUTOR.DROP_INSTRUCTION.translate(new String[0]) + "]" : ""), x, y, box);
            int settingCount = 0;
            for (DistributorSetting setting : DistributorSetting.settings) {
                if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId())) continue;
                int[] settingbox = this.getActiveSettingBoxRect(id, settingCount++);
                this.drawSetting(setting, settingbox, this.inRect(x, y, settingbox));
                this.drawMouseMover(setting.getName(invs) + "\n[" + Localization.GUI.DISTRIBUTOR.REMOVE_INSTRUCTION.translate(new String[0]) + "]", x, y, settingbox);
            }
            ++id;
        }
        for (DistributorSetting setting2 : DistributorSetting.settings) {
            if (!setting2.isEnabled(this.distributor)) continue;
            box = this.getSettingBoxRect(setting2.getImageId(), setting2.getIsTop());
            this.drawSetting(setting2, box, this.inRect(x, y, box));
            this.drawMouseMover(setting2.getName(invs), x, y, box);
        }
        if (this.activeId != -1) {
            DistributorSetting setting3 = DistributorSetting.settings.get(this.activeId);
            this.drawSetting(setting3, new int[]{x - 8, y - 8, 16, 16}, true);
        }
    }

    private void drawSetting(DistributorSetting setting, int[] box, boolean hover) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        int srcX = 0;
        if (!setting.getIsTop()) {
            srcX += box[2] * 2;
        }
        if (hover) {
            srcX += box[2];
        }
        this.func_73729_b(j + box[0], k + box[1], srcX, this.field_147000_g + this.getSideBoxRect(0)[3], box[2], box[3]);
        this.func_73729_b(j + box[0] + 1, k + box[1] + 1, box[2] * 4 + (box[2] - 2) * setting.getImageId(), this.field_147000_g + this.getSideBoxRect(0)[3], box[2] - 2, box[3] - 2);
    }

    private int[] getSideBoxRect(int i) {
        return new int[]{20, 18 + i * 24, 22, 22};
    }

    private int[] getSettingBoxRect(int i, boolean topRow) {
        return new int[]{20 + i * 18, 143 + (topRow ? 0 : 18), 16, 16};
    }

    private int[] getActiveSettingBoxRect(int side, int setting) {
        int[] sideCoords = this.getSideBoxRect(side);
        return new int[]{sideCoords[0] + sideCoords[2] + 5 + setting * 18, sideCoords[1] + (sideCoords[3] - 16) / 2, 16, 16};
    }

    @Override
    public void mouseClick(int x, int y, int button) {
        super.mouseClick(x, y, button);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        if (button == 0) {
            for (DistributorSetting setting : DistributorSetting.settings) {
                int[] box;
                if (!setting.isEnabled(this.distributor) || !this.inRect(x, y, box = this.getSettingBoxRect(setting.getImageId(), setting.getIsTop()))) continue;
                this.activeId = setting.getId();
            }
        }
    }

    @Override
    public void mouseMoved(int x, int y, int button) {
        super.mouseMoved(x, y, button);
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        if (button == 0 && this.activeId != -1) {
            int id = 0;
            for (DistributorSide side : this.distributor.getSides()) {
                int[] box;
                if (!side.isEnabled(this.distributor) || !this.inRect(x, y, box = this.getSideBoxRect(id++))) continue;
                this.distributor.sendPacket(0, new byte[]{(byte)this.activeId, (byte)side.getId()});
                break;
            }
            this.activeId = -1;
        } else if (button == 1) {
            int id = 0;
            for (DistributorSide side : this.distributor.getSides()) {
                if (!side.isEnabled(this.distributor)) continue;
                int settingCount = 0;
                for (DistributorSetting setting : DistributorSetting.settings) {
                    int[] settingbox;
                    if (!setting.isEnabled(this.distributor) || !side.isSet(setting.getId()) || !this.inRect(x, y, settingbox = this.getActiveSettingBoxRect(id, settingCount++))) continue;
                    this.distributor.sendPacket(1, new byte[]{(byte)setting.getId(), (byte)side.getId()});
                }
                ++id;
            }
        }
    }
}

