/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Constants;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.slots.SlotAssembler;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.helpers.DropDownMenuItem;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.helpers.TitleBox;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.modules.data.ModuleDataHull;

@SideOnly(value=Side.CLIENT)
public class GuiCartAssembler
extends GuiBase {
    private ArrayList<TextWithColor> statusLog;
    private boolean hasErrors;
    private boolean firstLoad = true;
    private static ResourceLocation[] backgrounds = new ResourceLocation[4];
    private static final ResourceLocation textureLeft;
    private static final ResourceLocation textureRight;
    private static final ResourceLocation textureExtra;
    private int[] assembleRect = new int[]{390, 160, 80, 11};
    String validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int dropdownX = -1;
    private int dropdownY = -1;
    private int scrollingX;
    private int scrollingY;
    private boolean isScrolling;
    private int[] blackBackground = new int[]{145, 15, 222, 148};
    private TileEntityCartAssembler assembler;
    private InventoryPlayer invPlayer;

    public GuiCartAssembler(InventoryPlayer invPlayer, TileEntityCartAssembler assembler) {
        super(new ContainerCartAssembler((IInventory)invPlayer, assembler));
        this.assembler = assembler;
        this.invPlayer = invPlayer;
        this.setXSize(512);
        this.setYSize(256);
    }

    @Override
    public void drawGuiForeground(int x, int y) {
        ArrayList<TextWithColor> lines;
        this.getFontRenderer().func_78276_b(Localization.GUI.ASSEMBLER.TITLE.translate(new String[0]), 8, 6, 0x404040);
        if (this.assembler.isErrorListOutdated) {
            this.updateErrorList();
            this.assembler.isErrorListOutdated = false;
        }
        if ((lines = this.statusLog) != null) {
            int lineCount = lines.size();
            boolean dotdotdot = false;
            if (lineCount > 11) {
                lineCount = 10;
                dotdotdot = true;
            }
            for (int i = 0; i < lineCount; ++i) {
                TextWithColor info = lines.get(i);
                if (info == null) continue;
                this.getFontRenderer().func_78276_b(info.getText(), 375, 40 + i * 10, info.getColor());
            }
            if (dotdotdot) {
                this.getFontRenderer().func_78276_b("...", 375, 40 + lineCount * 10, 0x404040);
            }
        }
    }

    private void updateErrorList() {
        ArrayList<TextWithColor> lines = new ArrayList<TextWithColor>();
        if (this.assembler.func_70301_a(0) == null) {
            this.addText(lines, Localization.GUI.ASSEMBLER.ASSEMBLE_INSTRUCTION.translate(new String[0]));
            this.hasErrors = true;
        } else {
            ModuleData hulldata = ModItems.modules.getModuleData(this.assembler.func_70301_a(0));
            if (hulldata == null || !(hulldata instanceof ModuleDataHull)) {
                this.addText(lines, Localization.GUI.ASSEMBLER.INVALID_HULL.translate(new String[0]), 10357518);
                this.hasErrors = true;
            } else {
                ModuleDataHull hull = (ModuleDataHull)hulldata;
                this.addText(lines, Localization.GUI.ASSEMBLER.HULL_CAPACITY.translate(new String[0]) + ": " + hull.getCapacity());
                this.addText(lines, Localization.GUI.ASSEMBLER.COMPLEXITY_CAP.translate(new String[0]) + ": " + hull.getComplexityMax());
                this.addText(lines, Localization.GUI.ASSEMBLER.TOTAL_COST.translate(new String[0]) + ": " + this.assembler.getTotalCost());
                this.addText(lines, Localization.GUI.ASSEMBLER.TOTAl_TIME.translate(new String[0]) + ": " + this.formatTime((int)((float)this.assembler.generateAssemblingTime() / this.assembler.getEfficiency())));
                this.addNewLine(lines);
                ArrayList<String> errors = this.assembler.getErrors();
                boolean bl = this.hasErrors = errors.size() > 0;
                if (errors.size() == 0) {
                    this.addText(lines, Localization.GUI.ASSEMBLER.NO_ERROR.translate(new String[0]), 22566);
                } else {
                    for (String error : errors) {
                        this.addText(lines, error, 10357518);
                    }
                }
            }
        }
        this.statusLog = lines;
    }

    private void addText(ArrayList<TextWithColor> lines, String text) {
        this.addText(lines, text, 0x404040);
    }

    private void addText(ArrayList<TextWithColor> lines, String text, int color) {
        List newlines = this.getFontRenderer().func_78271_c(text, 130);
        for (Object line : newlines) {
            lines.add(new TextWithColor(line.toString(), color));
        }
    }

    private void addNewLine(ArrayList<TextWithColor> lines) {
        lines.add(null);
    }

    @Override
    public void drawGuiBackground(float f, int x, int y) {
        String assemblingInfo;
        if (this.firstLoad) {
            this.updateErrorList();
            this.firstLoad = false;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(backgrounds[this.assembler.getSimulationInfo().getBackground()]);
        this.func_73729_b(j + 143, k + 15, 0, 0, 220, 148);
        ResourceHelper.bindResource(textureLeft);
        this.func_73729_b(j, k, 0, 0, 256, this.field_147000_g);
        ResourceHelper.bindResource(textureRight);
        this.func_73729_b(j + 256, k, 0, 0, this.field_146999_f - 256, this.field_147000_g);
        this.func_73729_b(j + 256, k, 0, 0, this.field_146999_f - 256, this.field_147000_g);
        ResourceHelper.bindResource(textureExtra);
        ArrayList<SlotAssembler> slots = this.assembler.getSlots();
        for (SlotAssembler slot : slots) {
            int srcY;
            int srcX;
            int size;
            int targetX = slot.getX() - 1;
            int targetY = slot.getY() - 1;
            if (slot.useLargeInterface()) {
                targetX -= 3;
                targetY -= 3;
                size = 24;
                srcX = 0;
                srcY = 0;
            } else {
                size = 18;
                if (slot.func_75211_c() != null && slot.func_75211_c().field_77994_a <= 0) {
                    srcX = slot.func_75211_c().field_77994_a == TileEntityCartAssembler.getRemovedSize() ? 140 : 122;
                    srcY = 40;
                } else {
                    srcX = 24;
                    srcY = 0;
                }
            }
            this.func_73729_b(j + targetX, k + targetY, srcX, srcY, size, size);
            int animationTick = slot.getAnimationTick();
            if (animationTick < 0) {
                animationTick = 0;
            }
            if (animationTick >= 8 || slot.useLargeInterface()) continue;
            this.func_73729_b(j + targetX + 1, k + targetY + 1, 0, 24 + animationTick, 16, 8 - animationTick);
            this.func_73729_b(j + targetX + 1, k + targetY + 1 + 8 + animationTick, 0, 32, 16, 8 - animationTick);
        }
        for (TitleBox box : this.assembler.getTitleBoxes()) {
            int targetY2 = box.getY() - 12;
            int targetX2 = box.getX();
            this.func_73729_b(j + targetX2, k + targetY2, 0, 40, 115, 11);
            GL11.glColor4f((float)((float)(box.getColor() >> 16) / 255.0f), (float)((float)(box.getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(box.getColor() & 0xFF) / 255.0f), (float)1.0f);
            this.func_73729_b(j + targetX2 + 8, k + targetY2 + 2, 0, 51 + box.getID() * 7, 115, 7);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        boolean isDisassembling = this.assembler.getIsDisassembling();
        int srcX2 = 42;
        int srcY2 = 0;
        if (isDisassembling) {
            srcX2 = 158;
            srcY2 = 40;
        }
        if (this.hasErrors) {
            srcY2 += 22;
        } else if (this.inRect(x - j, y - k, this.assembleRect)) {
            srcY2 += 11;
        }
        this.func_73729_b(j + this.assembleRect[0], k + this.assembleRect[1], srcX2, srcY2, this.assembleRect[2], this.assembleRect[3]);
        int[] assemblingProgRect = new int[]{375, 180, 115, 11};
        int[] fuelProgRect = new int[]{375, 200, 115, 11};
        float assemblingProgress = 0.0f;
        if (this.assembler.getIsAssembling()) {
            assemblingProgress = (float)this.assembler.getAssemblingTime() / (float)this.assembler.getMaxAssemblingTime();
            assemblingInfo = Localization.GUI.ASSEMBLER.ASSEMBLE_PROGRESS.translate(new String[0]) + ": " + this.formatProgress(assemblingProgress);
            assemblingInfo = assemblingInfo + "\n" + Localization.GUI.ASSEMBLER.TIME_LEFT.translate(new String[0]) + ": " + this.formatTime((int)((float)(this.assembler.getMaxAssemblingTime() - this.assembler.getAssemblingTime()) / this.assembler.getEfficiency()));
        } else {
            assemblingInfo = Localization.GUI.ASSEMBLER.IDLE_MESSAGE.translate(new String[0]);
        }
        this.drawProgressBar(assemblingProgRect, assemblingProgress, 22, x, y);
        this.drawProgressBar(fuelProgRect, (float)this.assembler.getFuelLevel() / (float)this.assembler.getMaxFuelLevel(), 31, x, y);
        this.renderDropDownMenu(x, y);
        this.render3DCart();
        if (!this.hasErrors) {
            if (isDisassembling) {
                this.drawProgressBarInfo(this.assembleRect, x, y, Localization.GUI.ASSEMBLER.MODIFY_CART.translate(new String[0]));
            } else {
                this.drawProgressBarInfo(this.assembleRect, x, y, Localization.GUI.ASSEMBLER.ASSEMBLE_CART.translate(new String[0]));
            }
        }
        this.drawProgressBarInfo(assemblingProgRect, x, y, assemblingInfo);
        this.drawProgressBarInfo(fuelProgRect, x, y, Localization.GUI.ASSEMBLER.FUEL_LEVEL.translate(new String[0]) + ": " + this.assembler.getFuelLevel() + "/" + this.assembler.getMaxFuelLevel());
    }

    private String formatProgress(float progress) {
        float percentage = (float)((int)(progress * 10000.0f)) / 100.0f;
        return String.format("%05.2f%%", Float.valueOf(percentage));
    }

    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        ticks -= seconds * 20;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d", hours, minutes -= hours * 60, seconds);
    }

    private void drawProgressBarInfo(int[] rect, int x, int y, String str) {
        if (this.inRect(x - this.getGuiLeft(), y - this.getGuiTop(), rect)) {
            this.drawMouseOver(str, x, y);
        }
    }

    private void drawProgressBar(int[] rect, float progress, int barSrcY, int x, int y) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        int boxSrcY = 0;
        if (this.inRect(x - j, y - k, rect)) {
            boxSrcY = 11;
        }
        this.func_73729_b(j + rect[0], k + rect[1], 122, boxSrcY, rect[2], rect[3]);
        if (progress != 0.0f) {
            if (progress > 1.0f) {
                progress = 1.0f;
            }
            this.func_73729_b(j + rect[0] + 1, k + rect[1] + 1, 122, barSrcY, (int)((float)rect[2] * progress), rect[3] - 2);
        }
    }

    private void render3DCart() {
        this.assembler.createPlaceholder();
        int left = this.field_147003_i;
        int top = this.field_147009_r;
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        float n = left + 256;
        int n2 = top;
        StevesCarts instance = StevesCarts.instance;
        GL11.glTranslatef((float)n, (float)(n2 + (Constants.renderSteve ? 50 : 100)), (float)100.0f);
        float scale = 50.0f;
        GL11.glScalef((float)-50.0f, (float)50.0f, (float)50.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.assembler.getRoll(), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.assembler.getYaw(), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        if (Constants.renderSteve) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, this.assembler.getCartFromModules(true));
            float temp = player.field_70125_A;
            player.field_70125_A = 0.7853982f;
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)player, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            player.field_70125_A = temp;
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)this.assembler.getPlaceholder(), 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        }
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        this.assembler.getPlaceholder().keepAlive = 0;
    }

    private void renderDropDownMenu(int x, int y) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        if (this.dropdownX != -1 && this.dropdownY != -1) {
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            block5: for (int i = 0; i < items.size(); ++i) {
                DropDownMenuItem item = items.get(i);
                int[] rect = item.getRect(this.dropdownX, this.dropdownY, i);
                int[] subrect = new int[]{};
                int srcX = 0;
                int srcY = item.getIsLarge() ? 113 : 93;
                this.func_73729_b(j + rect[0], k + rect[1], srcX, srcY, rect[2], rect[3]);
                if (item.getIsLarge()) {
                    this.drawString(item.getName(), j + rect[0] + 55, k + rect[1] + 7);
                }
                this.func_73729_b(j + rect[0] + 34, k + rect[1] + 2, item.getImageID() % 16 * 16, 179 + item.getImageID() / 16 * 16, 16, 16);
                if (item.hasSubmenu()) {
                    subrect = item.getSubRect(this.dropdownX, this.dropdownY, i);
                    srcX = item.getIsSubMenuOpen() ? 0 : 43;
                    srcY = 133;
                    this.func_73729_b(j + subrect[0], k + subrect[1], srcX, srcY, subrect[2], subrect[3]);
                }
                switch (item.getType()) {
                    case BOOL: {
                        this.drawBooleanBox(x, y, 5 + rect[0], 5 + rect[1], item.getBOOL());
                        continue block5;
                    }
                    case INT: {
                        if (item.getIsSubMenuOpen()) {
                            this.drawIncreamentBox(x, y, this.getOffSetXForSubMenuBox(0, 2) + subrect[0], 3 + subrect[1]);
                            this.drawDecreamentBox(x, y, this.getOffSetXForSubMenuBox(1, 2) + subrect[0], 3 + subrect[1]);
                        }
                        int targetX = rect[0] + 16;
                        int targetY = rect[1] + 7;
                        int valueToWrite = item.getINT();
                        if (valueToWrite >= 10) {
                            this.drawDigit(valueToWrite / 10, -1, targetX, targetY);
                            this.drawDigit(valueToWrite % 10, 1, targetX, targetY);
                            continue block5;
                        }
                        this.drawDigit(valueToWrite, 0, targetX, targetY);
                        continue block5;
                    }
                    case MULTIBOOL: {
                        if (!item.getIsSubMenuOpen()) continue block5;
                        int count = item.getMULTIBOOLCount();
                        for (int bool = 0; bool < count; ++bool) {
                            this.drawBooleanBox(x, y, subrect[0] + this.getOffSetXForSubMenuBox(bool, count), subrect[1] + 3, item.getMULTIBOOL(bool));
                        }
                        continue block5;
                    }
                }
            }
        }
        GL11.glPopMatrix();
    }

    private void drawString(String str, int x, int y) {
        str = str.toUpperCase();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int index = this.validChars.indexOf(c);
            if (index == -1) continue;
            this.func_73729_b(x + 7 * i, y, 8 * index, 165, 6, 7);
        }
    }

    private int getOffSetXForSubMenuBox(int id, int count) {
        return 2 + (int)(20.0f + ((float)id - (float)count / 2.0f) * 10.0f);
    }

    private void drawDigit(int digit, int offset, int targetX, int targetY) {
        int srcX = digit * 8;
        int srcY = 172;
        this.func_73729_b(this.getGuiLeft() + (targetX += offset * 4), this.getGuiTop() + targetY, srcX, 172, 6, 7);
    }

    private void drawIncreamentBox(int mouseX, int mouseY, int x, int y) {
        this.drawStandardBox(mouseX, mouseY, x, y, 10);
    }

    private void drawDecreamentBox(int mouseX, int mouseY, int x, int y) {
        this.drawStandardBox(mouseX, mouseY, x, y, 20);
    }

    private void drawBooleanBox(int mouseX, int mouseY, int x, int y, boolean itemvalue) {
        this.drawStandardBox(mouseX, mouseY, x, y, 0);
        if (itemvalue) {
            this.func_73729_b(this.getGuiLeft() + x + 2, this.getGuiTop() + y + 2, 0, 159, 6, 6);
        }
    }

    private void drawStandardBox(int mouseX, int mouseY, int x, int y, int srcX) {
        int targetX = this.getGuiLeft() + x;
        int targetY = this.getGuiTop() + y;
        int srcY = 149;
        this.func_73729_b(targetX, targetY, srcX, 149, 10, 10);
        if (this.inRect(mouseX, mouseY, new int[]{targetX, targetY, 10, 10})) {
            this.func_73729_b(targetX, targetY, 30, 149, 10, 10);
        }
    }

    private boolean clickBox(int mouseX, int mouseY, int x, int y) {
        return this.inRect(mouseX, mouseY, new int[]{x, y, 10, 10});
    }

    @Override
    public void mouseMoved(int x0, int y0, int button) {
        super.mouseMoved(x0, y0, button);
        int x = x0 - this.getGuiLeft();
        int y = y0 - this.getGuiTop();
        if (this.dropdownX != -1 && this.dropdownY != -1) {
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            for (int i = 0; i < items.size(); ++i) {
                boolean insideRect;
                DropDownMenuItem item = items.get(i);
                boolean insideSubRect = false;
                if (item.hasSubmenu()) {
                    insideSubRect = this.inRect(x, y, item.getSubRect(this.dropdownX, this.dropdownY, i));
                    if (!insideSubRect && item.getIsSubMenuOpen()) {
                        item.setIsSubMenuOpen(false);
                    } else if (insideSubRect && !item.getIsSubMenuOpen()) {
                        item.setIsSubMenuOpen(true);
                    }
                }
                boolean bl = insideRect = insideSubRect || this.inRect(x, y, item.getRect(this.dropdownX, this.dropdownY, i));
                if (!insideRect && item.getIsLarge()) {
                    item.setIsLarge(false);
                    continue;
                }
                if (!insideRect || item.getIsLarge()) continue;
                item.setIsLarge(true);
            }
        }
        if (this.isScrolling) {
            if (button != -1) {
                this.isScrolling = false;
                this.assembler.setSpinning(true);
            } else {
                this.assembler.setYaw(this.assembler.getYaw() + (float)x - (float)this.scrollingX);
                this.assembler.setRoll(this.assembler.getRoll() + (float)y - (float)this.scrollingY);
                this.scrollingX = x;
                this.scrollingY = y;
            }
        }
    }

    @Override
    public void mouseClick(int x0, int y0, int button) {
        int y;
        int x;
        block14: {
            block15: {
                block16: {
                    block13: {
                        super.mouseClick(x0, y0, button);
                        x = x0 - this.getGuiLeft();
                        y = y0 - this.getGuiTop();
                        if (!this.inRect(x, y, this.assembleRect)) break block13;
                        PacketHandler.sendPacket(0, new byte[0]);
                        break block14;
                    }
                    if (!this.inRect(x, y, this.blackBackground)) break block15;
                    if (button != 0) break block16;
                    if (!this.isScrolling) {
                        this.scrollingX = x;
                        this.scrollingY = y;
                        this.isScrolling = true;
                        this.assembler.setSpinning(false);
                    }
                    break block14;
                }
                if (button != 1) break block14;
                this.dropdownX = x;
                this.dropdownY = y;
                if (this.dropdownY + this.assembler.getDropDown().size() * 20 <= 164) break block14;
                this.dropdownY = 164 - this.assembler.getDropDown().size() * 20;
                break block14;
            }
            ArrayList<SlotAssembler> slots = this.assembler.getSlots();
            for (int i = 1; i < slots.size(); ++i) {
                SlotAssembler slot = slots.get(i);
                int targetX = slot.getX() - 1;
                int targetY = slot.getY() - 1;
                int size = 18;
                if (!this.inRect(x, y, new int[]{targetX, targetY, 18, 18}) || slot.func_75211_c() == null || slot.func_75211_c().field_77994_a > 0) continue;
                PacketHandler.sendPacket(1, new byte[]{(byte)i});
            }
        }
        if (button == 0 && this.dropdownX != -1 && this.dropdownY != -1) {
            boolean anyLargeItem = false;
            ArrayList<DropDownMenuItem> items = this.assembler.getDropDown();
            block6: for (int j = 0; j < items.size(); ++j) {
                DropDownMenuItem item = items.get(j);
                if (!item.getIsLarge()) continue;
                anyLargeItem = true;
                int[] rect = item.getRect(this.dropdownX, this.dropdownY, j);
                int[] subrect = new int[]{};
                if (item.hasSubmenu() && item.getIsSubMenuOpen()) {
                    subrect = item.getSubRect(this.dropdownX, this.dropdownY, j);
                }
                switch (item.getType()) {
                    case BOOL: {
                        if (!this.clickBox(x, y, 5 + rect[0], 5 + rect[1])) continue block6;
                        item.setBOOL(!item.getBOOL());
                        continue block6;
                    }
                    case INT: {
                        if (!item.getIsSubMenuOpen()) continue block6;
                        if (this.clickBox(x, y, this.getOffSetXForSubMenuBox(0, 2) + subrect[0], 3 + subrect[1])) {
                            item.setINT(item.getINT() + 1);
                        }
                        if (!this.clickBox(x, y, this.getOffSetXForSubMenuBox(1, 2) + subrect[0], 3 + subrect[1])) continue block6;
                        item.setINT(item.getINT() - 1);
                        continue block6;
                    }
                    case MULTIBOOL: {
                        if (!item.getIsSubMenuOpen()) continue block6;
                        int count = item.getMULTIBOOLCount();
                        for (int bool = 0; bool < count; ++bool) {
                            if (!this.clickBox(x, y, subrect[0] + this.getOffSetXForSubMenuBox(bool, count), subrect[1] + 3)) continue;
                            item.setMULTIBOOL(bool, !item.getMULTIBOOL(bool));
                            continue block6;
                        }
                        continue block6;
                    }
                }
            }
            if (!anyLargeItem) {
                int n = -1;
                this.dropdownY = -1;
                this.dropdownX = -1;
            }
        }
    }

    static {
        for (int i = 0; i < backgrounds.length; ++i) {
            GuiCartAssembler.backgrounds[i] = ResourceHelper.getResource("/gui/garageBackground" + i + ".png");
        }
        textureLeft = ResourceHelper.getResource("/gui/garagePart1.png");
        textureRight = ResourceHelper.getResource("/gui/garagePart2.png");
        textureExtra = ResourceHelper.getResource("/gui/garageExtra.png");
    }

    private class TextWithColor {
        private String text;
        private int color;

        public TextWithColor(String text, int color) {
            this.text = text;
            this.color = color;
        }

        public String getText() {
            return this.text;
        }

        public int getColor() {
            return this.color;
        }
    }
}

