/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.compat.ic2;

import ic2.core.block.BlockRubWood;
import ic2.core.item.type.MiscResourceType;
import ic2.core.ref.ItemName;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import vswe.stevescarts.api.farms.EnumHarvestResult;
import vswe.stevescarts.api.farms.ITreeProduceModule;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.workers.tools.ModuleTreeTap;
import vswe.stevescarts.modules.workers.tools.ModuleWoodcutter;

public class IC2RubberTreeModule
implements ITreeProduceModule {
    public static final ResourceLocation IC2_SAPLING_NAME = new ResourceLocation("ic2", "sapling");
    public static final ResourceLocation IC2_LEAF_NAME = new ResourceLocation("ic2", "leaves");
    public static final ResourceLocation IC2_LOG_NAME = new ResourceLocation("ic2", "rubber_wood");

    @Override
    public EnumHarvestResult isLeaves(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        if (blockState.func_177230_c().getRegistryName().equals((Object)IC2_LEAF_NAME)) {
            if (cart.hasModule(ModuleTreeTap.class)) {
                return EnumHarvestResult.DISALLOW;
            }
            return EnumHarvestResult.ALLOW;
        }
        return EnumHarvestResult.SKIP;
    }

    @Override
    public EnumHarvestResult isWood(IBlockState blockState, BlockPos pos, EntityMinecartModular cart) {
        if (blockState.func_177230_c().getRegistryName().equals((Object)IC2_LOG_NAME)) {
            return EnumHarvestResult.ALLOW;
        }
        return EnumHarvestResult.SKIP;
    }

    @Override
    public boolean isSapling(ItemStack itemStack) {
        return itemStack.func_77973_b().getRegistryName().equals((Object)IC2_SAPLING_NAME);
    }

    @Override
    public boolean plantSapling(World world, BlockPos pos, ItemStack stack, FakePlayer fakePlayer) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block.func_176196_c(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), block.func_176223_P());
            return true;
        }
        return false;
    }

    @Override
    public boolean harvest(IBlockState blockState, BlockPos pos, EntityMinecartModular cart, List<ItemStack> drops, boolean simulate, ModuleWoodcutter woodcutter) {
        if (!cart.hasModule(ModuleTreeTap.class)) {
            return false;
        }
        BlockPos workPos = pos;
        IBlockState workSate = cart.field_70170_p.func_180495_p(workPos);
        boolean foundBlock = false;
        while (this.isWood(workSate, workPos, cart) == EnumHarvestResult.ALLOW) {
            if (!(workSate.func_177230_c() instanceof BlockRubWood)) continue;
            foundBlock = true;
            BlockRubWood.RubberWoodState rubberWoodState = (BlockRubWood.RubberWoodState)workSate.func_177229_b((IProperty)BlockRubWood.stateProperty);
            if (!rubberWoodState.isPlain() && rubberWoodState.wet) {
                drops.add(ItemName.misc_resource.getItemStack((Enum)MiscResourceType.resin).func_77946_l());
                if (!simulate) {
                    cart.field_70170_p.func_175656_a(workPos, workSate.func_177226_a((IProperty)BlockRubWood.stateProperty, (Comparable)rubberWoodState.getDry()));
                    woodcutter.damageTool(1);
                    woodcutter.startWorking(20);
                }
            }
            workPos = workPos.func_177984_a();
            workSate = cart.field_70170_p.func_180495_p(workPos);
        }
        return foundBlock;
    }
}

