/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiUpgrade;
import vswe.stevescarts.helpers.NBTHelper;
import vswe.stevescarts.helpers.storages.ITankHolder;
import vswe.stevescarts.helpers.storages.Tank;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.InterfaceEffect;
import vswe.stevescarts.upgrades.InventoryEffect;

public class TileEntityUpgrade
extends TileEntityBase
implements IInventory,
ISidedInventory,
IFluidHandler,
IFluidTank,
ITankHolder,
ITickable {
    public Tank tank = new Tank(this, 0, 0);
    private TileEntityCartAssembler master;
    private int type;
    private boolean initialized;
    private NBTTagCompound comp;
    ItemStack[] inventoryStacks;
    private int[] slotsForSide;
    BlockUpgrade blockUpgrade = (BlockUpgrade)ModBlocks.UPGRADE.getBlock();
    boolean shouldSetType;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiUpgrade(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerUpgrade((IInventory)inv, this);
    }

    public void setMaster(TileEntityCartAssembler master, EnumFacing side) {
        this.master = master;
        if (side != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.blockUpgrade.func_176223_P().func_177226_a((IProperty)BlockUpgrade.FACING, (Comparable)side).func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(this.getType())));
        } else {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.blockUpgrade.func_176223_P().func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(this.getType())));
        }
    }

    public EnumFacing getSide() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockUpgrade.FACING);
    }

    public TileEntityCartAssembler getMaster() {
        return this.master;
    }

    public void setType(int type) {
        this.setType(type, true);
    }

    public void setType(int type, boolean setBlockState) {
        this.type = type;
        if (setBlockState) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.blockUpgrade.func_176223_P().func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(type)).func_177226_a((IProperty)BlockUpgrade.FACING, (Comparable)this.getSide()));
        }
        if (!this.initialized) {
            this.initialized = true;
            AssemblerUpgrade upgrade = this.getUpgrade();
            if (upgrade != null) {
                this.comp = new NBTTagCompound();
                this.slotsForSide = new int[upgrade.getInventorySize()];
                upgrade.init(this);
                if (upgrade.getInventorySize() > 0) {
                    this.inventoryStacks = new ItemStack[upgrade.getInventorySize()];
                    for (int i = 0; i < this.slotsForSide.length; ++i) {
                        this.slotsForSide[i] = i;
                    }
                }
            } else {
                this.inventoryStacks = null;
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public NBTTagCompound getCompound() {
        return this.comp;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, var1);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public AssemblerUpgrade getUpgrade() {
        return AssemblerUpgrade.getUpgrade(this.type);
    }

    public boolean hasInventory() {
        return this.inventoryStacks != null;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setType(tagCompound.func_74771_c("Type"), false);
        this.shouldSetType = true;
        NBTTagList items = tagCompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            ItemStack iStack = ItemStack.func_77949_a((NBTTagCompound)item);
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, iStack);
        }
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.load(this, tagCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList items = new NBTTagList();
        if (this.inventoryStacks != null) {
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                ItemStack iStack = this.inventoryStacks[i];
                if (iStack == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74774_a("Slot", (byte)i);
                iStack.func_77955_b(item);
                items.func_74742_a((NBTBase)item);
            }
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
        tagCompound.func_74774_a("Type", (byte)this.type);
        AssemblerUpgrade upgrade = this.getUpgrade();
        if (upgrade != null) {
            upgrade.save(this, tagCompound);
        }
        return tagCompound;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void updateEntity() {
        if (this.getUpgrade() != null && this.getMaster() != null) {
            this.getUpgrade().update(this);
        }
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, true);
        }
    }

    @Override
    public void checkGuiData(Container con, IContainerListener crafting) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.checkGuiData(this, (ContainerUpgrade)con, crafting, false);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        InterfaceEffect gui;
        if (this.getUpgrade() != null && (gui = this.getUpgrade().getInterfaceEffect()) != null) {
            gui.receiveGuiData(this, id, data);
        }
    }

    public int func_70302_i_() {
        if (this.inventoryStacks != null) {
            return this.inventoryStacks.length;
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70301_a(i);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventoryStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70298_a(i, j);
        }
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].field_77994_a <= j) {
            ItemStack itemstack = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            this.func_70296_d();
            return itemstack;
        }
        ItemStack itemstack2 = this.inventoryStacks[i].func_77979_a(j);
        if (this.inventoryStacks[i].field_77994_a == 0) {
            this.inventoryStacks[i] = null;
        }
        this.func_70296_d();
        return itemstack2;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.inventoryStacks == null) {
            if (this.master != null) {
                this.master.func_70299_a(i, itemstack);
            }
        } else {
            if (i < 0 || i >= this.func_70302_i_()) {
                return;
            }
            this.inventoryStacks[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
        }
    }

    public String getInventoryName() {
        return "container.assemblerupgrade";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void closeInventory() {
    }

    public void openInventory() {
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        if (this.inventoryStacks == null) {
            if (this.master == null) {
                return null;
            }
            return this.master.func_70301_a(i);
        }
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
            return item;
        }
        return null;
    }

    public void func_70296_d() {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            inv.onInventoryChanged(this);
        }
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return inv.isItemValid(slot, item);
        }
        return this.getMaster() != null && this.getMaster().func_94041_b(slot, item);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.func_94041_b(slot, item);
        }
        return this.getMaster() != null && this.getMaster().func_180462_a(slot, item, side);
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return true;
        }
        return this.getMaster() != null && this.getMaster().func_180461_b(slot, item, side);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource != null && resource.isFluidEqual(this.getFluid())) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack getFluid() {
        if (this.tank == null) {
            return null;
        }
        return this.tank.getFluid();
    }

    public int getCapacity() {
        if (this.tank == null) {
            return 0;
        }
        return this.tank.getCapacity();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.tank == null) {
            return 0;
        }
        int result = this.tank.fill(resource, doFill);
        return result;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tank == null) {
            return null;
        }
        FluidStack result = this.tank.drain(maxDrain, doDrain);
        return result;
    }

    @Override
    public ItemStack getInputContainer(int tankid) {
        return this.func_70301_a(0);
    }

    @Override
    public void clearInputContainer(int tankid) {
        this.func_70299_a(0, null);
    }

    @Override
    public void addToOutputContainer(int tankid, ItemStack item) {
        TransferHandler.TransferItem(item, this, 1, 1, new ContainerUpgrade(null, this), Slot.class, null, -1);
    }

    @Override
    public void onFluidUpdated(int tankid) {
    }

    @Override
    public void drawImage(int p0, GuiBase p1, int p3, int p4, int p5, int p6, int p7, int p8) {
    }

    public int getFluidAmount() {
        return this.tank == null ? 0 : this.tank.getFluidAmount();
    }

    public FluidTankInfo getInfo() {
        return this.tank == null ? null : this.tank.getInfo();
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public int[] func_180463_a(EnumFacing side) {
        InventoryEffect inv;
        if (this.getUpgrade() != null && (inv = this.getUpgrade().getInventoryEffect()) != null) {
            return this.slotsForSide;
        }
        if (this.getMaster() != null) {
            return this.getMaster().func_180463_a(side);
        }
        return new int[0];
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.shouldSetType) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockUpgrade.TYPE, (Comparable)Integer.valueOf(this.type)).func_177226_a((IProperty)BlockUpgrade.FACING, (Comparable)this.getSide()));
            this.shouldSetType = false;
        }
    }
}

