/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.items.ModItems;

public class BlockUpgrade
extends BlockContainerBase {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)20);

    public BlockUpgrade() {
        super(Material.field_151576_e);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)this.getSideFromint(meta));
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return 0;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            return side != EnumFacing.UP && upgrade.getType() == 13;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            upgrade.setType(stack.func_77952_i());
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).addUpgrade(world, pos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        if (player.field_71075_bZ.field_75098_d && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            upgrade.setType(1);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            if (upgrade.getUpgrade() != null) {
                upgrade.getUpgrade().removed(upgrade);
            }
            if (upgrade.getType() != 1) {
                BlockUpgrade.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Item)ModItems.upgrades, 1, upgrade.getType()));
            }
            if (upgrade.hasInventory()) {
                for (int var8 = 0; var8 < upgrade.func_70302_i_(); ++var8) {
                    ItemStack var9 = upgrade.getStackInSlotOnClosing(var8);
                    if (var9 == null) continue;
                    float var10 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float var11 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float var12 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    while (var9.field_77994_a > 0) {
                        int var13 = world.field_73012_v.nextInt(21) + 10;
                        if (var13 > var9.field_77994_a) {
                            var13 = var9.field_77994_a;
                        }
                        ItemStack itemStack = var9;
                        itemStack.field_77994_a -= var13;
                        EntityItem var14 = new EntityItem(world, (double)((float)pos.func_177958_n() + var10), (double)((float)pos.func_177956_o() + var11), (double)((float)pos.func_177952_p() + var12), new ItemStack(var9.func_77973_b(), var13, var9.func_77952_i()));
                        float var15 = 0.05f;
                        var14.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                        var14.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                        var14.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
                        if (var9.func_77942_o()) {
                            var14.func_92059_d().func_77982_d(var9.func_77978_p().func_74737_b());
                        }
                        world.func_72838_d((Entity)var14);
                    }
                }
            }
        }
        super.func_180663_b(world, pos, state);
        ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).removeUpgrade(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getUpgradeBounds(source, pos, state);
    }

    public final AxisAlignedBB getUpgradeBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        EnumFacing side = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
        float margin = 0.1875f;
        float width = 0.125f;
        if (side == EnumFacing.DOWN) {
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
        }
        if (side == EnumFacing.UP) {
            return new AxisAlignedBB(0.1875, 0.875, 0.1875, 0.8125, 1.0, 0.8125);
        }
        if (side == EnumFacing.WEST) {
            return new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.125, 0.8125, 0.8125);
        }
        if (side == EnumFacing.EAST) {
            return new AxisAlignedBB(0.875, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
        }
        if (side == EnumFacing.NORTH) {
            return new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.125);
        }
        if (side == EnumFacing.SOUTH) {
            return new AxisAlignedBB(0.1875, 0.1875, 0.875, 0.8125, 0.8125, 1.0);
        }
        return field_185505_j;
    }

    public AxisAlignedBB getIdleBlockBounds() {
        float margin = 0.1875f;
        float width = 0.125f;
        return new AxisAlignedBB(0.1875, 0.125, 0.1875, 0.8125, 0.875, 0.8125);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            if (upgrade.getMaster() == null) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (upgrade.getUpgrade().useStandardInterface()) {
                BlockPos masterPos = upgrade.getMaster().func_174877_v();
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)StevesCarts.instance, (int)3, (World)world, (int)masterPos.func_177958_n(), (int)masterPos.func_177956_o(), (int)masterPos.func_177952_p());
                return true;
            }
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)StevesCarts.instance, (int)7, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityUpgrade();
    }
}

