/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockContainerBase;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;

public class BlockCartAssembler
extends BlockContainerBase {
    public BlockCartAssembler() {
        super(Material.field_151576_e);
        this.func_149647_a(StevesCarts.tabsSC2Blocks);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entityplayer.func_70093_af()) {
            return false;
        }
        TileEntityCartAssembler assembler = (TileEntityCartAssembler)world.func_175625_s(pos);
        if (assembler != null) {
            if (!world.field_72995_K) {
                entityplayer.openGui((Object)StevesCarts.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void updateMultiBlock(World world, BlockPos pos) {
        TileEntityCartAssembler master = (TileEntityCartAssembler)world.func_175625_s(pos);
        if (master != null) {
            master.clearUpgrades();
        }
        this.checkForUpgrades(world, pos);
        if (!world.field_72995_K) {
            PacketHandler.sendBlockInfoToClients(world, new byte[0], pos);
        }
        if (master != null) {
            master.onUpgradeUpdate();
        }
    }

    private void checkForUpgrades(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            this.checkForUpgrade(world, pos.func_177972_a(facing), facing);
        }
    }

    private TileEntityCartAssembler checkForUpgrade(World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityUpgrade) {
            TileEntityUpgrade upgrade = (TileEntityUpgrade)tile;
            ArrayList<TileEntityCartAssembler> masters = this.getMasters(world, pos);
            if (masters.size() == 1) {
                TileEntityCartAssembler master = masters.get(0);
                master.addUpgrade(upgrade);
                upgrade.setMaster(master, facing);
                return master;
            }
            for (TileEntityCartAssembler master2 : masters) {
                master2.removeUpgrade(upgrade);
            }
            upgrade.setMaster(null, null);
        }
        return null;
    }

    private ArrayList<TileEntityCartAssembler> getMasters(World world, BlockPos pos) {
        ArrayList<TileEntityCartAssembler> masters = new ArrayList<TileEntityCartAssembler>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityCartAssembler temp;
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1 || (temp = this.getMaster(world, pos.func_177982_a(i, j, k))) == null) continue;
                    masters.add(temp);
                }
            }
        }
        return masters;
    }

    private TileEntityCartAssembler getValidMaster(World world, BlockPos pos) {
        TileEntityCartAssembler master = null;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntityCartAssembler temp;
                    if (Math.abs(i) + Math.abs(j) + Math.abs(k) != 1 || (temp = this.getMaster(world, pos.func_177982_a(i, j, k))) == null) continue;
                    if (master != null) {
                        return null;
                    }
                    master = temp;
                }
            }
        }
        return master;
    }

    private TileEntityCartAssembler getMaster(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityCartAssembler) {
            TileEntityCartAssembler master = (TileEntityCartAssembler)tile;
            if (!master.isDead) {
                return master;
            }
        }
        return null;
    }

    public void addUpgrade(World world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, master.func_174877_v());
        }
    }

    public void removeUpgrade(World world, BlockPos pos) {
        TileEntityCartAssembler master = this.getValidMaster(world, pos);
        if (master != null) {
            this.updateMultiBlock(world, pos);
        }
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityCartAssembler();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateMultiBlock(worldIn, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCartAssembler var7 = (TileEntityCartAssembler)world.func_175625_s(pos);
        var7.isDead = true;
        this.updateMultiBlock(world, pos);
        if (var7 != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70304_b(var8);
                if (var9 == null) continue;
                float var10 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var11 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float var12 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (var9.field_77994_a > 0) {
                    int var13 = world.field_73012_v.nextInt(21) + 10;
                    if (var13 > var9.field_77994_a) {
                        var13 = var9.field_77994_a;
                    }
                    ItemStack itemStack = var9;
                    itemStack.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(world, (double)((float)pos.func_177958_n() + var10), (double)((float)pos.func_177956_o() + var11), (double)((float)pos.func_177952_p() + var12), new ItemStack(var9.func_77973_b(), var13, var9.func_77952_i()));
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                    var14.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
                    var14.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d(var9.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)var14);
                }
            }
            ItemStack outputItem = var7.getOutputOnInterupt();
            if (outputItem != null) {
                EntityItem eItem = new EntityItem(world, (double)pos.func_177958_n() + (double)0.2f, (double)pos.func_177956_o() + (double)0.2f, (double)((float)pos.func_177952_p() + 0.2f), outputItem);
                eItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
                eItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.25f;
                eItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
                if (outputItem.func_77942_o()) {
                    eItem.func_92059_d().func_77982_d(outputItem.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)eItem);
            }
        }
        super.func_180663_b(world, pos, this.func_176223_P());
    }
}

