/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import vswe.stevescarts.CommonProxy;
import vswe.stevescarts.Constants;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.entitys.CartDataSerializers;
import vswe.stevescarts.entitys.EntityCake;
import vswe.stevescarts.entitys.EntityEasterEgg;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.handlers.EventHandler;
import vswe.stevescarts.handlers.EventHandlerChristmas;
import vswe.stevescarts.handlers.TradeHandler;
import vswe.stevescarts.helpers.CreativeTabSC2;
import vswe.stevescarts.helpers.GiftItem;
import vswe.stevescarts.items.ItemBlockStorage;
import vswe.stevescarts.items.ItemCartComponent;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.plugins.PluginLoader;
import vswe.stevescarts.upgrades.AssemblerUpgrade;

@Mod(modid="stevescarts", name="Steve's Carts 2", version="2.2.0.86", acceptedMinecraftVersions="[1.10.2]")
public class StevesCarts {
    @SidedProxy(clientSide="vswe.stevescarts.ClientProxy", serverSide="vswe.stevescarts.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="stevescarts")
    public static StevesCarts instance;
    public static CreativeTabSC2 tabsSC2;
    public static CreativeTabSC2 tabsSC2Components;
    public static CreativeTabSC2 tabsSC2Blocks;
    public int maxDynamites = 50;
    public boolean useArcadeSounds;
    public boolean useArcadeMobSounds;
    public static FMLEventChannel packetHandler;
    public static Logger logger;
    public TradeHandler tradeHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        packetHandler = NetworkRegistry.INSTANCE.newEventDrivenChannel("SC2");
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        SCConfig.load(config);
        this.maxDynamites = Math.min(this.maxDynamites, config.get("Settings", "MaximumNumberOfDynamites", this.maxDynamites).getInt(this.maxDynamites));
        this.useArcadeSounds = config.get("Settings", "useArcadeSounds", true).getBoolean(true);
        this.useArcadeMobSounds = config.get("Settings", "useTetrisMobSounds", true).getBoolean(true);
        ModItems.preBlockInit(config);
        ItemBlockStorage.init();
        ModBlocks.init();
        ModItems.postBlockInit(config);
        AssemblerUpgrade.init();
        this.initCart(0, EntityMinecartModular.class);
        EntityRegistry.registerModEntity(EntityEasterEgg.class, (String)"Egg.Vswe", (int)2, (Object)instance, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerModEntity(EntityCake.class, (String)"Cake.Vswe", (int)3, (Object)instance, (int)80, (int)3, (boolean)true);
        proxy.preInit();
        proxy.initItemModels();
        config.save();
        PluginLoader.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        packetHandler.register((Object)new PacketHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)new WoodFuelHandler());
        if (Constants.isChristmas) {
            this.tradeHandler = new TradeHandler();
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerChristmas());
        }
        GiftItem.init();
        AssemblerUpgrade.initRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.init();
        tabsSC2Blocks.setIcon(new ItemStack(ModBlocks.CART_ASSEMBLER.getBlock(), 1));
        TileEntityCargo.loadSelectionSettings();
        ModItems.addRecipes();
        ModBlocks.addRecipes();
        CartDataSerializers.init();
        PluginLoader.init(evt);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        proxy.loadComplete();
    }

    private void initCart(int ID, Class<? extends EntityMinecartModular> cart) {
        EntityRegistry.registerModEntity(cart, (String)("Minecart.Vswe." + ID), (int)ID, (Object)instance, (int)80, (int)3, (boolean)true);
    }

    static {
        tabsSC2 = new CreativeTabSC2("SC2Modules");
        tabsSC2Components = new CreativeTabSC2("SC2Items");
        tabsSC2Blocks = new CreativeTabSC2("SC2Blocks");
    }

    public class WoodFuelHandler
    implements IFuelHandler {
        public int getBurnTime(ItemStack fuel) {
            if (fuel != null && fuel.func_77973_b() != null && fuel.func_77973_b() == ModItems.component) {
                if (ItemCartComponent.isWoodLog(fuel)) {
                    return 150;
                }
                if (ItemCartComponent.isWoodTwig(fuel)) {
                    return 50;
                }
            }
            return 0;
        }
    }
}

