/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;

public class PacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        int idForCrash = -1;
        try {
            byte[] bytes = event.getPacket().payload().array();
            ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])bytes);
            byte by = reader.readByte();
            idForCrash = by;
            byte id = by;
            if (id == -1) {
                int x = reader.readInt();
                int y = reader.readInt();
                int z = reader.readInt();
                int len = bytes.length - 13;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                World world = player.field_70170_p;
                ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).updateMultiBlock(world, new BlockPos(x, y, z));
            } else {
                int entityid = reader.readInt();
                int len2 = bytes.length - 5;
                byte[] data2 = new byte[len2];
                for (int j = 0; j < len2; ++j) {
                    data2[j] = reader.readByte();
                }
                World world2 = player.field_70170_p;
                EntityMinecartModular cart = this.getCart(entityid, world2);
                if (cart != null) {
                    this.receivePacketAtCart(cart, id, data2, (EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("The client failed to process a packet with " + (idForCrash == -1 ? "unknown id" : "id " + idForCrash));
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        int idForCrash = -1;
        try {
            byte[] bytes = event.getPacket().payload().array();
            ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])bytes);
            byte by = reader.readByte();
            idForCrash = by;
            byte id = by;
            World world = player.field_70170_p;
            if (player.field_71070_bA instanceof ContainerPlayer) {
                int entityid = reader.readInt();
                int len = bytes.length - 5;
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = reader.readByte();
                }
                EntityMinecartModular cart = this.getCart(entityid, world);
                if (cart != null) {
                    this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
                }
            } else {
                ContainerBase conBase;
                TileEntityBase base;
                int len2 = bytes.length - 1;
                byte[] data2 = new byte[len2];
                for (int j = 0; j < len2; ++j) {
                    data2[j] = reader.readByte();
                }
                Container con = player.field_71070_bA;
                if (con instanceof ContainerMinecart) {
                    ContainerMinecart conMC = (ContainerMinecart)con;
                    EntityMinecartModular cart2 = conMC.cart;
                    this.receivePacketAtCart(cart2, id, data2, (EntityPlayer)player);
                } else if (con instanceof ContainerBase && (base = (conBase = (ContainerBase)con).getTileEntity()) != null) {
                    base.receivePacket(id, data2, (EntityPlayer)player);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("The server failed to process a packet with " + (idForCrash == -1 ? "unknown id" : "id " + idForCrash));
        }
    }

    private void receivePacketAtCart(EntityMinecartModular cart, int id, byte[] data, EntityPlayer player) {
        for (ModuleBase module : cart.getModules()) {
            if (id < module.getPacketStart() || id >= module.getPacketStart() + module.totalNumberOfPackets()) continue;
            module.delegateReceivedPacket(id - module.getPacketStart(), data, player);
            break;
        }
    }

    private EntityMinecartModular getCart(int ID, World world) {
        for (Object e : world.field_72996_f) {
            if (!(e instanceof Entity) || ((Entity)e).func_145782_y() != ID || !(e instanceof EntityMinecartModular)) continue;
            return (EntityMinecartModular)((Object)e);
        }
        return null;
    }

    public static void sendPacket(int id, byte[] extraData) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            for (byte b : extraData) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToServer(PacketHandler.createPacket(bs.toByteArray()));
    }

    private static FMLProxyPacket createPacket(byte[] bytes) {
        ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
        return new FMLProxyPacket(new PacketBuffer(buf), "SC2");
    }

    public static void sendPacket(EntityMinecartModular cart, int id, byte[] extraData) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            ds.writeInt(cart.func_145782_y());
            for (byte b : extraData) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToServer(PacketHandler.createPacket(bs.toByteArray()));
    }

    public static void sendPacketToPlayer(int id, byte[] data, EntityPlayer player, EntityMinecartModular cart) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            ds.writeInt(cart.func_145782_y());
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendTo(PacketHandler.createPacket(bs.toByteArray()), (EntityPlayerMP)player);
    }

    public static void sendBlockInfoToClients(World world, byte[] data, BlockPos pos) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte(-1);
            ds.writeInt(pos.func_177958_n());
            ds.writeInt(pos.func_177956_o());
            ds.writeInt(pos.func_177952_p());
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StevesCarts.packetHandler.sendToAllAround(PacketHandler.createPacket(bs.toByteArray()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }
}

