/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vswe.stevescarts.CommonProxy;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.handlers.SoundHandler;
import vswe.stevescarts.helpers.DetectorType;
import vswe.stevescarts.helpers.MinecartSoundMuter;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.renders.ItemStackRenderer;
import vswe.stevescarts.renders.RendererCart;
import vswe.stevescarts.renders.model.ItemModelManager;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        ModuleData.initModels();
        ModelLoader.setCustomStateMapper((Block)ModBlocks.UPGRADE.getBlock(), (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b();
                String propertyString = this.func_178131_a((Map)state.func_177228_b());
                return new ModelResourceLocation(resourceDomain + ":upgrade", propertyString);
            }
        });
    }

    @Override
    public void preInit() {
        ItemModelManager.load();
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartModular.class, (IRenderFactory)new RenderManagerCart());
        new SoundHandler();
        new MinecartSoundMuter();
    }

    @Override
    public void loadComplete() {
        super.loadComplete();
        TileEntityItemStackRenderer.field_147719_a = new ItemStackRenderer(TileEntityItemStackRenderer.field_147719_a);
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void initItemModels() {
        ModelResourceLocation location;
        int i;
        ClientProxy.registerItemModel(ModBlocks.CART_ASSEMBLER.getBlock(), 0);
        ClientProxy.registerItemModel(ModBlocks.CARGO_MANAGER.getBlock(), 0);
        ClientProxy.registerItemModel((Item)ModItems.carts, 0);
        ClientProxy.registerItemModel(ModBlocks.LIQUID_MANAGER.getBlock(), 0);
        for (i = 0; i < 3; ++i) {
            location = new ModelResourceLocation("stevescarts:BlockMetalStorage", "type=" + i);
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.storages, (int)i, (ModelResourceLocation)location);
        }
        ClientProxy.registerItemModel(ModBlocks.JUNCTION.getBlock(), 0);
        ClientProxy.registerItemModel(ModBlocks.ADVANCED_DETECTOR.getBlock(), 0);
        ClientProxy.registerItemModel(ModBlocks.MODULE_TOGGLER.getBlock(), 0);
        ClientProxy.registerItemModel(ModBlocks.EXTERNAL_DISTRIBUTOR.getBlock(), 0);
        ClientProxy.registerItemModel(ModBlocks.DETECTOR_UNIT.getBlock(), 0);
        for (i = 0; i < 5; ++i) {
            location = new ModelResourceLocation("stevescarts:BlockDetector", "detectortype=" + DetectorType.getTypeFromint(i).func_176610_l() + ",powered=false");
            ModelLoader.setCustomModelResourceLocation((Item)ModItems.detectors, (int)i, (ModelResourceLocation)location);
        }
    }

    public static void registerItemModel(Item i, int meta) {
        ResourceLocation loc = i.getRegistryName();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    public static void registerItemModel(Block b, int meta) {
        ClientProxy.registerItemModel(Item.func_150898_a((Block)b), meta);
    }

    public class RenderManagerCart
    implements IRenderFactory<EntityMinecartModular> {
        public Render<? super EntityMinecartModular> createRenderFor(RenderManager manager) {
            return new RendererCart(manager);
        }
    }
}

