/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.tools.WorldTools;
import mcjty.xnet.multiblock.WorldBlob;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class XNetBlobData
extends WorldSavedData {
    public static final String NAME = "XNetBlobData";
    private static XNetBlobData instance = null;
    private final Map<Integer, WorldBlob> worldBlobMap = new HashMap<Integer, WorldBlob>();

    public XNetBlobData(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        WorldTools.saveData((World)world, (String)NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static void clearInstance() {
        if (instance != null) {
            XNetBlobData.instance.worldBlobMap.clear();
            instance = null;
        }
    }

    @Nonnull
    public static XNetBlobData getBlobData(World world) {
        if (world.field_72995_K) {
            throw new RuntimeException("Don't access this client-side!");
        }
        if (instance != null) {
            return instance;
        }
        instance = (XNetBlobData)WorldTools.loadData((World)world, XNetBlobData.class, (String)NAME);
        if (instance == null) {
            instance = new XNetBlobData(NAME);
        }
        return instance;
    }

    public WorldBlob getWorldBlob(World world) {
        int dimId = world.field_73011_w.getDimension();
        if (!this.worldBlobMap.containsKey(dimId)) {
            this.worldBlobMap.put(dimId, new WorldBlob(dimId));
        }
        return this.worldBlobMap.get(dimId);
    }

    public void func_76184_a(NBTTagCompound compound) {
        this.worldBlobMap.clear();
        if (compound.func_74764_b("worlds")) {
            NBTTagList worlds = (NBTTagList)compound.func_74781_a("worlds");
            for (int i = 0; i < worlds.func_74745_c(); ++i) {
                NBTTagCompound tc = (NBTTagCompound)worlds.func_179238_g(i);
                int id = tc.func_74762_e("dimid");
                WorldBlob blob = new WorldBlob(id);
                blob.readFromNBT(tc);
                this.worldBlobMap.put(id, blob);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, WorldBlob> entry : this.worldBlobMap.entrySet()) {
            WorldBlob blob = entry.getValue();
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("dimid", blob.getDimId());
            blob.writeToNBT(tc);
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("worlds", (NBTBase)list);
        return compound;
    }
}

